/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.service;

import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.thingsboard.server.common.data.ApiUsageState;
import org.thingsboard.server.common.data.ApiUsageStateValue;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.dao.exception.IncorrectParameterException;
import org.thingsboard.server.dao.service.AbstractServiceTest;
import org.thingsboard.server.dao.service.DaoSqlTest;
import org.thingsboard.server.dao.usagerecord.ApiUsageStateService;

@DaoSqlTest
public class ApiUsageStateServiceTest
extends AbstractServiceTest {
    @Autowired
    ApiUsageStateService apiUsageStateService;

    @Test
    public void testFindTenantApiUsageState() {
        ApiUsageState state = this.apiUsageStateService.findTenantApiUsageState(this.tenantId);
        Assert.assertNotNull((Object)state);
    }

    @Test
    public void testUpdate() {
        ApiUsageState state = this.apiUsageStateService.findTenantApiUsageState(this.tenantId);
        state.setTransportState(ApiUsageStateValue.DISABLED);
        ApiUsageState updated = this.apiUsageStateService.update(state);
        Assert.assertEquals((Object)ApiUsageStateValue.DISABLED, (Object)updated.getTransportState());
    }

    @Test
    public void testUpdateWithNullId() {
        ApiUsageState newState = new ApiUsageState();
        newState.setTenantId(this.tenantId);
        newState.setTransportState(ApiUsageStateValue.ENABLED);
        Assert.assertThrows(IncorrectParameterException.class, () -> this.apiUsageStateService.update(newState));
    }

    @Test
    public void testFindApiUsageStateByEntityId() {
        ApiUsageState state = this.apiUsageStateService.findApiUsageStateByEntityId((EntityId)this.tenantId);
        Assert.assertNotNull((Object)state);
    }

    @Test
    public void testDeleteByTenantId() {
        ApiUsageState state = this.apiUsageStateService.findTenantApiUsageState(this.tenantId);
        Assert.assertNotNull((Object)state);
        this.apiUsageStateService.deleteByTenantId(this.tenantId);
        state = this.apiUsageStateService.findTenantApiUsageState(this.tenantId);
        Assert.assertNull((Object)state);
    }
}

