/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.service;

import com.datastax.oss.driver.api.core.uuid.Uuids;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.alarm.Alarm;
import org.thingsboard.server.common.data.alarm.AlarmApiCallResult;
import org.thingsboard.server.common.data.alarm.AlarmCreateOrUpdateActiveRequest;
import org.thingsboard.server.common.data.alarm.AlarmInfo;
import org.thingsboard.server.common.data.alarm.AlarmPropagationInfo;
import org.thingsboard.server.common.data.alarm.AlarmQuery;
import org.thingsboard.server.common.data.alarm.AlarmQueryV2;
import org.thingsboard.server.common.data.alarm.AlarmSearchStatus;
import org.thingsboard.server.common.data.alarm.AlarmSeverity;
import org.thingsboard.server.common.data.alarm.AlarmStatus;
import org.thingsboard.server.common.data.alarm.AlarmUpdateRequest;
import org.thingsboard.server.common.data.asset.Asset;
import org.thingsboard.server.common.data.id.AssetId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.SortOrder;
import org.thingsboard.server.common.data.page.TimePageLink;
import org.thingsboard.server.common.data.query.AlarmCountQuery;
import org.thingsboard.server.common.data.query.AlarmDataPageLink;
import org.thingsboard.server.common.data.query.AlarmDataQuery;
import org.thingsboard.server.common.data.query.DeviceTypeFilter;
import org.thingsboard.server.common.data.query.EntityDataSortOrder;
import org.thingsboard.server.common.data.query.EntityFilter;
import org.thingsboard.server.common.data.query.EntityKey;
import org.thingsboard.server.common.data.query.EntityKeyType;
import org.thingsboard.server.common.data.query.EntityListFilter;
import org.thingsboard.server.common.data.relation.EntityRelation;
import org.thingsboard.server.common.data.relation.RelationTypeGroup;
import org.thingsboard.server.common.data.security.Authority;
import org.thingsboard.server.dao.alarm.AlarmService;
import org.thingsboard.server.dao.asset.AssetService;
import org.thingsboard.server.dao.customer.CustomerService;
import org.thingsboard.server.dao.device.DeviceService;
import org.thingsboard.server.dao.relation.RelationService;
import org.thingsboard.server.dao.service.AbstractServiceTest;
import org.thingsboard.server.dao.service.DaoSqlTest;
import org.thingsboard.server.dao.user.UserService;

@DaoSqlTest
public class AlarmServiceTest
extends AbstractServiceTest {
    @Autowired
    AlarmService alarmService;
    @Autowired
    AssetService assetService;
    @Autowired
    CustomerService customerService;
    @Autowired
    DeviceService deviceService;
    @Autowired
    RelationService relationService;
    @Autowired
    UserService userService;
    public static final String TEST_ALARM = "TEST_ALARM";
    private static final String TEST_TENANT_EMAIL = "testtenant@thingsboard.org";
    private static final String TEST_TENANT_FIRST_NAME = "testtenantfirstname";
    private static final String TEST_TENANT_LAST_NAME = "testtenantlastname";

    @Test
    public void testSaveAndFetchAlarm() throws ExecutionException, InterruptedException {
        AssetId parentId = new AssetId(Uuids.timeBased());
        AssetId childId = new AssetId(Uuids.timeBased());
        EntityRelation relation = new EntityRelation((EntityId)parentId, (EntityId)childId, "Contains");
        Assert.assertTrue((boolean)((Boolean)this.relationService.saveRelationAsync(this.tenantId, relation).get()));
        long ts = System.currentTimeMillis();
        AlarmApiCallResult result = this.alarmService.createAlarm(AlarmCreateOrUpdateActiveRequest.builder().tenantId(this.tenantId).originator((EntityId)childId).type(TEST_ALARM).severity(AlarmSeverity.CRITICAL).startTs(ts).build());
        AlarmInfo created = result.getAlarm();
        Assert.assertNotNull((Object)created);
        Assert.assertNotNull((Object)created.getId());
        Assert.assertNotNull((Object)created.getOriginator());
        Assert.assertNotNull((Object)created.getSeverity());
        Assert.assertNotNull((Object)created.getStatus());
        Assert.assertEquals((Object)this.tenantId, (Object)created.getTenantId());
        Assert.assertEquals((Object)childId, (Object)created.getOriginator());
        Assert.assertEquals((Object)TEST_ALARM, (Object)created.getType());
        Assert.assertEquals((Object)AlarmSeverity.CRITICAL, (Object)created.getSeverity());
        Assert.assertEquals((Object)AlarmStatus.ACTIVE_UNACK, (Object)created.getStatus());
        Assert.assertEquals((long)ts, (long)created.getStartTs());
        Assert.assertEquals((long)ts, (long)created.getEndTs());
        Assert.assertEquals((long)0L, (long)created.getAckTs());
        Assert.assertEquals((long)0L, (long)created.getClearTs());
        AlarmInfo fetched = this.alarmService.findAlarmInfoById(this.tenantId, created.getId());
        Assert.assertEquals((Object)created, (Object)fetched);
    }

    @Test
    public void testFindAlarm() throws ExecutionException, InterruptedException {
        AssetId parentId = new AssetId(Uuids.timeBased());
        AssetId childId = new AssetId(Uuids.timeBased());
        EntityRelation relation = new EntityRelation((EntityId)parentId, (EntityId)childId, "Contains");
        Assert.assertTrue((boolean)((Boolean)this.relationService.saveRelationAsync(this.tenantId, relation).get()));
        long ts = System.currentTimeMillis();
        AlarmApiCallResult result = this.alarmService.createAlarm(AlarmCreateOrUpdateActiveRequest.builder().tenantId(this.tenantId).originator((EntityId)childId).type(TEST_ALARM).severity(AlarmSeverity.CRITICAL).startTs(ts).build());
        AlarmInfo created = result.getAlarm();
        PageData alarms = this.alarmService.findAlarms(this.tenantId, AlarmQuery.builder().affectedEntityId((EntityId)childId).status(AlarmStatus.ACTIVE_UNACK).pageLink(new TimePageLink(1, 0, "", new SortOrder("createdTime", SortOrder.Direction.DESC), Long.valueOf(0L), Long.valueOf(System.currentTimeMillis()))).build());
        Assert.assertNotNull((Object)alarms.getData());
        Assert.assertEquals((long)1L, (long)alarms.getData().size());
        Assert.assertEquals((Object)created, (Object)new AlarmInfo((AlarmInfo)alarms.getData().get(0)));
        alarms = this.alarmService.findAlarms(this.tenantId, AlarmQuery.builder().affectedEntityId((EntityId)parentId).status(AlarmStatus.ACTIVE_UNACK).pageLink(new TimePageLink(1, 0, "", new SortOrder("createdTime", SortOrder.Direction.DESC), Long.valueOf(0L), Long.valueOf(System.currentTimeMillis()))).build());
        Assert.assertNotNull((Object)alarms.getData());
        Assert.assertEquals((long)0L, (long)alarms.getData().size());
        created.setPropagate(true);
        result = this.alarmService.updateAlarm(AlarmUpdateRequest.fromAlarm((Alarm)created));
        created = result.getAlarm();
        alarms = this.alarmService.findAlarms(this.tenantId, AlarmQuery.builder().affectedEntityId((EntityId)childId).status(AlarmStatus.ACTIVE_UNACK).pageLink(new TimePageLink(1, 0, "", new SortOrder("createdTime", SortOrder.Direction.DESC), Long.valueOf(0L), Long.valueOf(System.currentTimeMillis()))).build());
        Assert.assertNotNull((Object)alarms.getData());
        Assert.assertEquals((long)1L, (long)alarms.getData().size());
        Assert.assertEquals((Object)created, (Object)new AlarmInfo((AlarmInfo)alarms.getData().get(0)));
        alarms = this.alarmService.findAlarms(this.tenantId, AlarmQuery.builder().affectedEntityId((EntityId)parentId).status(AlarmStatus.ACTIVE_UNACK).pageLink(new TimePageLink(1, 0, "", new SortOrder("createdTime", SortOrder.Direction.DESC), Long.valueOf(0L), Long.valueOf(System.currentTimeMillis()))).build());
        Assert.assertNotNull((Object)alarms.getData());
        Assert.assertEquals((long)1L, (long)alarms.getData().size());
        Assert.assertEquals((Object)created, (Object)new AlarmInfo((AlarmInfo)alarms.getData().get(0)));
        this.alarmService.acknowledgeAlarm(this.tenantId, created.getId(), System.currentTimeMillis());
        created = this.alarmService.findAlarmInfoById(this.tenantId, created.getId());
        alarms = this.alarmService.findAlarms(this.tenantId, AlarmQuery.builder().affectedEntityId((EntityId)childId).status(AlarmStatus.ACTIVE_ACK).pageLink(new TimePageLink(1, 0, "", new SortOrder("createdTime", SortOrder.Direction.DESC), Long.valueOf(0L), Long.valueOf(System.currentTimeMillis()))).build());
        Assert.assertNotNull((Object)alarms.getData());
        Assert.assertEquals((long)1L, (long)alarms.getData().size());
        Assert.assertEquals((Object)created, (Object)new AlarmInfo((AlarmInfo)alarms.getData().get(0)));
        alarms = this.alarmService.findAlarms(this.tenantId, AlarmQuery.builder().affectedEntityId((EntityId)childId).status(AlarmStatus.ACTIVE_UNACK).pageLink(new TimePageLink(1, 0, "", new SortOrder("createdTime", SortOrder.Direction.DESC), Long.valueOf(0L), Long.valueOf(System.currentTimeMillis()))).build());
        Assert.assertNotNull((Object)alarms.getData());
        Assert.assertEquals((long)0L, (long)alarms.getData().size());
        this.alarmService.clearAlarm(this.tenantId, created.getId(), System.currentTimeMillis(), null);
        created = this.alarmService.findAlarmInfoById(this.tenantId, created.getId());
        alarms = this.alarmService.findAlarms(this.tenantId, AlarmQuery.builder().affectedEntityId((EntityId)childId).status(AlarmStatus.CLEARED_ACK).pageLink(new TimePageLink(1, 0, "", new SortOrder("createdTime", SortOrder.Direction.DESC), Long.valueOf(0L), Long.valueOf(System.currentTimeMillis()))).build());
        Assert.assertNotNull((Object)alarms.getData());
        Assert.assertEquals((long)1L, (long)alarms.getData().size());
        Assert.assertEquals((Object)created, (Object)new AlarmInfo((AlarmInfo)alarms.getData().get(0)));
    }

    @Test
    public void testFindAlarmV2() throws ExecutionException, InterruptedException {
        AssetId parentId = new AssetId(Uuids.timeBased());
        AssetId childId = new AssetId(Uuids.timeBased());
        EntityRelation relation = new EntityRelation((EntityId)parentId, (EntityId)childId, "Contains");
        Assert.assertTrue((boolean)((Boolean)this.relationService.saveRelationAsync(this.tenantId, relation).get()));
        long ts = System.currentTimeMillis();
        AlarmApiCallResult result = this.alarmService.createAlarm(AlarmCreateOrUpdateActiveRequest.builder().tenantId(this.tenantId).originator((EntityId)childId).type(TEST_ALARM).severity(AlarmSeverity.CRITICAL).startTs(ts).build());
        AlarmInfo created = result.getAlarm();
        PageData alarms = this.alarmService.findAlarmsV2(this.tenantId, AlarmQueryV2.builder().affectedEntityId((EntityId)childId).severityList(List.of(AlarmSeverity.CRITICAL)).statusList(List.of(AlarmSearchStatus.ACTIVE, AlarmSearchStatus.UNACK)).pageLink(new TimePageLink(1, 0, "", new SortOrder("createdTime", SortOrder.Direction.DESC), Long.valueOf(0L), Long.valueOf(System.currentTimeMillis()))).build());
        Assert.assertNotNull((Object)alarms.getData());
        Assert.assertEquals((long)1L, (long)alarms.getData().size());
        Assert.assertEquals((Object)created, (Object)new AlarmInfo((AlarmInfo)alarms.getData().get(0)));
        alarms = this.alarmService.findAlarmsV2(this.tenantId, AlarmQueryV2.builder().affectedEntityId((EntityId)parentId).severityList(List.of(AlarmSeverity.CRITICAL)).statusList(List.of(AlarmSearchStatus.ACTIVE, AlarmSearchStatus.UNACK)).pageLink(new TimePageLink(1, 0, "", new SortOrder("createdTime", SortOrder.Direction.DESC), Long.valueOf(0L), Long.valueOf(System.currentTimeMillis()))).build());
        Assert.assertNotNull((Object)alarms.getData());
        Assert.assertEquals((long)0L, (long)alarms.getData().size());
        created.setPropagate(true);
        result = this.alarmService.updateAlarm(AlarmUpdateRequest.fromAlarm((Alarm)created));
        created = result.getAlarm();
        alarms = this.alarmService.findAlarmsV2(this.tenantId, AlarmQueryV2.builder().affectedEntityId((EntityId)childId).severityList(List.of(AlarmSeverity.CRITICAL)).statusList(List.of(AlarmSearchStatus.ACTIVE, AlarmSearchStatus.UNACK)).pageLink(new TimePageLink(1, 0, "", new SortOrder("createdTime", SortOrder.Direction.DESC), Long.valueOf(0L), Long.valueOf(System.currentTimeMillis()))).build());
        Assert.assertNotNull((Object)alarms.getData());
        Assert.assertEquals((long)1L, (long)alarms.getData().size());
        Assert.assertEquals((Object)created, (Object)new AlarmInfo((AlarmInfo)alarms.getData().get(0)));
        alarms = this.alarmService.findAlarmsV2(this.tenantId, AlarmQueryV2.builder().affectedEntityId((EntityId)parentId).severityList(List.of(AlarmSeverity.CRITICAL)).statusList(List.of(AlarmSearchStatus.ACTIVE, AlarmSearchStatus.UNACK)).pageLink(new TimePageLink(1, 0, "", new SortOrder("createdTime", SortOrder.Direction.DESC), Long.valueOf(0L), Long.valueOf(System.currentTimeMillis()))).build());
        Assert.assertNotNull((Object)alarms.getData());
        Assert.assertEquals((long)1L, (long)alarms.getData().size());
        Assert.assertEquals((Object)created, (Object)new AlarmInfo((AlarmInfo)alarms.getData().get(0)));
        this.alarmService.acknowledgeAlarm(this.tenantId, created.getId(), System.currentTimeMillis());
        created = this.alarmService.findAlarmInfoById(this.tenantId, created.getId());
        alarms = this.alarmService.findAlarmsV2(this.tenantId, AlarmQueryV2.builder().affectedEntityId((EntityId)childId).severityList(List.of(AlarmSeverity.CRITICAL)).statusList(List.of(AlarmSearchStatus.ACTIVE, AlarmSearchStatus.ACK)).pageLink(new TimePageLink(1, 0, "", new SortOrder("createdTime", SortOrder.Direction.DESC), Long.valueOf(0L), Long.valueOf(System.currentTimeMillis()))).build());
        Assert.assertNotNull((Object)alarms.getData());
        Assert.assertEquals((long)1L, (long)alarms.getData().size());
        Assert.assertEquals((Object)created, (Object)new AlarmInfo((AlarmInfo)alarms.getData().get(0)));
        alarms = this.alarmService.findAlarmsV2(this.tenantId, AlarmQueryV2.builder().affectedEntityId((EntityId)childId).severityList(List.of(AlarmSeverity.CRITICAL)).statusList(List.of(AlarmSearchStatus.ACTIVE, AlarmSearchStatus.UNACK)).pageLink(new TimePageLink(1, 0, "", new SortOrder("createdTime", SortOrder.Direction.DESC), Long.valueOf(0L), Long.valueOf(System.currentTimeMillis()))).build());
        Assert.assertNotNull((Object)alarms.getData());
        Assert.assertEquals((long)0L, (long)alarms.getData().size());
        this.alarmService.clearAlarm(this.tenantId, created.getId(), System.currentTimeMillis(), null);
        created = this.alarmService.findAlarmInfoById(this.tenantId, created.getId());
        alarms = this.alarmService.findAlarmsV2(this.tenantId, AlarmQueryV2.builder().affectedEntityId((EntityId)childId).severityList(List.of(AlarmSeverity.CRITICAL)).statusList(List.of(AlarmSearchStatus.CLEARED, AlarmSearchStatus.ACK)).pageLink(new TimePageLink(1, 0, "", new SortOrder("createdTime", SortOrder.Direction.DESC), Long.valueOf(0L), Long.valueOf(System.currentTimeMillis()))).build());
        Assert.assertNotNull((Object)alarms.getData());
        Assert.assertEquals((long)1L, (long)alarms.getData().size());
        Assert.assertEquals((Object)created, (Object)new AlarmInfo((AlarmInfo)alarms.getData().get(0)));
    }

    @Test
    public void testFindAssignedAlarm() {
        AssetId parentId = new AssetId(Uuids.timeBased());
        AssetId childId = new AssetId(Uuids.timeBased());
        EntityRelation relation = new EntityRelation((EntityId)parentId, (EntityId)childId, "Contains");
        Assert.assertNotNull((Object)this.relationService.saveRelation(this.tenantId, relation));
        long ts = System.currentTimeMillis();
        AlarmApiCallResult result = this.alarmService.createAlarm(AlarmCreateOrUpdateActiveRequest.builder().tenantId(this.tenantId).originator((EntityId)childId).type(TEST_ALARM).severity(AlarmSeverity.CRITICAL).startTs(ts).build());
        AlarmInfo created = result.getAlarm();
        User tenantUser = new User();
        tenantUser.setTenantId(this.tenantId);
        tenantUser.setAuthority(Authority.TENANT_ADMIN);
        tenantUser.setEmail(TEST_TENANT_EMAIL);
        tenantUser.setFirstName(TEST_TENANT_FIRST_NAME);
        tenantUser.setLastName(TEST_TENANT_LAST_NAME);
        tenantUser = this.userService.saveUser(TenantId.SYS_TENANT_ID, tenantUser);
        Assert.assertNotNull((Object)tenantUser);
        AlarmApiCallResult assignmentResult = this.alarmService.assignAlarm(this.tenantId, created.getId(), tenantUser.getId(), ts);
        created = assignmentResult.getAlarm();
        PageData alarms = this.alarmService.findAlarms(this.tenantId, AlarmQuery.builder().assigneeId(tenantUser.getId()).pageLink(new TimePageLink(1, 0, "", new SortOrder("createdTime", SortOrder.Direction.DESC), Long.valueOf(0L), Long.valueOf(System.currentTimeMillis()))).build());
        Assert.assertNotNull((Object)alarms.getData());
        Assert.assertEquals((long)1L, (long)alarms.getData().size());
        Assert.assertEquals((Object)created, alarms.getData().get(0));
        AlarmDataPageLink pageLink = new AlarmDataPageLink();
        pageLink.setPage(0);
        pageLink.setPageSize(10);
        pageLink.setAssigneeId(tenantUser.getId());
        pageLink.setSortOrder(new EntityDataSortOrder(new EntityKey(EntityKeyType.ALARM_FIELD, "assignee")));
        PageData assignedAlarms = this.alarmService.findAlarmDataByQueryForEntities(this.tenantId, this.toQuery(pageLink), Collections.singletonList(created.getOriginator()));
        Assert.assertNotNull((Object)assignedAlarms.getData());
        Assert.assertEquals((long)1L, (long)assignedAlarms.getData().size());
        Assert.assertEquals((Object)created, (Object)new AlarmInfo((AlarmInfo)assignedAlarms.getData().get(0)));
        User tenantUser2 = new User();
        tenantUser2.setTenantId(this.tenantId);
        tenantUser2.setAuthority(Authority.TENANT_ADMIN);
        tenantUser2.setEmail("2testtenant@thingsboard.org");
        tenantUser2.setFirstName(TEST_TENANT_FIRST_NAME);
        tenantUser2.setLastName(TEST_TENANT_LAST_NAME);
        tenantUser2 = this.userService.saveUser(TenantId.SYS_TENANT_ID, tenantUser2);
        Assert.assertNotNull((Object)tenantUser2);
        pageLink.setAssigneeId(tenantUser2.getId());
        PageData assignedToNonExistingUserAlarms = this.alarmService.findAlarmDataByQueryForEntities(this.tenantId, this.toQuery(pageLink), Collections.singletonList(created.getOriginator()));
        Assert.assertNotNull((Object)assignedToNonExistingUserAlarms.getData());
        Assert.assertTrue((boolean)assignedToNonExistingUserAlarms.getData().isEmpty());
    }

    @Test
    public void testFindCustomerAlarm() {
        Customer customer = new Customer();
        customer.setTitle("TestCustomer");
        customer.setTenantId(this.tenantId);
        customer = this.customerService.saveCustomer(customer);
        Device tenantDevice = new Device();
        tenantDevice.setName("TestTenantDevice");
        tenantDevice.setType("default");
        tenantDevice.setTenantId(this.tenantId);
        tenantDevice = this.deviceService.saveDevice(tenantDevice);
        Device customerDevice = new Device();
        customerDevice.setName("TestCustomerDevice");
        customerDevice.setType("default");
        customerDevice.setTenantId(this.tenantId);
        customerDevice.setCustomerId(customer.getId());
        customerDevice = this.deviceService.saveDevice(customerDevice);
        long ts = System.currentTimeMillis();
        AlarmApiCallResult result = this.alarmService.createAlarm(AlarmCreateOrUpdateActiveRequest.builder().tenantId(this.tenantId).originator((EntityId)tenantDevice.getId()).type(TEST_ALARM).severity(AlarmSeverity.CRITICAL).propagation(AlarmPropagationInfo.builder().propagate(true).build()).startTs(ts).build());
        AlarmInfo tenantAlarm = result.getAlarm();
        result = this.alarmService.createAlarm(AlarmCreateOrUpdateActiveRequest.builder().tenantId(this.tenantId).originator((EntityId)customerDevice.getId()).type(TEST_ALARM).severity(AlarmSeverity.CRITICAL).propagation(AlarmPropagationInfo.builder().propagate(true).build()).startTs(ts).build());
        AlarmInfo deviceAlarm = result.getAlarm();
        AlarmDataPageLink pageLink = new AlarmDataPageLink();
        pageLink.setPage(0);
        pageLink.setPageSize(10);
        pageLink.setSortOrder(new EntityDataSortOrder(new EntityKey(EntityKeyType.ALARM_FIELD, "createdTime")));
        pageLink.setStartTs(0L);
        pageLink.setEndTs(System.currentTimeMillis());
        pageLink.setSearchPropagatedAlarms(true);
        pageLink.setSeverityList(List.of(AlarmSeverity.CRITICAL, AlarmSeverity.WARNING));
        pageLink.setStatusList(List.of(AlarmSearchStatus.ACTIVE));
        PageData tenantAlarms = this.alarmService.findAlarmDataByQueryForEntities(this.tenantId, this.toQuery(pageLink), List.of(tenantDevice.getId(), customerDevice.getId()));
        Assert.assertEquals((long)2L, (long)tenantAlarms.getData().size());
        PageData customerAlarms = this.alarmService.findAlarmDataByQueryForEntities(this.tenantId, this.toQuery(pageLink), Collections.singletonList(customerDevice.getId()));
        Assert.assertEquals((long)1L, (long)customerAlarms.getData().size());
        Assert.assertEquals((Object)deviceAlarm, (Object)new AlarmInfo((AlarmInfo)customerAlarms.getData().get(0)));
        PageData alarms = this.alarmService.findAlarms(this.tenantId, AlarmQuery.builder().affectedEntityId((EntityId)tenantDevice.getId()).status(AlarmStatus.ACTIVE_UNACK).pageLink(new TimePageLink(10, 0, "", new SortOrder("createdTime", SortOrder.Direction.DESC), Long.valueOf(0L), Long.valueOf(System.currentTimeMillis()))).build());
        Assert.assertNotNull((Object)alarms.getData());
        Assert.assertEquals((long)1L, (long)alarms.getData().size());
        Assert.assertEquals((Object)tenantAlarm, (Object)new AlarmInfo((AlarmInfo)alarms.getData().get(0)));
    }

    @Test
    public void testFindPropagatedCustomerAssetAlarm() {
        Customer customer = new Customer();
        customer.setTitle("TestCustomer");
        customer.setTenantId(this.tenantId);
        customer = this.customerService.saveCustomer(customer);
        Device tenantDevice = new Device();
        tenantDevice.setName("TestTenantDevice");
        tenantDevice.setType("default");
        tenantDevice.setTenantId(this.tenantId);
        tenantDevice = this.deviceService.saveDevice(tenantDevice);
        Asset customerAsset = new Asset();
        customerAsset.setName("TestCustomerDevice");
        customerAsset.setType("default");
        customerAsset.setTenantId(this.tenantId);
        customerAsset.setCustomerId(customer.getId());
        customerAsset = this.assetService.saveAsset(customerAsset);
        EntityRelation relation = new EntityRelation();
        relation.setFrom((EntityId)customerAsset.getId());
        relation.setTo((EntityId)tenantDevice.getId());
        relation.setAdditionalInfo((JsonNode)JacksonUtil.newObjectNode());
        relation.setType("Contains");
        relation.setTypeGroup(RelationTypeGroup.COMMON);
        this.relationService.saveRelation(this.tenantId, relation);
        long ts = System.currentTimeMillis();
        this.alarmService.createAlarm(AlarmCreateOrUpdateActiveRequest.builder().tenantId(this.tenantId).originator((EntityId)tenantDevice.getId()).type("Not Propagated").severity(AlarmSeverity.CRITICAL).startTs(ts).build());
        AlarmApiCallResult result = this.alarmService.createAlarm(AlarmCreateOrUpdateActiveRequest.builder().tenantId(this.tenantId).originator((EntityId)tenantDevice.getId()).type("Propagated").severity(AlarmSeverity.CRITICAL).propagation(AlarmPropagationInfo.builder().propagate(true).build()).startTs(ts).build());
        AlarmInfo customerAlarm = result.getAlarm();
        AlarmDataPageLink pageLink = new AlarmDataPageLink();
        pageLink.setPage(0);
        pageLink.setPageSize(10);
        pageLink.setSortOrder(new EntityDataSortOrder(new EntityKey(EntityKeyType.ALARM_FIELD, "createdTime")));
        pageLink.setStartTs(0L);
        pageLink.setEndTs(System.currentTimeMillis());
        pageLink.setSearchPropagatedAlarms(true);
        pageLink.setSeverityList(List.of(AlarmSeverity.CRITICAL, AlarmSeverity.WARNING));
        pageLink.setStatusList(List.of(AlarmSearchStatus.ACTIVE));
        PageData customerAlarms = this.alarmService.findAlarmDataByQueryForEntities(this.tenantId, this.toQuery(pageLink), Collections.singletonList(customerAsset.getId()));
        Assert.assertEquals((long)1L, (long)customerAlarms.getData().size());
        Assert.assertEquals((Object)customerAlarm, (Object)new AlarmInfo((AlarmInfo)customerAlarms.getData().get(0)));
    }

    @Test
    public void testFindPropagatedToOwnerAndTenantAlarm() {
        Customer customer = new Customer();
        customer.setTitle("TestCustomer");
        customer.setTenantId(this.tenantId);
        customer = this.customerService.saveCustomer(customer);
        Device device = new Device();
        device.setName("TestTenantDevice");
        device.setType("default");
        device.setTenantId(this.tenantId);
        device.setCustomerId(customer.getId());
        device = this.deviceService.saveDevice(device);
        long ts = System.currentTimeMillis();
        AlarmApiCallResult result = this.alarmService.createAlarm(AlarmCreateOrUpdateActiveRequest.builder().tenantId(this.tenantId).originator((EntityId)device.getId()).type("Propagated To Tenant").severity(AlarmSeverity.CRITICAL).propagation(AlarmPropagationInfo.builder().propagateToTenant(true).build()).startTs(ts).build());
        AlarmInfo tenantAlarm = result.getAlarm();
        result = this.alarmService.createAlarm(AlarmCreateOrUpdateActiveRequest.builder().tenantId(this.tenantId).originator((EntityId)device.getId()).type("Propagated to Customer").severity(AlarmSeverity.CRITICAL).propagation(AlarmPropagationInfo.builder().propagateToOwner(true).build()).startTs(ts).build());
        AlarmInfo customerAlarm = result.getAlarm();
        AlarmDataPageLink pageLink = new AlarmDataPageLink();
        pageLink.setPage(0);
        pageLink.setPageSize(10);
        pageLink.setSortOrder(new EntityDataSortOrder(new EntityKey(EntityKeyType.ALARM_FIELD, "createdTime")));
        pageLink.setStartTs(0L);
        pageLink.setEndTs(System.currentTimeMillis());
        pageLink.setSearchPropagatedAlarms(true);
        pageLink.setSeverityList(List.of(AlarmSeverity.CRITICAL, AlarmSeverity.WARNING));
        pageLink.setStatusList(Collections.singletonList(AlarmSearchStatus.ACTIVE));
        PageData tenantAlarms = this.alarmService.findAlarmDataByQueryForEntities(this.tenantId, this.toQuery(pageLink), Collections.singletonList(this.tenantId));
        Assert.assertEquals((long)1L, (long)tenantAlarms.getData().size());
        Assert.assertEquals((Object)tenantAlarm, (Object)new AlarmInfo((AlarmInfo)tenantAlarms.getData().get(0)));
        PageData customerAlarms = this.alarmService.findAlarmDataByQueryForEntities(this.tenantId, this.toQuery(pageLink), Collections.singletonList(customer.getId()));
        Assert.assertEquals((long)1L, (long)customerAlarms.getData().size());
        Assert.assertEquals((Object)customerAlarm, (Object)new AlarmInfo((AlarmInfo)customerAlarms.getData().get(0)));
    }

    private AlarmDataQuery toQuery(AlarmDataPageLink pageLink) {
        return this.toQuery(pageLink, Collections.emptyList());
    }

    private AlarmDataQuery toQuery(AlarmDataPageLink pageLink, List<EntityKey> alarmFields) {
        return new AlarmDataQuery((EntityFilter)new DeviceTypeFilter(), pageLink, null, null, null, alarmFields);
    }

    @Test
    public void testFindHighestAlarmSeverity() {
        Customer customer = new Customer();
        customer.setTitle("TestCustomer");
        customer.setTenantId(this.tenantId);
        customer = this.customerService.saveCustomer(customer);
        Device customerDevice = new Device();
        customerDevice.setName("TestCustomerDevice");
        customerDevice.setType("default");
        customerDevice.setTenantId(this.tenantId);
        customerDevice.setCustomerId(customer.getId());
        customerDevice = this.deviceService.saveDevice(customerDevice);
        Assert.assertNull((Object)this.alarmService.findHighestAlarmSeverity(this.tenantId, (EntityId)customerDevice.getId(), null, null, null));
        AlarmApiCallResult result = this.alarmService.createAlarm(AlarmCreateOrUpdateActiveRequest.builder().tenantId(this.tenantId).originator((EntityId)customerDevice.getId()).type(TEST_ALARM).severity(AlarmSeverity.MAJOR).startTs(System.currentTimeMillis()).build());
        AlarmInfo alarm1 = result.getAlarm();
        this.alarmService.clearAlarm(this.tenantId, alarm1.getId(), System.currentTimeMillis(), null);
        result = this.alarmService.createAlarm(AlarmCreateOrUpdateActiveRequest.builder().tenantId(this.tenantId).originator((EntityId)customerDevice.getId()).type(TEST_ALARM).severity(AlarmSeverity.MINOR).startTs(System.currentTimeMillis()).build());
        AlarmInfo alarm2 = result.getAlarm();
        this.alarmService.acknowledgeAlarm(this.tenantId, alarm2.getId(), System.currentTimeMillis());
        this.alarmService.clearAlarm(this.tenantId, alarm2.getId(), System.currentTimeMillis(), null);
        result = this.alarmService.createAlarm(AlarmCreateOrUpdateActiveRequest.builder().tenantId(this.tenantId).originator((EntityId)customerDevice.getId()).type(TEST_ALARM).severity(AlarmSeverity.CRITICAL).startTs(System.currentTimeMillis()).build());
        AlarmInfo alarm3 = result.getAlarm();
        this.alarmService.acknowledgeAlarm(this.tenantId, alarm3.getId(), System.currentTimeMillis());
        Assert.assertEquals((Object)AlarmSeverity.MAJOR, (Object)this.alarmService.findHighestAlarmSeverity(this.tenantId, (EntityId)customerDevice.getId(), AlarmSearchStatus.UNACK, null, null));
        Assert.assertEquals((Object)AlarmSeverity.CRITICAL, (Object)this.alarmService.findHighestAlarmSeverity(this.tenantId, (EntityId)customerDevice.getId(), null, null, null));
        Assert.assertEquals((Object)AlarmSeverity.MAJOR, (Object)this.alarmService.findHighestAlarmSeverity(this.tenantId, (EntityId)customerDevice.getId(), null, AlarmStatus.CLEARED_UNACK, null));
        Assert.assertEquals((Object)AlarmSeverity.CRITICAL, (Object)this.alarmService.findHighestAlarmSeverity(this.tenantId, (EntityId)customerDevice.getId(), AlarmSearchStatus.ACTIVE, null, null));
        Assert.assertEquals((Object)AlarmSeverity.MINOR, (Object)this.alarmService.findHighestAlarmSeverity(this.tenantId, (EntityId)customerDevice.getId(), null, AlarmStatus.CLEARED_ACK, null));
    }

    @Test
    public void testFindAlarmUsingAlarmDataQuery() throws ExecutionException, InterruptedException {
        AssetId parentId = new AssetId(Uuids.timeBased());
        AssetId parentId2 = new AssetId(Uuids.timeBased());
        AssetId childId = new AssetId(Uuids.timeBased());
        EntityRelation relation = new EntityRelation((EntityId)parentId, (EntityId)childId, "Contains");
        EntityRelation relation2 = new EntityRelation((EntityId)parentId2, (EntityId)childId, "Contains");
        Assert.assertTrue((boolean)((Boolean)this.relationService.saveRelationAsync(this.tenantId, relation).get()));
        Assert.assertTrue((boolean)((Boolean)this.relationService.saveRelationAsync(this.tenantId, relation2).get()));
        long ts = System.currentTimeMillis();
        AlarmApiCallResult result = this.alarmService.createAlarm(AlarmCreateOrUpdateActiveRequest.builder().tenantId(this.tenantId).originator((EntityId)childId).type(TEST_ALARM).severity(AlarmSeverity.CRITICAL).startTs(ts).build());
        AlarmInfo created = result.getAlarm();
        AlarmDataPageLink pageLink = new AlarmDataPageLink();
        pageLink.setPage(0);
        pageLink.setPageSize(10);
        pageLink.setSortOrder(new EntityDataSortOrder(new EntityKey(EntityKeyType.ALARM_FIELD, "createdTime")));
        pageLink.setStartTs(0L);
        pageLink.setEndTs(System.currentTimeMillis());
        pageLink.setSearchPropagatedAlarms(false);
        pageLink.setSeverityList(List.of(AlarmSeverity.CRITICAL, AlarmSeverity.WARNING));
        pageLink.setStatusList(List.of(AlarmSearchStatus.ACTIVE));
        PageData alarms = this.alarmService.findAlarmDataByQueryForEntities(this.tenantId, this.toQuery(pageLink), Collections.singletonList(childId));
        Assert.assertNotNull((Object)alarms.getData());
        Assert.assertEquals((long)1L, (long)alarms.getData().size());
        Assert.assertEquals((Object)created, (Object)new AlarmInfo((AlarmInfo)alarms.getData().get(0)));
        pageLink.setPage(0);
        pageLink.setPageSize(10);
        pageLink.setSortOrder(new EntityDataSortOrder(new EntityKey(EntityKeyType.ENTITY_FIELD, "createdTime")));
        pageLink.setStartTs(0L);
        pageLink.setEndTs(System.currentTimeMillis());
        pageLink.setSearchPropagatedAlarms(false);
        pageLink.setSeverityList(List.of(AlarmSeverity.CRITICAL, AlarmSeverity.WARNING));
        pageLink.setStatusList(List.of(AlarmSearchStatus.ACTIVE));
        alarms = this.alarmService.findAlarmDataByQueryForEntities(this.tenantId, this.toQuery(pageLink), Collections.singletonList(childId));
        Assert.assertNotNull((Object)alarms.getData());
        Assert.assertEquals((long)1L, (long)alarms.getData().size());
        Assert.assertEquals((Object)created, (Object)new AlarmInfo((AlarmInfo)alarms.getData().get(0)));
        pageLink.setSearchPropagatedAlarms(true);
        alarms = this.alarmService.findAlarmDataByQueryForEntities(this.tenantId, this.toQuery(pageLink), Collections.singletonList(childId));
        Assert.assertNotNull((Object)alarms.getData());
        Assert.assertEquals((long)1L, (long)alarms.getData().size());
        Assert.assertEquals((Object)created, (Object)new AlarmInfo((AlarmInfo)alarms.getData().get(0)));
        created.setPropagate(true);
        result = this.alarmService.updateAlarm(AlarmUpdateRequest.fromAlarm((Alarm)created));
        created = result.getAlarm();
        pageLink.setPage(0);
        pageLink.setPageSize(10);
        pageLink.setSortOrder(new EntityDataSortOrder(new EntityKey(EntityKeyType.ALARM_FIELD, "createdTime")));
        pageLink.setStartTs(0L);
        pageLink.setEndTs(System.currentTimeMillis());
        pageLink.setSearchPropagatedAlarms(true);
        pageLink.setSeverityList(List.of(AlarmSeverity.CRITICAL, AlarmSeverity.WARNING));
        pageLink.setStatusList(List.of(AlarmSearchStatus.ACTIVE));
        alarms = this.alarmService.findAlarmDataByQueryForEntities(this.tenantId, this.toQuery(pageLink), Collections.singletonList(childId));
        Assert.assertNotNull((Object)alarms.getData());
        Assert.assertEquals((long)1L, (long)alarms.getData().size());
        Assert.assertEquals((Object)created, (Object)new AlarmInfo((AlarmInfo)alarms.getData().get(0)));
        pageLink.setPage(0);
        pageLink.setPageSize(10);
        pageLink.setSortOrder(new EntityDataSortOrder(new EntityKey(EntityKeyType.ALARM_FIELD, "createdTime")));
        pageLink.setStartTs(0L);
        pageLink.setEndTs(System.currentTimeMillis());
        pageLink.setSearchPropagatedAlarms(true);
        pageLink.setSeverityList(List.of(AlarmSeverity.CRITICAL, AlarmSeverity.WARNING));
        pageLink.setStatusList(List.of(AlarmSearchStatus.ACTIVE));
        alarms = this.alarmService.findAlarmDataByQueryForEntities(this.tenantId, this.toQuery(pageLink), Collections.singletonList(parentId));
        Assert.assertNotNull((Object)alarms.getData());
        Assert.assertEquals((long)1L, (long)alarms.getData().size());
        Assert.assertEquals((Object)created, (Object)new AlarmInfo((AlarmInfo)alarms.getData().get(0)));
        PageData alarmsInfoData = this.alarmService.findAlarms(this.tenantId, AlarmQuery.builder().affectedEntityId((EntityId)childId).status(AlarmStatus.ACTIVE_UNACK).pageLink(new TimePageLink(10, 0, "", new SortOrder("createdTime", SortOrder.Direction.DESC), Long.valueOf(0L), Long.valueOf(System.currentTimeMillis()))).build());
        Assert.assertNotNull((Object)alarmsInfoData.getData());
        Assert.assertEquals((long)1L, (long)alarmsInfoData.getData().size());
        Assert.assertEquals((Object)created, (Object)new AlarmInfo((AlarmInfo)alarmsInfoData.getData().get(0)));
        alarmsInfoData = this.alarmService.findAlarms(this.tenantId, AlarmQuery.builder().affectedEntityId((EntityId)parentId).status(AlarmStatus.ACTIVE_UNACK).pageLink(new TimePageLink(10, 0, "", new SortOrder("createdTime", SortOrder.Direction.DESC), Long.valueOf(0L), Long.valueOf(System.currentTimeMillis()))).build());
        Assert.assertNotNull((Object)alarmsInfoData.getData());
        Assert.assertEquals((long)1L, (long)alarmsInfoData.getData().size());
        Assert.assertEquals((Object)created, (Object)new AlarmInfo((AlarmInfo)alarmsInfoData.getData().get(0)));
        alarmsInfoData = this.alarmService.findAlarms(this.tenantId, AlarmQuery.builder().affectedEntityId((EntityId)parentId2).status(AlarmStatus.ACTIVE_UNACK).pageLink(new TimePageLink(10, 0, "", new SortOrder("createdTime", SortOrder.Direction.DESC), Long.valueOf(0L), Long.valueOf(System.currentTimeMillis()))).build());
        Assert.assertNotNull((Object)alarmsInfoData.getData());
        Assert.assertEquals((long)1L, (long)alarmsInfoData.getData().size());
        Assert.assertEquals((Object)created, (Object)new AlarmInfo((AlarmInfo)alarmsInfoData.getData().get(0)));
        pageLink.setPage(0);
        pageLink.setPageSize(10);
        pageLink.setSortOrder(new EntityDataSortOrder(new EntityKey(EntityKeyType.ENTITY_FIELD, "createdTime")));
        pageLink.setStartTs(0L);
        pageLink.setEndTs(System.currentTimeMillis());
        pageLink.setSearchPropagatedAlarms(true);
        pageLink.setSeverityList(List.of(AlarmSeverity.CRITICAL, AlarmSeverity.WARNING));
        pageLink.setStatusList(List.of(AlarmSearchStatus.ACTIVE));
        alarms = this.alarmService.findAlarmDataByQueryForEntities(this.tenantId, this.toQuery(pageLink), Collections.singletonList(parentId));
        Assert.assertNotNull((Object)alarms.getData());
        Assert.assertEquals((long)1L, (long)alarms.getData().size());
        Assert.assertEquals((Object)created, (Object)new AlarmInfo((AlarmInfo)alarms.getData().get(0)));
        created = this.alarmService.acknowledgeAlarm(this.tenantId, created.getId(), System.currentTimeMillis()).getAlarm();
        pageLink.setPage(0);
        pageLink.setPageSize(10);
        pageLink.setSortOrder(new EntityDataSortOrder(new EntityKey(EntityKeyType.ALARM_FIELD, "createdTime")));
        pageLink.setStartTs(0L);
        pageLink.setEndTs(System.currentTimeMillis());
        pageLink.setSearchPropagatedAlarms(true);
        pageLink.setSeverityList(List.of(AlarmSeverity.CRITICAL, AlarmSeverity.WARNING));
        pageLink.setStatusList(List.of(AlarmSearchStatus.ACTIVE));
        alarms = this.alarmService.findAlarmDataByQueryForEntities(this.tenantId, this.toQuery(pageLink), Collections.singletonList(childId));
        Assert.assertNotNull((Object)alarms.getData());
        Assert.assertEquals((long)1L, (long)alarms.getData().size());
        Assert.assertEquals((Object)created, (Object)new AlarmInfo((AlarmInfo)alarms.getData().get(0)));
    }

    @Test
    public void testCountAlarmsUsingAlarmDataQuery() {
        AssetId childId = new AssetId(Uuids.timeBased());
        long ts = System.currentTimeMillis();
        AlarmApiCallResult result = this.alarmService.createAlarm(AlarmCreateOrUpdateActiveRequest.builder().tenantId(this.tenantId).originator((EntityId)childId).type(TEST_ALARM).severity(AlarmSeverity.CRITICAL).startTs(ts).build());
        AlarmInfo created = result.getAlarm();
        AlarmCountQuery countQuery = AlarmCountQuery.builder().startTs(0L).endTs(System.currentTimeMillis()).searchPropagatedAlarms(false).severityList(List.of(AlarmSeverity.CRITICAL, AlarmSeverity.WARNING)).statusList(List.of(AlarmSearchStatus.ACTIVE)).build();
        long alarmsCount = this.alarmService.countAlarmsByQuery(this.tenantId, null, countQuery);
        Assert.assertEquals((long)1L, (long)alarmsCount);
        countQuery = AlarmCountQuery.builder().startTs(0L).endTs(System.currentTimeMillis()).searchPropagatedAlarms(true).severityList(List.of(AlarmSeverity.CRITICAL, AlarmSeverity.WARNING)).statusList(List.of(AlarmSearchStatus.ACTIVE)).build();
        alarmsCount = this.alarmService.countAlarmsByQuery(this.tenantId, null, countQuery);
        Assert.assertEquals((long)1L, (long)alarmsCount);
        created = this.alarmService.acknowledgeAlarm(this.tenantId, created.getId(), System.currentTimeMillis()).getAlarm();
        alarmsCount = this.alarmService.countAlarmsByQuery(this.tenantId, null, countQuery);
        Assert.assertEquals((long)1L, (long)alarmsCount);
        this.alarmService.clearAlarm(this.tenantId, created.getId(), System.currentTimeMillis(), null);
        created = this.alarmService.findAlarmInfoById(this.tenantId, created.getId());
        alarmsCount = this.alarmService.countAlarmsByQuery(this.tenantId, null, countQuery);
        Assert.assertEquals((long)0L, (long)alarmsCount);
        countQuery = AlarmCountQuery.builder().startTs(0L).endTs(System.currentTimeMillis()).searchPropagatedAlarms(true).severityList(List.of(AlarmSeverity.CRITICAL, AlarmSeverity.WARNING)).statusList(List.of(AlarmSearchStatus.ACTIVE, AlarmSearchStatus.CLEARED)).build();
        alarmsCount = this.alarmService.countAlarmsByQuery(this.tenantId, null, countQuery);
        Assert.assertEquals((long)1L, (long)alarmsCount);
    }

    @Test
    public void testDeleteAlarm() throws ExecutionException, InterruptedException {
        AssetId parentId = new AssetId(Uuids.timeBased());
        AssetId childId = new AssetId(Uuids.timeBased());
        EntityRelation relation = new EntityRelation((EntityId)parentId, (EntityId)childId, "Contains");
        Assert.assertNotNull((Object)this.relationService.saveRelation(this.tenantId, relation));
        long ts = System.currentTimeMillis();
        AlarmApiCallResult result = this.alarmService.createAlarm(AlarmCreateOrUpdateActiveRequest.builder().tenantId(this.tenantId).originator((EntityId)childId).type(TEST_ALARM).severity(AlarmSeverity.CRITICAL).propagation(AlarmPropagationInfo.builder().propagate(true).build()).startTs(ts).build());
        AlarmInfo created = result.getAlarm();
        PageData alarms = this.alarmService.findAlarms(this.tenantId, AlarmQuery.builder().affectedEntityId((EntityId)childId).status(AlarmStatus.ACTIVE_UNACK).pageLink(new TimePageLink(1, 0, "", new SortOrder("createdTime", SortOrder.Direction.DESC), Long.valueOf(0L), Long.valueOf(System.currentTimeMillis()))).build());
        Assert.assertNotNull((Object)alarms.getData());
        Assert.assertEquals((long)1L, (long)alarms.getData().size());
        Assert.assertEquals((Object)created, (Object)new AlarmInfo((AlarmInfo)alarms.getData().get(0)));
        alarms = this.alarmService.findAlarms(this.tenantId, AlarmQuery.builder().affectedEntityId((EntityId)parentId).status(AlarmStatus.ACTIVE_UNACK).pageLink(new TimePageLink(1, 0, "", new SortOrder("createdTime", SortOrder.Direction.DESC), Long.valueOf(0L), Long.valueOf(System.currentTimeMillis()))).build());
        Assert.assertNotNull((Object)alarms.getData());
        Assert.assertEquals((long)1L, (long)alarms.getData().size());
        Assert.assertEquals((Object)created, (Object)new AlarmInfo((AlarmInfo)alarms.getData().get(0)));
        Assert.assertTrue((String)"Alarm was not deleted when expected", (boolean)this.alarmService.delAlarm(this.tenantId, created.getId()).isSuccessful());
        Alarm fetched = (Alarm)this.alarmService.findAlarmByIdAsync(this.tenantId, created.getId()).get();
        Assert.assertNull((String)"Alarm was returned when it was expected to be null", (Object)fetched);
        alarms = this.alarmService.findAlarms(this.tenantId, AlarmQuery.builder().affectedEntityId((EntityId)childId).status(AlarmStatus.ACTIVE_UNACK).pageLink(new TimePageLink(1, 0, "", new SortOrder("createdTime", SortOrder.Direction.DESC), Long.valueOf(0L), Long.valueOf(System.currentTimeMillis()))).build());
        Assert.assertNotNull((Object)alarms.getData());
        Assert.assertEquals((long)0L, (long)alarms.getData().size());
        alarms = this.alarmService.findAlarms(this.tenantId, AlarmQuery.builder().affectedEntityId((EntityId)parentId).status(AlarmStatus.ACTIVE_UNACK).pageLink(new TimePageLink(1, 0, "", new SortOrder("createdTime", SortOrder.Direction.DESC), Long.valueOf(0L), Long.valueOf(System.currentTimeMillis()))).build());
        Assert.assertNotNull((Object)alarms.getData());
        Assert.assertEquals((long)0L, (long)alarms.getData().size());
    }

    @Test
    public void testCountAlarmsForEntities() throws ExecutionException, InterruptedException {
        AssetId parentId = new AssetId(Uuids.timeBased());
        AssetId childId = new AssetId(Uuids.timeBased());
        EntityRelation relation = new EntityRelation((EntityId)parentId, (EntityId)childId, "Contains");
        Assert.assertTrue((boolean)((Boolean)this.relationService.saveRelationAsync(this.tenantId, relation).get()));
        long ts = System.currentTimeMillis();
        AlarmApiCallResult result = this.alarmService.createAlarm(AlarmCreateOrUpdateActiveRequest.builder().tenantId(this.tenantId).originator((EntityId)childId).type(TEST_ALARM).severity(AlarmSeverity.CRITICAL).startTs(ts).build());
        AlarmInfo created = result.getAlarm();
        created.setPropagate(true);
        result = this.alarmService.updateAlarm(AlarmUpdateRequest.fromAlarm((Alarm)created));
        created = result.getAlarm();
        EntityListFilter entityListFilter = new EntityListFilter();
        entityListFilter.setEntityList(List.of(childId.getId().toString(), parentId.getId().toString()));
        entityListFilter.setEntityType(EntityType.ASSET);
        AlarmCountQuery countQuery = new AlarmCountQuery((EntityFilter)entityListFilter);
        countQuery.setStartTs(0L);
        countQuery.setEndTs(System.currentTimeMillis());
        long alarmsCount = this.alarmService.countAlarmsByQuery(this.tenantId, null, countQuery, List.of(childId));
        Assert.assertEquals((long)1L, (long)alarmsCount);
        countQuery.setSearchPropagatedAlarms(true);
        alarmsCount = this.alarmService.countAlarmsByQuery(this.tenantId, null, countQuery, List.of(parentId));
        Assert.assertEquals((long)1L, (long)alarmsCount);
        created = this.alarmService.acknowledgeAlarm(this.tenantId, created.getId(), System.currentTimeMillis()).getAlarm();
        countQuery.setStatusList(List.of(AlarmSearchStatus.UNACK));
        alarmsCount = this.alarmService.countAlarmsByQuery(this.tenantId, null, countQuery, List.of(childId));
        Assert.assertEquals((long)0L, (long)alarmsCount);
        this.alarmService.clearAlarm(this.tenantId, created.getId(), System.currentTimeMillis(), null);
        countQuery.setStatusList(List.of(AlarmSearchStatus.CLEARED));
        alarmsCount = this.alarmService.countAlarmsByQuery(this.tenantId, null, countQuery, List.of(childId));
        Assert.assertEquals((long)1L, (long)alarmsCount);
    }
}

