/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.service;

import com.datastax.oss.driver.api.core.uuid.Uuids;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.testcontainers.shaded.org.apache.commons.lang3.RandomStringUtils;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.alarm.Alarm;
import org.thingsboard.server.common.data.alarm.AlarmComment;
import org.thingsboard.server.common.data.alarm.AlarmCommentType;
import org.thingsboard.server.common.data.alarm.AlarmCreateOrUpdateActiveRequest;
import org.thingsboard.server.common.data.alarm.AlarmSeverity;
import org.thingsboard.server.common.data.id.AssetId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.security.Authority;
import org.thingsboard.server.dao.alarm.AlarmCommentService;
import org.thingsboard.server.dao.alarm.AlarmService;
import org.thingsboard.server.dao.service.AbstractServiceTest;
import org.thingsboard.server.dao.service.DaoSqlTest;
import org.thingsboard.server.dao.user.UserService;

@DaoSqlTest
public class AlarmCommentServiceTest
extends AbstractServiceTest {
    @Autowired
    AlarmService alarmService;
    @Autowired
    AlarmCommentService alarmCommentService;
    @Autowired
    UserService userService;
    public static final String TEST_ALARM = "TEST_ALARM";
    private Alarm alarm;
    private User user;

    @Before
    public void before() {
        this.alarm = this.alarmService.createAlarm(AlarmCreateOrUpdateActiveRequest.builder().tenantId(this.tenantId).originator((EntityId)new AssetId(Uuids.timeBased())).type(TEST_ALARM).severity(AlarmSeverity.CRITICAL).startTs(System.currentTimeMillis()).build()).getAlarm();
        this.user = new User();
        this.user.setAuthority(Authority.TENANT_ADMIN);
        this.user.setTenantId(this.tenantId);
        this.user.setEmail("tenant@thingsboard.org");
        this.user.setFirstName("John");
        this.user.setLastName("Brown");
        this.user = this.userService.saveUser(TenantId.SYS_TENANT_ID, this.user);
    }

    @After
    public void after() {
        this.alarmService.delAlarm(this.tenantId, this.alarm.getId());
    }

    @Test
    public void testCreateAndFetchAlarmComment() throws ExecutionException, InterruptedException {
        AlarmComment alarmComment = AlarmComment.builder().alarmId(this.alarm.getId()).userId(this.user.getId()).type(AlarmCommentType.OTHER).comment((JsonNode)JacksonUtil.newObjectNode().put("text", RandomStringUtils.randomAlphanumeric((int)10))).build();
        AlarmComment createdComment = this.alarmCommentService.createOrUpdateAlarmComment(this.tenantId, alarmComment);
        Assert.assertNotNull((Object)createdComment);
        Assert.assertNotNull((Object)createdComment.getId());
        Assert.assertEquals((Object)this.alarm.getId(), (Object)createdComment.getAlarmId());
        Assert.assertEquals((Object)this.user.getId(), (Object)createdComment.getUserId());
        Assert.assertEquals((Object)AlarmCommentType.OTHER, (Object)createdComment.getType());
        Assert.assertTrue((createdComment.getCreatedTime() > 0L ? 1 : 0) != 0);
        AlarmComment fetched = (AlarmComment)this.alarmCommentService.findAlarmCommentByIdAsync(this.tenantId, createdComment.getId()).get();
        Assert.assertEquals((Object)createdComment, (Object)fetched);
        PageData alarmComments = this.alarmCommentService.findAlarmComments(this.tenantId, this.alarm.getId(), new PageLink(10, 0));
        Assert.assertNotNull((Object)alarmComments.getData());
        Assert.assertEquals((long)1L, (long)alarmComments.getData().size());
        Assert.assertEquals((Object)createdComment, (Object)new AlarmComment((AlarmComment)alarmComments.getData().get(0)));
    }

    @Test
    public void testUpdateAlarmComment() throws ExecutionException, InterruptedException {
        UserId userId = new UserId(UUID.randomUUID());
        AlarmComment alarmComment = AlarmComment.builder().alarmId(this.alarm.getId()).userId(userId).type(AlarmCommentType.OTHER).comment((JsonNode)JacksonUtil.newObjectNode().put("text", RandomStringUtils.randomAlphanumeric((int)10))).build();
        AlarmComment createdComment = this.alarmCommentService.createOrUpdateAlarmComment(this.tenantId, alarmComment);
        Assert.assertNotNull((Object)createdComment);
        Assert.assertNotNull((Object)createdComment.getId());
        String newComment = "new comment";
        createdComment.setComment((JsonNode)JacksonUtil.newObjectNode().put("text", newComment));
        AlarmComment updatedComment = this.alarmCommentService.createOrUpdateAlarmComment(this.tenantId, createdComment);
        Assert.assertEquals((Object)this.alarm.getId(), (Object)updatedComment.getAlarmId());
        Assert.assertEquals((Object)userId, (Object)updatedComment.getUserId());
        Assert.assertEquals((Object)AlarmCommentType.OTHER, (Object)updatedComment.getType());
        Assert.assertTrue((updatedComment.getCreatedTime() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((Object)newComment, (Object)updatedComment.getComment().get("text").asText());
        Assert.assertEquals((Object)"true", (Object)updatedComment.getComment().get("edited").asText());
        Assert.assertNotNull((Object)updatedComment.getComment().get("editedOn").asText());
        AlarmComment fetched = (AlarmComment)this.alarmCommentService.findAlarmCommentByIdAsync(this.tenantId, createdComment.getId()).get();
        Assert.assertEquals((Object)updatedComment, (Object)fetched);
        PageData alarmComments = this.alarmCommentService.findAlarmComments(this.tenantId, this.alarm.getId(), new PageLink(10, 0));
        Assert.assertNotNull((Object)alarmComments.getData());
        Assert.assertEquals((long)1L, (long)alarmComments.getData().size());
        Assert.assertEquals((Object)updatedComment, (Object)new AlarmComment((AlarmComment)alarmComments.getData().get(0)));
    }

    @Test
    public void testSaveAlarmComment() throws ExecutionException, InterruptedException {
        UserId userId = new UserId(UUID.randomUUID());
        AlarmComment alarmComment = AlarmComment.builder().alarmId(this.alarm.getId()).userId(userId).type(AlarmCommentType.OTHER).comment((JsonNode)JacksonUtil.newObjectNode().put("text", RandomStringUtils.randomAlphanumeric((int)10))).build();
        AlarmComment createdComment = this.alarmCommentService.createOrUpdateAlarmComment(this.tenantId, alarmComment);
        createdComment.setType(AlarmCommentType.SYSTEM);
        createdComment.setUserId(null);
        this.alarmCommentService.saveAlarmComment(this.tenantId, createdComment);
        AlarmComment fetched = (AlarmComment)this.alarmCommentService.findAlarmCommentByIdAsync(this.tenantId, createdComment.getId()).get();
        Assert.assertNull((Object)fetched.getUserId());
        Assert.assertEquals((Object)AlarmCommentType.SYSTEM, (Object)fetched.getType());
    }
}

