/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.testcontainers.shaded.org.apache.commons.lang3.RandomStringUtils;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.AdminSettings;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.dao.exception.DataValidationException;
import org.thingsboard.server.dao.service.AbstractServiceTest;
import org.thingsboard.server.dao.service.DaoSqlTest;
import org.thingsboard.server.dao.settings.AdminSettingsService;

@DaoSqlTest
public class AdminSettingsServiceTest
extends AbstractServiceTest {
    @Autowired
    AdminSettingsService adminSettingsService;

    @Test
    public void testFindAdminSettingsByKey() {
        AdminSettings adminSettings = this.adminSettingsService.findAdminSettingsByKey(SYSTEM_TENANT_ID, "general");
        Assert.assertNotNull((Object)adminSettings);
        adminSettings = this.adminSettingsService.findAdminSettingsByKey(SYSTEM_TENANT_ID, "mail");
        Assert.assertNotNull((Object)adminSettings);
        adminSettings = this.adminSettingsService.findAdminSettingsByKey(SYSTEM_TENANT_ID, "unknown");
        Assert.assertNull((Object)adminSettings);
    }

    @Test
    public void testFindAdminSettingsById() {
        AdminSettings adminSettings = this.adminSettingsService.findAdminSettingsByKey(SYSTEM_TENANT_ID, "general");
        AdminSettings foundAdminSettings = this.adminSettingsService.findAdminSettingsById(SYSTEM_TENANT_ID, adminSettings.getId());
        Assert.assertNotNull((Object)foundAdminSettings);
        Assert.assertEquals((Object)adminSettings, (Object)foundAdminSettings);
    }

    @Test
    public void testSaveAdminSettings() {
        AdminSettings adminSettings = this.adminSettingsService.findAdminSettingsByKey(SYSTEM_TENANT_ID, "general");
        JsonNode json = adminSettings.getJsonValue();
        ((ObjectNode)json).put("baseUrl", "http://myhost.org");
        adminSettings.setJsonValue(json);
        this.adminSettingsService.saveAdminSettings(SYSTEM_TENANT_ID, adminSettings);
        AdminSettings savedAdminSettings = this.adminSettingsService.findAdminSettingsByKey(SYSTEM_TENANT_ID, "general");
        Assert.assertNotNull((Object)savedAdminSettings);
        Assert.assertEquals((Object)adminSettings.getJsonValue(), (Object)savedAdminSettings.getJsonValue());
    }

    @Test
    public void testSaveAdminSettingsWithEmptyKey() {
        AdminSettings adminSettings = this.adminSettingsService.findAdminSettingsByKey(SYSTEM_TENANT_ID, "mail");
        adminSettings.setKey(null);
        org.junit.jupiter.api.Assertions.assertThrows(DataValidationException.class, () -> this.adminSettingsService.saveAdminSettings(SYSTEM_TENANT_ID, adminSettings));
    }

    @Test
    public void testChangeAdminSettingsKey() {
        AdminSettings adminSettings = this.adminSettingsService.findAdminSettingsByKey(SYSTEM_TENANT_ID, "mail");
        adminSettings.setKey("newKey");
        org.junit.jupiter.api.Assertions.assertThrows(DataValidationException.class, () -> this.adminSettingsService.saveAdminSettings(SYSTEM_TENANT_ID, adminSettings));
    }

    @Test
    public void whenSavingAdminSettingsWithAlreadyExistingKey_thenReturnError() {
        String key = RandomStringUtils.randomAlphanumeric((int)15);
        ObjectNode value = JacksonUtil.newObjectNode().put("test", "test");
        AdminSettings systemSettings = new AdminSettings();
        systemSettings.setTenantId(TenantId.SYS_TENANT_ID);
        systemSettings.setKey(key);
        systemSettings.setJsonValue((JsonNode)value);
        this.adminSettingsService.saveAdminSettings(TenantId.SYS_TENANT_ID, systemSettings);
        Assertions.assertThatThrownBy(() -> this.adminSettingsService.saveAdminSettings(TenantId.SYS_TENANT_ID, systemSettings)).hasMessageContaining("already exists");
        AdminSettings tenantSettings = new AdminSettings();
        tenantSettings.setTenantId(this.tenantId);
        tenantSettings.setKey(key);
        tenantSettings.setJsonValue((JsonNode)value);
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> this.adminSettingsService.saveAdminSettings(this.tenantId, tenantSettings));
        Assertions.assertThatThrownBy(() -> this.adminSettingsService.saveAdminSettings(this.tenantId, tenantSettings)).hasMessageContaining("already exists");
    }
}

