/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.nosql;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.SettableFuture;
import java.util.UUID;
import java.util.function.Function;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.springframework.core.env.Environment;
import org.springframework.test.util.ReflectionTestUtils;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.dao.cassandra.CassandraCluster;
import org.thingsboard.server.dao.cassandra.guava.GuavaSession;
import org.thingsboard.server.dao.nosql.TbResultSetFuture;
import org.thingsboard.server.dao.timeseries.CassandraBaseTimeseriesDao;

@RunWith(value=MockitoJUnitRunner.class)
public class CassandraPartitionsCacheTest {
    @Spy
    private CassandraBaseTimeseriesDao cassandraBaseTimeseriesDao;
    @Mock
    private PreparedStatement preparedStatement;
    @Mock
    private BoundStatement boundStatement;
    @Mock
    private Environment environment;
    @Mock
    private CassandraCluster cluster;
    @Mock
    private GuavaSession session;

    @Before
    public void setUp() throws Exception {
        ReflectionTestUtils.setField((Object)this.cassandraBaseTimeseriesDao, (String)"partitioning", (Object)"MONTHS");
        ReflectionTestUtils.setField((Object)this.cassandraBaseTimeseriesDao, (String)"partitionsCacheSize", (Object)100000);
        ReflectionTestUtils.setField((Object)this.cassandraBaseTimeseriesDao, (String)"systemTtl", (Object)0);
        ReflectionTestUtils.setField((Object)this.cassandraBaseTimeseriesDao, (String)"setNullValuesEnabled", (Object)false);
        ReflectionTestUtils.setField((Object)this.cassandraBaseTimeseriesDao, (String)"environment", (Object)this.environment);
        ReflectionTestUtils.setField((Object)this.cassandraBaseTimeseriesDao, (String)"cluster", (Object)this.cluster);
        Mockito.when((Object)this.cluster.getDefaultReadConsistencyLevel()).thenReturn((Object)ConsistencyLevel.ONE);
        Mockito.when((Object)this.cluster.getDefaultWriteConsistencyLevel()).thenReturn((Object)ConsistencyLevel.ONE);
        Mockito.when((Object)this.cluster.getSession()).thenReturn((Object)this.session);
        Mockito.when((Object)this.session.prepare(ArgumentMatchers.anyString())).thenReturn((Object)this.preparedStatement);
        Mockito.when((Object)this.preparedStatement.bind(new Object[0])).thenReturn((Object)this.boundStatement);
        Mockito.when((Object)((BoundStatement)this.boundStatement.setString(ArgumentMatchers.anyInt(), ArgumentMatchers.anyString()))).thenReturn((Object)this.boundStatement);
        Mockito.when((Object)((BoundStatement)this.boundStatement.setUuid(ArgumentMatchers.anyInt(), (UUID)ArgumentMatchers.any(UUID.class)))).thenReturn((Object)this.boundStatement);
        Mockito.when((Object)((BoundStatement)this.boundStatement.setLong(ArgumentMatchers.anyInt(), ((Long)ArgumentMatchers.any(Long.class)).longValue()))).thenReturn((Object)this.boundStatement);
        ((CassandraBaseTimeseriesDao)BDDMockito.willReturn((Object)new TbResultSetFuture(SettableFuture.create())).given((Object)this.cassandraBaseTimeseriesDao)).executeAsyncWrite((TenantId)ArgumentMatchers.any(), (Statement)ArgumentMatchers.any());
        ((CassandraBaseTimeseriesDao)Mockito.doReturn((Object)Futures.immediateFuture((Object)0)).when((Object)this.cassandraBaseTimeseriesDao)).getFuture((TbResultSetFuture)ArgumentMatchers.any(), (Function)ArgumentMatchers.any());
    }

    @Test
    public void testPartitionSave() throws Exception {
        int i;
        this.cassandraBaseTimeseriesDao.init();
        UUID id = UUID.randomUUID();
        TenantId tenantId = TenantId.fromUUID((UUID)id);
        long tsKvEntryTs = System.currentTimeMillis();
        for (i = 0; i < 50000; ++i) {
            this.cassandraBaseTimeseriesDao.savePartition(tenantId, (EntityId)tenantId, tsKvEntryTs, "test" + i);
        }
        for (i = 0; i < 60000; ++i) {
            this.cassandraBaseTimeseriesDao.savePartition(tenantId, (EntityId)tenantId, tsKvEntryTs, "test" + i);
        }
        ((CassandraBaseTimeseriesDao)Mockito.verify((Object)this.cassandraBaseTimeseriesDao, (VerificationMode)Mockito.times((int)60000))).executeAsyncWrite((TenantId)ArgumentMatchers.any(TenantId.class), (Statement)ArgumentMatchers.any(Statement.class));
    }
}

