/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.component;

import com.fasterxml.jackson.databind.JsonNode;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.plugin.ComponentClusteringMode;
import org.thingsboard.server.common.data.plugin.ComponentDescriptor;
import org.thingsboard.server.common.data.plugin.ComponentScope;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.dao.component.BaseComponentDescriptorService;
import org.thingsboard.server.dao.exception.IncorrectParameterException;

class BaseComponentDescriptorServiceTest {
    private BaseComponentDescriptorService service;
    private ComponentDescriptor componentDescriptor;
    private TenantId tenantId;

    BaseComponentDescriptorServiceTest() {
    }

    @BeforeEach
    void setUp() {
        this.service = (BaseComponentDescriptorService)Mockito.spy(BaseComponentDescriptorService.class);
        this.tenantId = TenantId.SYS_TENANT_ID;
        this.componentDescriptor = new ComponentDescriptor();
        this.componentDescriptor.setType(ComponentType.ACTION);
        this.componentDescriptor.setScope(ComponentScope.TENANT);
        this.componentDescriptor.setClusteringMode(ComponentClusteringMode.ENABLED);
        this.componentDescriptor.setName("Test Component");
        this.componentDescriptor.setClazz("org.thingsboard.test.TestComponent");
        String configDescriptorJson = "{\n  \"schema\": {\n    \"type\": \"object\",\n    \"properties\": {\n      \"testField\": {\n        \"type\": \"string\"\n      }\n    },\n    \"required\": [\"testField\"]\n  }\n}";
        this.componentDescriptor.setConfigurationDescriptor(JacksonUtil.toJsonNode((String)configDescriptorJson));
    }

    @Test
    void testValidate() {
        String validConfigJson = "{\"testField\": \"test value\"}";
        JsonNode validConfig = JacksonUtil.toJsonNode((String)validConfigJson);
        String invalidConfigJson = "{}";
        JsonNode invalidConfig = JacksonUtil.toJsonNode((String)invalidConfigJson);
        boolean validResult = this.service.validate(this.tenantId, this.componentDescriptor, validConfig);
        Assertions.assertTrue((boolean)validResult, (String)"Valid configuration should pass validation");
        boolean invalidResult = this.service.validate(this.tenantId, this.componentDescriptor, invalidConfig);
        Assertions.assertFalse((boolean)invalidResult, (String)"Invalid configuration should fail validation");
        ComponentDescriptor noSchemaDescriptor = new ComponentDescriptor(this.componentDescriptor);
        noSchemaDescriptor.setConfigurationDescriptor(JacksonUtil.toJsonNode((String)"{}"));
        Assertions.assertThrows(IncorrectParameterException.class, () -> this.service.validate(this.tenantId, noSchemaDescriptor, validConfig), (String)"Should throw exception when schema is missing");
    }
}

