/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.cache;

import java.io.Serializable;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.junit.jupiter.SpringExtension;
import org.thingsboard.server.cache.CacheSpecsMap;
import org.thingsboard.server.cache.RedisSslCredentials;
import org.thingsboard.server.cache.TBRedisCacheConfiguration;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.relation.RelationTypeGroup;
import org.thingsboard.server.dao.relation.RelationCacheKey;
import org.thingsboard.server.dao.relation.RelationRedisCache;

@ExtendWith(value={SpringExtension.class})
@ContextConfiguration(classes={RelationRedisCache.class, CacheSpecsMap.class, TBRedisCacheConfiguration.class})
@TestPropertySource(properties={"cache.type=redis", "cache.specs.relations.timeToLiveInMinutes=1440", "cache.specs.relations.maxSize=0"})
public class RedisTbTransactionalCacheTest {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RedisTbTransactionalCacheTest.class);
    @MockBean
    private RelationRedisCache relationRedisCache;
    @MockBean
    private RedisConnectionFactory connectionFactory;
    @MockBean
    private RedisConnection redisConnection;
    @MockBean
    private RedisSslCredentials redisSslCredentials;

    @Test
    public void testNoOpWhenCacheDisabled() {
        Mockito.when((Object)this.connectionFactory.getConnection()).thenReturn((Object)this.redisConnection);
        this.relationRedisCache.put((Serializable)this.createRelationCacheKey(), null);
        this.relationRedisCache.putIfAbsent((Serializable)this.createRelationCacheKey(), null);
        this.relationRedisCache.evict((Serializable)this.createRelationCacheKey());
        this.relationRedisCache.evict(List.of(this.createRelationCacheKey()));
        this.relationRedisCache.getAndPutInTransaction((Serializable)this.createRelationCacheKey(), null, false);
        this.relationRedisCache.getAndPutInTransaction((Serializable)this.createRelationCacheKey(), null, null, null, false);
        this.relationRedisCache.getOrFetchFromDB((Serializable)this.createRelationCacheKey(), null, false, false);
        ((RedisConnectionFactory)Mockito.verify((Object)this.connectionFactory, (VerificationMode)Mockito.never())).getConnection();
        Mockito.verifyNoInteractions((Object[])new Object[]{this.redisConnection});
    }

    private RelationCacheKey createRelationCacheKey() {
        return new RelationCacheKey((EntityId)new DeviceId(UUID.randomUUID()), (EntityId)new DeviceId(UUID.randomUUID()), null, RelationTypeGroup.COMMON);
    }
}

