/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.audit;

import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.alarm.Alarm;
import org.thingsboard.server.common.data.alarm.AlarmComment;
import org.thingsboard.server.common.data.alarm.AlarmInfo;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.audit.AuditLog;
import org.thingsboard.server.common.data.id.AlarmId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.dao.audit.AuditLogDao;
import org.thingsboard.server.dao.audit.AuditLogLevelFilter;
import org.thingsboard.server.dao.audit.AuditLogServiceImpl;
import org.thingsboard.server.dao.audit.sink.AuditLogSink;
import org.thingsboard.server.dao.entity.EntityService;
import org.thingsboard.server.dao.service.validator.AuditLogDataValidator;
import org.thingsboard.server.dao.sql.JpaExecutorService;

@ExtendWith(value={MockitoExtension.class})
public class AuditLogServiceImplTest {
    private final TenantId TENANT_ID = TenantId.fromUUID((UUID)UUID.fromString("9114e9ac-6c28-4019-a2a7-b948cb9500d5"));
    private final CustomerId CUSTOMER_ID = new CustomerId(UUID.fromString("d15822ef-09eb-49a6-9068-21b9c8ae3356"));
    private final UserId USER_ID = new UserId(UUID.fromString("47a2c904-3a47-4530-91bb-51068a4610a7"));
    private final DeviceId DEVICE_ID = new DeviceId(UUID.fromString("b913c12a-9942-4cbd-9481-c42dad4831b0"));
    private final String USER_NAME = "Test User";
    @InjectMocks
    private AuditLogServiceImpl auditLogService;
    @Mock
    private EntityService entityService;
    @Mock
    private AuditLogLevelFilter auditLogLevelFilter;
    @Mock
    private AuditLogDataValidator auditLogDataValidator;
    @Mock
    private JpaExecutorService executor;
    @Mock
    private AuditLogDao auditLogDao;
    @Mock
    private AuditLogSink auditLogSink;

    @Test
    public void givenEntityIsNull_whenLogEntityAction_thenShouldFetchEntityName() throws Exception {
        BDDMockito.given((Object)this.auditLogLevelFilter.logEnabled((EntityType)ArgumentMatchers.any(), (ActionType)ArgumentMatchers.any())).willReturn((Object)true);
        BDDMockito.given((Object)this.entityService.fetchEntityName((TenantId)ArgumentMatchers.any(), (EntityId)ArgumentMatchers.any())).willReturn(Optional.of("Test device"));
        this.auditLogService.logEntityAction(this.TENANT_ID, this.CUSTOMER_ID, this.USER_ID, "Test User", (EntityId)this.DEVICE_ID, null, ActionType.ADDED, null, new Object[0]);
        ((EntityService)BDDMockito.then((Object)this.entityService).should()).fetchEntityName(this.TENANT_ID, (EntityId)this.DEVICE_ID);
        this.verifyEntityName("Test device");
    }

    @Test
    public void givenActionTypeIsAlarmActionAndEntityIsAlarm_whenLogEntityAction_thenShouldGetEntityName() throws Exception {
        BDDMockito.given((Object)this.auditLogLevelFilter.logEnabled((EntityType)ArgumentMatchers.any(), (ActionType)ArgumentMatchers.any())).willReturn((Object)true);
        Alarm alarm = new Alarm(new AlarmId(UUID.fromString("55f577b3-6ef5-4b99-92dc-70eb78b2a970")));
        alarm.setType("Test alarm");
        AlarmComment comment = new AlarmComment();
        comment.setComment(JacksonUtil.toJsonNode((String)"{\"comment\": \"test\"}"));
        this.auditLogService.logEntityAction(this.TENANT_ID, this.CUSTOMER_ID, this.USER_ID, "Test User", (EntityId)alarm.getId(), (HasName)alarm, ActionType.ADDED_COMMENT, null, new Object[]{comment});
        this.verifyEntityName("Test alarm");
    }

    @Test
    public void givenActionTypeIsAlarmActionAndEntityIsAlarmInfo_whenLogEntityAction_thenShouldGetEntityOriginatorName() throws Exception {
        BDDMockito.given((Object)this.auditLogLevelFilter.logEnabled((EntityType)ArgumentMatchers.any(), (ActionType)ArgumentMatchers.any())).willReturn((Object)true);
        AlarmInfo alarmInfo = new AlarmInfo();
        alarmInfo.setOriginatorName("Test device");
        this.auditLogService.logEntityAction(this.TENANT_ID, this.CUSTOMER_ID, this.USER_ID, "Test User", (EntityId)this.DEVICE_ID, (HasName)alarmInfo, ActionType.ALARM_ASSIGNED, null, new Object[0]);
        this.verifyEntityName("Test device");
    }

    @Test
    public void givenActionTypeIsAlarmActionAndEntityIsAlarm_whenLogEntityAction_thenShouldFetchEntityName() throws Exception {
        BDDMockito.given((Object)this.auditLogLevelFilter.logEnabled((EntityType)ArgumentMatchers.any(), (ActionType)ArgumentMatchers.any())).willReturn((Object)true);
        BDDMockito.given((Object)this.entityService.fetchEntityName((TenantId)ArgumentMatchers.any(), (EntityId)ArgumentMatchers.any())).willReturn(Optional.of("Test alarm"));
        this.auditLogService.logEntityAction(this.TENANT_ID, this.CUSTOMER_ID, this.USER_ID, "Test User", (EntityId)this.DEVICE_ID, (HasName)new Alarm(), ActionType.ALARM_DELETE, null, new Object[0]);
        ((EntityService)BDDMockito.then((Object)this.entityService).should()).fetchEntityName(this.TENANT_ID, (EntityId)this.DEVICE_ID);
        this.verifyEntityName("Test alarm");
    }

    private void verifyEntityName(String entityName) throws Exception {
        ((AuditLogDataValidator)BDDMockito.then((Object)this.auditLogDataValidator).should()).validate((BaseData)((AuditLog)ArgumentMatchers.any(AuditLog.class)), (Function)ArgumentMatchers.any());
        ArgumentCaptor submitTask = ArgumentCaptor.forClass(Callable.class);
        ((JpaExecutorService)BDDMockito.then((Object)this.executor).should()).submit((Callable)submitTask.capture());
        ((Callable)submitTask.getValue()).call();
        ArgumentCaptor auditLogEntry = ArgumentCaptor.forClass(AuditLog.class);
        ((AuditLogDao)BDDMockito.then((Object)this.auditLogDao).should()).save((TenantId)ArgumentMatchers.eq((Object)this.TENANT_ID), (Object)((AuditLog)auditLogEntry.capture()));
        Assertions.assertThat((String)((AuditLog)auditLogEntry.getValue()).getEntityName()).isEqualTo(entityName);
        ((AuditLogSink)BDDMockito.then((Object)this.auditLogSink).should()).logAction((AuditLog)ArgumentMatchers.any());
    }
}

