/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimescaleSqlInitializer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TimescaleSqlInitializer.class);
    private static final List<String> sqlFiles = List.of("sql/schema-timescale.sql", "sql/schema-entities.sql", "sql/schema-entities-idx.sql", "sql/schema-entities-idx-psql-addon.sql", "sql/schema-views.sql", "sql/schema-functions.sql", "sql/system-data.sql", "sql/system-test-psql.sql");
    private static final String dropAllTablesSqlFile = "sql/psql/drop-all-tables.sql";

    public static void initDb(Connection conn) {
        TimescaleSqlInitializer.cleanUpDb(conn);
        log.info("initialize Timescale DB...");
        try {
            for (String sqlFile : sqlFiles) {
                URL sqlFileUrl = Resources.getResource((String)sqlFile);
                String sql = Resources.toString((URL)sqlFileUrl, (Charset)Charsets.UTF_8);
                conn.createStatement().execute(sql);
            }
        }
        catch (IOException | SQLException e) {
            throw new RuntimeException("Unable to init the Timescale database. Reason: " + e.getMessage(), e);
        }
        log.info("Timescale DB is initialized!");
    }

    private static void cleanUpDb(Connection conn) {
        log.info("clean up Timescale DB...");
        try {
            URL dropAllTableSqlFileUrl = Resources.getResource((String)dropAllTablesSqlFile);
            String dropAllTablesSql = Resources.toString((URL)dropAllTableSqlFileUrl, (Charset)Charsets.UTF_8);
            conn.createStatement().execute(dropAllTablesSql);
        }
        catch (IOException | SQLException e) {
            throw new RuntimeException("Unable to clean up the Timescale database. Reason: " + e.getMessage(), e);
        }
    }
}

