/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao;

import java.util.List;
import lombok.Generated;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.OutputFrame;
import org.testcontainers.junit.jupiter.Container;
import org.testcontainers.junit.jupiter.Testcontainers;

@Testcontainers
public class RedisJUnit5Test {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RedisJUnit5Test.class);
    @Container
    private static final GenericContainer REDIS = new GenericContainer("bitnamilegacy/valkey:8.0").withEnv("ALLOW_EMPTY_PASSWORD", "yes").withLogConsumer(s -> log.error(((OutputFrame)s).getUtf8String().trim())).withExposedPorts(new Integer[]{6379});

    @BeforeAll
    static void beforeAll() {
        log.warn("Starting redis...");
        REDIS.start();
        System.setProperty("cache.type", "redis");
        System.setProperty("redis.connection.type", "standalone");
        System.setProperty("redis.standalone.host", REDIS.getHost());
        System.setProperty("redis.standalone.port", String.valueOf(REDIS.getMappedPort(6379)));
    }

    @AfterAll
    static void afterAll() {
        List.of("cache.type", "redis.connection.type", "redis.standalone.host", "redis.standalone.port").forEach(System.getProperties()::remove);
        REDIS.stop();
        log.warn("Redis is stopped");
    }

    @Test
    void test() {
        Assertions.assertThat((boolean)REDIS.isRunning()).isTrue();
    }
}

