/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao;

import java.util.List;
import lombok.Generated;
import org.junit.ClassRule;
import org.junit.rules.ExternalResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.OutputFrame;

public class AbstractRedisContainer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractRedisContainer.class);
    @ClassRule(order=0)
    public static GenericContainer redis = new GenericContainer("bitnamilegacy/valkey:8.0").withEnv("ALLOW_EMPTY_PASSWORD", "yes").withLogConsumer(s -> log.warn(((OutputFrame)s).getUtf8String().trim())).withExposedPorts(new Integer[]{6379});
    @ClassRule(order=1)
    public static ExternalResource resource = new ExternalResource(){

        protected void before() throws Throwable {
            redis.start();
            System.setProperty("cache.type", "redis");
            System.setProperty("redis.connection.type", "standalone");
            System.setProperty("redis.standalone.host", redis.getHost());
            System.setProperty("redis.standalone.port", String.valueOf(redis.getMappedPort(6379)));
        }

        protected void after() {
            redis.stop();
            List.of("cache.type", "redis.connection.type", "redis.standalone.host", "redis.standalone.port").forEach(System.getProperties()::remove);
        }
    };
}

