/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao;

import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.assertj.core.api.Assertions;
import org.junit.ClassRule;
import org.junit.rules.ExternalResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.OutputFrame;

public class AbstractRedisClusterContainer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractRedisClusterContainer.class);
    static final String NODES = "127.0.0.1:6371,127.0.0.1:6372,127.0.0.1:6373,127.0.0.1:6374,127.0.0.1:6375,127.0.0.1:6376";
    static final String IMAGE = "bitnamilegacy/valkey-cluster:8.0";
    static final Map<String, String> ENVS = Map.of("VALKEY_CLUSTER_ANNOUNCE_IP", "127.0.0.1", "VALKEY_CLUSTER_DYNAMIC_IPS", "no", "ALLOW_EMPTY_PASSWORD", "yes", "VALKEY_NODES", "127.0.0.1:6371,127.0.0.1:6372,127.0.0.1:6373,127.0.0.1:6374,127.0.0.1:6375,127.0.0.1:6376");
    @ClassRule(order=1)
    public static GenericContainer redis1 = new GenericContainer("bitnamilegacy/valkey-cluster:8.0").withEnv(ENVS).withEnv("VALKEY_PORT_NUMBER", "6371").withNetworkMode("host").withLogConsumer(AbstractRedisClusterContainer::consumeLog);
    @ClassRule(order=2)
    public static GenericContainer redis2 = new GenericContainer("bitnamilegacy/valkey-cluster:8.0").withEnv(ENVS).withEnv("VALKEY_PORT_NUMBER", "6372").withNetworkMode("host").withLogConsumer(AbstractRedisClusterContainer::consumeLog);
    @ClassRule(order=3)
    public static GenericContainer redis3 = new GenericContainer("bitnamilegacy/valkey-cluster:8.0").withEnv(ENVS).withEnv("VALKEY_PORT_NUMBER", "6373").withNetworkMode("host").withLogConsumer(AbstractRedisClusterContainer::consumeLog);
    @ClassRule(order=4)
    public static GenericContainer redis4 = new GenericContainer("bitnamilegacy/valkey-cluster:8.0").withEnv(ENVS).withEnv("VALKEY_PORT_NUMBER", "6374").withNetworkMode("host").withLogConsumer(AbstractRedisClusterContainer::consumeLog);
    @ClassRule(order=5)
    public static GenericContainer redis5 = new GenericContainer("bitnamilegacy/valkey-cluster:8.0").withEnv(ENVS).withEnv("VALKEY_PORT_NUMBER", "6375").withNetworkMode("host").withLogConsumer(AbstractRedisClusterContainer::consumeLog);
    @ClassRule(order=6)
    public static GenericContainer redis6 = new GenericContainer("bitnamilegacy/valkey-cluster:8.0").withEnv(ENVS).withEnv("VALKEY_PORT_NUMBER", "6376").withNetworkMode("host").withLogConsumer(AbstractRedisClusterContainer::consumeLog);
    @ClassRule(order=100)
    public static ExternalResource resource = new ExternalResource(){

        protected void before() throws Throwable {
            redis1.start();
            redis2.start();
            redis3.start();
            redis4.start();
            redis5.start();
            redis6.start();
            Thread.sleep(TimeUnit.SECONDS.toMillis(5L));
            String clusterCreateCommand = "valkey-cli --cluster create " + AbstractRedisClusterContainer.NODES.replace(",", " ") + " --cluster-replicas 1 --cluster-yes";
            log.warn("Command to init ValKey Cluster: {}", (Object)clusterCreateCommand);
            Container.ExecResult result = redis6.execInContainer(new String[]{"/bin/sh", "-c", clusterCreateCommand});
            log.warn("Init cluster result: {}", (Object)result);
            Assertions.assertThat((int)result.getExitCode()).isEqualTo(0);
            Thread.sleep(TimeUnit.SECONDS.toMillis(5L));
            log.warn("Connect to nodes: {}", (Object)AbstractRedisClusterContainer.NODES);
            System.setProperty("cache.type", "redis");
            System.setProperty("redis.connection.type", "cluster");
            System.setProperty("redis.cluster.nodes", AbstractRedisClusterContainer.NODES);
            System.setProperty("redis.cluster.useDefaultPoolConfig", "false");
        }

        protected void after() {
            redis1.stop();
            redis2.stop();
            redis3.stop();
            redis4.stop();
            redis5.stop();
            redis6.stop();
            List.of("cache.type", "redis.connection.type", "redis.cluster.nodes", "redis.cluster.useDefaultPoolConfig").forEach(System.getProperties()::remove);
        }
    };

    private static void consumeLog(Object x) {
        log.warn("{}", (Object)((OutputFrame)x).getUtf8StringWithoutLineEnding());
    }
}

