/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao;

import com.github.dockerjava.api.command.InspectContainerResponse;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.script.ScriptException;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.junit.ClassRule;
import org.junit.rules.ExternalResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.CassandraContainer;
import org.testcontainers.containers.ContainerState;
import org.testcontainers.containers.delegate.CassandraDatabaseDelegate;
import org.testcontainers.delegate.DatabaseDelegate;
import org.testcontainers.ext.ScriptUtils;

public abstract class AbstractNoSqlContainer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractNoSqlContainer.class);
    public static final List<String> INIT_SCRIPTS = List.of("cassandra/schema-keyspace.cql", "cassandra/schema-ts.cql", "cassandra/schema-ts-latest.cql");
    @ClassRule(order=0)
    public static final CassandraContainer cassandra = (CassandraContainer)new CassandraContainer("cassandra:5.0"){

        protected void containerIsStarted(InspectContainerResponse containerInfo) {
            super.containerIsStarted(containerInfo);
            CassandraDatabaseDelegate db = new CassandraDatabaseDelegate((ContainerState)this);
            INIT_SCRIPTS.forEach(arg_0 -> this.lambda$containerIsStarted$0((DatabaseDelegate)db, arg_0));
        }

        private void runInitScriptIfRequired(DatabaseDelegate db, String initScriptPath) {
            this.logger().info("Init script [{}]", (Object)initScriptPath);
            if (initScriptPath != null) {
                try {
                    URL resource = Thread.currentThread().getContextClassLoader().getResource(initScriptPath);
                    if (resource == null) {
                        this.logger().warn("Could not load classpath init script: {}", (Object)initScriptPath);
                        throw new ScriptUtils.ScriptLoadException("Could not load classpath init script: " + initScriptPath + ". Resource not found.");
                    }
                    String cql = IOUtils.toString((URL)resource, (Charset)StandardCharsets.UTF_8);
                    ScriptUtils.executeDatabaseScript((DatabaseDelegate)db, (String)initScriptPath, (String)cql);
                }
                catch (IOException e) {
                    this.logger().warn("Could not load classpath init script: {}", (Object)initScriptPath);
                    throw new ScriptUtils.ScriptLoadException("Could not load classpath init script: " + initScriptPath, (Throwable)e);
                }
                catch (ScriptException e) {
                    this.logger().error("Error while executing init script: {}", (Object)initScriptPath, (Object)e);
                    throw new ScriptUtils.UncategorizedScriptException("Error while executing init script: " + initScriptPath, (Exception)e);
                }
            }
        }

        private /* synthetic */ void lambda$containerIsStarted$0(DatabaseDelegate db, String script) {
            this.runInitScriptIfRequired(db, script);
        }
    }.withEnv("HEAP_NEWSIZE", "64M").withEnv("MAX_HEAP_SIZE", "512M").withEnv("CASSANDRA_CLUSTER_NAME", "ThingsBoard Cluster");
    @ClassRule(order=1)
    public static ExternalResource resource = new ExternalResource(){

        protected void before() throws Throwable {
            cassandra.start();
            String cassandraUrl = String.format("%s:%s", cassandra.getHost(), cassandra.getMappedPort(9042));
            log.debug("Cassandra url [{}]", (Object)cassandraUrl);
            System.setProperty("cassandra.url", cassandraUrl);
        }

        protected void after() {
            cassandra.stop();
            List.of("cassandra.url").forEach(System.getProperties()::remove);
        }
    };
}

