/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.sync.vc;

import java.beans.ConstructorProperties;
import java.util.UUID;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.sync.vc.RepositorySettings;
import org.thingsboard.server.gen.transport.TransportProtos;

public class VersionControlRequestCtx {
    private final String nodeId;
    private final UUID requestId;
    private final TenantId tenantId;
    private final RepositorySettings settings;

    public VersionControlRequestCtx(TransportProtos.ToVersionControlServiceMsg msg, RepositorySettings settings) {
        this.nodeId = msg.getNodeId();
        this.requestId = new UUID(msg.getRequestIdMSB(), msg.getRequestIdLSB());
        this.tenantId = TenantId.fromUUID((UUID)new UUID(msg.getTenantIdMSB(), msg.getTenantIdLSB()));
        this.settings = settings;
    }

    public String toString() {
        return "VersionControlRequestCtx{nodeId='" + this.nodeId + "', requestId=" + this.requestId + ", tenantId=" + this.tenantId + "}";
    }

    @ConstructorProperties(value={"nodeId", "requestId", "tenantId", "settings"})
    public VersionControlRequestCtx(String nodeId, UUID requestId, TenantId tenantId, RepositorySettings settings) {
        this.nodeId = nodeId;
        this.requestId = requestId;
        this.tenantId = tenantId;
        this.settings = settings;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public UUID getRequestId() {
        return this.requestId;
    }

    public TenantId getTenantId() {
        return this.tenantId;
    }

    public RepositorySettings getSettings() {
        return this.settings;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VersionControlRequestCtx)) {
            return false;
        }
        VersionControlRequestCtx other = (VersionControlRequestCtx)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$nodeId = this.getNodeId();
        String other$nodeId = other.getNodeId();
        if (this$nodeId == null ? other$nodeId != null : !this$nodeId.equals(other$nodeId)) {
            return false;
        }
        UUID this$requestId = this.getRequestId();
        UUID other$requestId = other.getRequestId();
        if (this$requestId == null ? other$requestId != null : !((Object)this$requestId).equals(other$requestId)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        RepositorySettings this$settings = this.getSettings();
        RepositorySettings other$settings = other.getSettings();
        return !(this$settings == null ? other$settings != null : !this$settings.equals(other$settings));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VersionControlRequestCtx;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $nodeId = this.getNodeId();
        result = result * 59 + ($nodeId == null ? 43 : $nodeId.hashCode());
        UUID $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : ((Object)$requestId).hashCode());
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        RepositorySettings $settings = this.getSettings();
        result = result * 59 + ($settings == null ? 43 : $settings.hashCode());
        return result;
    }
}

