/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.sync.vc;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.thingsboard.server.common.data.id.TenantId;

public class PendingCommit {
    private final UUID txId;
    private final String nodeId;
    private final TenantId tenantId;
    private final String workingBranch;
    private String branch;
    private String versionName;
    private String authorName;
    private String authorEmail;
    private Map<String, String[]> chunkedMsgs;

    public PendingCommit(TenantId tenantId, String nodeId, UUID txId, String branch, String versionName, String authorName, String authorEmail) {
        this.tenantId = tenantId;
        this.nodeId = nodeId;
        this.txId = txId;
        this.branch = branch;
        this.versionName = versionName;
        this.authorName = authorName;
        this.authorEmail = authorEmail;
        this.workingBranch = txId.toString();
    }

    public Map<String, String[]> getChunkedMsgs() {
        if (this.chunkedMsgs == null) {
            this.chunkedMsgs = new ConcurrentHashMap<String, String[]>();
        }
        return this.chunkedMsgs;
    }

    public UUID getTxId() {
        return this.txId;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public TenantId getTenantId() {
        return this.tenantId;
    }

    public String getWorkingBranch() {
        return this.workingBranch;
    }

    public String getBranch() {
        return this.branch;
    }

    public String getVersionName() {
        return this.versionName;
    }

    public String getAuthorName() {
        return this.authorName;
    }

    public String getAuthorEmail() {
        return this.authorEmail;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public void setVersionName(String versionName) {
        this.versionName = versionName;
    }

    public void setAuthorName(String authorName) {
        this.authorName = authorName;
    }

    public void setAuthorEmail(String authorEmail) {
        this.authorEmail = authorEmail;
    }

    public void setChunkedMsgs(Map<String, String[]> chunkedMsgs) {
        this.chunkedMsgs = chunkedMsgs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PendingCommit)) {
            return false;
        }
        PendingCommit other = (PendingCommit)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$txId = this.getTxId();
        UUID other$txId = other.getTxId();
        if (this$txId == null ? other$txId != null : !((Object)this$txId).equals(other$txId)) {
            return false;
        }
        String this$nodeId = this.getNodeId();
        String other$nodeId = other.getNodeId();
        if (this$nodeId == null ? other$nodeId != null : !this$nodeId.equals(other$nodeId)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$workingBranch = this.getWorkingBranch();
        String other$workingBranch = other.getWorkingBranch();
        if (this$workingBranch == null ? other$workingBranch != null : !this$workingBranch.equals(other$workingBranch)) {
            return false;
        }
        String this$branch = this.getBranch();
        String other$branch = other.getBranch();
        if (this$branch == null ? other$branch != null : !this$branch.equals(other$branch)) {
            return false;
        }
        String this$versionName = this.getVersionName();
        String other$versionName = other.getVersionName();
        if (this$versionName == null ? other$versionName != null : !this$versionName.equals(other$versionName)) {
            return false;
        }
        String this$authorName = this.getAuthorName();
        String other$authorName = other.getAuthorName();
        if (this$authorName == null ? other$authorName != null : !this$authorName.equals(other$authorName)) {
            return false;
        }
        String this$authorEmail = this.getAuthorEmail();
        String other$authorEmail = other.getAuthorEmail();
        if (this$authorEmail == null ? other$authorEmail != null : !this$authorEmail.equals(other$authorEmail)) {
            return false;
        }
        Map<String, String[]> this$chunkedMsgs = this.getChunkedMsgs();
        Map<String, String[]> other$chunkedMsgs = other.getChunkedMsgs();
        return !(this$chunkedMsgs == null ? other$chunkedMsgs != null : !((Object)this$chunkedMsgs).equals(other$chunkedMsgs));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PendingCommit;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $txId = this.getTxId();
        result = result * 59 + ($txId == null ? 43 : ((Object)$txId).hashCode());
        String $nodeId = this.getNodeId();
        result = result * 59 + ($nodeId == null ? 43 : $nodeId.hashCode());
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $workingBranch = this.getWorkingBranch();
        result = result * 59 + ($workingBranch == null ? 43 : $workingBranch.hashCode());
        String $branch = this.getBranch();
        result = result * 59 + ($branch == null ? 43 : $branch.hashCode());
        String $versionName = this.getVersionName();
        result = result * 59 + ($versionName == null ? 43 : $versionName.hashCode());
        String $authorName = this.getAuthorName();
        result = result * 59 + ($authorName == null ? 43 : $authorName.hashCode());
        String $authorEmail = this.getAuthorEmail();
        result = result * 59 + ($authorEmail == null ? 43 : $authorEmail.hashCode());
        Map<String, String[]> $chunkedMsgs = this.getChunkedMsgs();
        result = result * 59 + ($chunkedMsgs == null ? 43 : ((Object)$chunkedMsgs).hashCode());
        return result;
    }

    public String toString() {
        return "PendingCommit(txId=" + this.getTxId() + ", nodeId=" + this.getNodeId() + ", tenantId=" + this.getTenantId() + ", workingBranch=" + this.getWorkingBranch() + ", branch=" + this.getBranch() + ", versionName=" + this.getVersionName() + ", authorName=" + this.getAuthorName() + ", authorEmail=" + this.getAuthorEmail() + ", chunkedMsgs=" + this.getChunkedMsgs() + ")";
    }
}

