/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.sync.vc;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.sync.vc.BranchInfo;
import org.thingsboard.server.common.data.sync.vc.EntityVersion;
import org.thingsboard.server.common.data.sync.vc.RepositorySettings;
import org.thingsboard.server.common.data.sync.vc.VersionCreationResult;
import org.thingsboard.server.common.data.sync.vc.VersionedEntityInfo;
import org.thingsboard.server.service.sync.vc.GitRepository;
import org.thingsboard.server.service.sync.vc.PendingCommit;

public interface GitRepositoryService {
    public Set<TenantId> getActiveRepositoryTenants();

    public void prepareCommit(PendingCommit var1);

    public PageData<EntityVersion> listVersions(TenantId var1, String var2, String var3, PageLink var4) throws Exception;

    public Stream<VersionedEntityInfo> listEntitiesAtVersion(TenantId var1, String var2, String var3, EntityType var4, boolean var5, boolean var6) throws Exception;

    public void testRepository(TenantId var1, RepositorySettings var2) throws Exception;

    public void initRepository(TenantId var1, RepositorySettings var2, boolean var3) throws Exception;

    public RepositorySettings getRepositorySettings(TenantId var1) throws Exception;

    public void clearRepository(TenantId var1) throws IOException;

    public void add(PendingCommit var1, String var2, String var3) throws IOException;

    public void deleteFolderContent(PendingCommit var1, String var2, boolean var3) throws IOException;

    public VersionCreationResult push(PendingCommit var1);

    public void cleanUp(PendingCommit var1);

    public void abort(PendingCommit var1);

    public List<BranchInfo> listBranches(TenantId var1);

    public String getFileContentAtCommit(TenantId var1, String var2, String var3);

    public List<GitRepository.Diff> getVersionsDiffList(TenantId var1, String var2, String var3, String var4) throws IOException;

    public String getContentsDiff(TenantId var1, String var2, String var3) throws IOException;

    public void fetch(TenantId var1) throws GitAPIException;

    public List<GitRepository.RepoFile> listFiles(TenantId var1, String var2, String var3, int var4);
}

