/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.sync.vc;

import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.google.common.collect.Streams;
import java.beans.ConstructorProperties;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.LogCommand;
import org.eclipse.jgit.api.LsRemoteCommand;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.TransportCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.diff.EditList;
import org.eclipse.jgit.diff.HistogramDiff;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.diff.Sequence;
import org.eclipse.jgit.diff.SequenceComparator;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.SshTransport;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.eclipse.jgit.transport.sshd.JGitKeyCache;
import org.eclipse.jgit.transport.sshd.KeyCache;
import org.eclipse.jgit.transport.sshd.ServerKeyDatabase;
import org.eclipse.jgit.transport.sshd.SshdSessionFactory;
import org.eclipse.jgit.transport.sshd.SshdSessionFactoryBuilder;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.page.SortOrder;
import org.thingsboard.server.common.data.sync.vc.BranchInfo;
import org.thingsboard.server.common.data.sync.vc.RepositoryAuthMethod;
import org.thingsboard.server.common.data.sync.vc.RepositorySettings;
import org.thingsboard.server.common.data.util.CollectionsUtil;

public class GitRepository {
    private static final Logger log = LoggerFactory.getLogger(GitRepository.class);
    private final Git git;
    private final AuthHandler authHandler;
    private final RepositorySettings settings;
    private final String directory;
    private ObjectId headId;
    private static final Function<PageLink, Comparator<RevCommit>> revCommitComparatorFunction = pageLink -> {
        SortOrder sortOrder = pageLink.getSortOrder();
        if (sortOrder != null && sortOrder.getProperty().equals("timestamp") && SortOrder.Direction.ASC.equals((Object)sortOrder.getDirection())) {
            return Comparator.comparingInt(RevCommit::getCommitTime);
        }
        return null;
    };

    private GitRepository(Git git, RepositorySettings settings, AuthHandler authHandler, String directory) {
        this.git = git;
        this.settings = settings;
        this.authHandler = authHandler;
        this.directory = directory;
    }

    public static GitRepository create(RepositorySettings settings, File directory) throws GitAPIException {
        log.debug("Executing create [{}]", (Object)directory);
        Git git = Git.init().setDirectory(directory).call();
        return new GitRepository(git, settings, null, directory.getAbsolutePath());
    }

    public static GitRepository clone(RepositorySettings settings, File directory) throws GitAPIException {
        log.debug("Executing clone [{}]", (Object)settings.getRepositoryUri());
        CloneCommand cloneCommand = Git.cloneRepository().setURI(settings.getRepositoryUri()).setDirectory(directory).setNoCheckout(true);
        AuthHandler authHandler = AuthHandler.createFor(settings, directory);
        authHandler.configureCommand((TransportCommand)cloneCommand);
        Git git = cloneCommand.call();
        return new GitRepository(git, settings, authHandler, directory.getAbsolutePath());
    }

    public static GitRepository open(File directory, RepositorySettings settings) throws IOException {
        log.debug("Executing open [{}][{}]", (Object)settings.getRepositoryUri(), (Object)directory);
        Git git = Git.open((File)directory);
        AuthHandler authHandler = AuthHandler.createFor(settings, directory);
        return new GitRepository(git, settings, authHandler, directory.getAbsolutePath());
    }

    public static GitRepository openOrClone(Path directory, RepositorySettings settings, boolean fetch) throws IOException, GitAPIException {
        GitRepository repository;
        if (GitRepository.exists(directory.toString())) {
            repository = GitRepository.open(directory.toFile(), settings);
            if (fetch) {
                repository.fetch();
            }
        } else {
            FileUtils.deleteDirectory((File)directory.toFile());
            Files.createDirectories(directory, new FileAttribute[0]);
            repository = settings.isLocalOnly() ? GitRepository.create(settings, directory.toFile()) : GitRepository.clone(settings, directory.toFile());
        }
        return repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void test(RepositorySettings settings, File directory) throws Exception {
        if (settings.isLocalOnly()) {
            return;
        }
        log.debug("Executing test [{}]", (Object)settings.getRepositoryUri());
        AuthHandler authHandler = AuthHandler.createFor(settings, directory);
        if (settings.isReadOnly()) {
            LsRemoteCommand lsRemoteCommand = Git.lsRemoteRepository().setRemote(settings.getRepositoryUri());
            authHandler.configureCommand((TransportCommand)lsRemoteCommand);
            lsRemoteCommand.call();
        } else {
            Files.createDirectories(directory.toPath(), new FileAttribute[0]);
            try {
                Git git = Git.init().setDirectory(directory).call();
                GitRepository repository = new GitRepository(git, settings, authHandler, directory.getAbsolutePath());
                repository.execute(repository.git.remoteAdd().setName("origin").setUri(new URIish(settings.getRepositoryUri())));
                repository.push("", UUID.randomUUID().toString());
            }
            finally {
                try {
                    FileUtils.forceDelete((File)directory);
                }
                catch (Exception exception) {}
            }
        }
    }

    public boolean fetch() throws GitAPIException {
        if (this.settings.isLocalOnly()) {
            return false;
        }
        log.debug("Executing fetch [{}]", (Object)this.settings.getRepositoryUri());
        FetchResult result = (FetchResult)this.execute(this.git.fetch().setRemoveDeletedRefs(true));
        Ref head = result.getAdvertisedRef("HEAD");
        if (head != null) {
            this.headId = head.getObjectId();
        }
        return CollectionsUtil.isNotEmpty((Collection)result.getTrackingRefUpdates());
    }

    public void deleteLocalBranchIfExists(String branch) throws GitAPIException {
        log.debug("Executing deleteLocalBranchIfExists [{}][{}]", (Object)this.settings.getRepositoryUri(), (Object)branch);
        this.execute(this.git.branchDelete().setBranchNames(new String[]{branch}).setForce(true));
    }

    public void resetAndClean() throws GitAPIException {
        log.debug("Executing resetAndClean [{}]", (Object)this.settings.getRepositoryUri());
        this.execute(this.git.reset().setMode(ResetCommand.ResetType.HARD));
        this.execute(this.git.clean().setForce(true).setCleanDirectories(true));
    }

    public void merge(String branch) throws IOException, GitAPIException {
        log.debug("Executing merge [{}][{}]", (Object)this.settings.getRepositoryUri(), (Object)branch);
        ObjectId branchId = this.resolve("origin/" + branch);
        if (branchId == null) {
            throw new IllegalArgumentException("Branch not found");
        }
        this.execute(this.git.merge().include((AnyObjectId)branchId));
    }

    public List<BranchInfo> listBranches() throws GitAPIException {
        log.debug("Executing listBranches [{}]", (Object)this.settings.getRepositoryUri());
        return ((List)this.execute(this.git.branchList().setListMode(this.settings.isLocalOnly() ? ListBranchCommand.ListMode.ALL : ListBranchCommand.ListMode.REMOTE))).stream().filter(ref -> !ref.getName().equals("HEAD")).map(this::toBranchInfo).distinct().collect(Collectors.toList());
    }

    public PageData<Commit> listCommits(String branch, PageLink pageLink) throws IOException, GitAPIException {
        return this.listCommits(branch, null, pageLink);
    }

    public PageData<Commit> listCommits(String branch, String path, PageLink pageLink) throws IOException, GitAPIException {
        log.debug("Executing listCommits [{}][{}][{}]", new Object[]{this.settings.getRepositoryUri(), branch, path});
        ObjectId branchId = this.resolve("origin/" + branch);
        if (branchId == null) {
            return new PageData();
        }
        LogCommand command = this.git.log().add((AnyObjectId)branchId);
        command.setRevFilter((RevFilter)new CommitFilter(pageLink.getTextSearch(), this.settings.isShowMergeCommits()));
        if (StringUtils.isNotEmpty((CharSequence)path)) {
            command.addPath(path);
        }
        Iterable commits = (Iterable)this.execute(command);
        return GitRepository.iterableToPageData(commits, this::toCommit, pageLink, revCommitComparatorFunction);
    }

    public List<String> listAllFilesAtCommit(String commitId) {
        return this.listAllFilesAtCommit(commitId, null);
    }

    public List<String> listAllFilesAtCommit(String commitId, String path) {
        log.debug("Executing listAllFilesAtCommit [{}][{}][{}]", new Object[]{this.settings.getRepositoryUri(), commitId, path});
        return this.listFilesAtCommit(commitId, path, -1).stream().map(RepoFile::path).toList();
    }

    public List<RepoFile> listFilesAtCommit(String commitId, String path, int depth) {
        log.debug("Executing listFilesAtCommit [{}][{}][{}]", new Object[]{this.settings.getRepositoryUri(), commitId, path});
        ArrayList<RepoFile> files = new ArrayList<RepoFile>();
        RevCommit revCommit = this.resolveCommit(commitId);
        try (TreeWalk treeWalk = new TreeWalk(this.git.getRepository());){
            treeWalk.reset((AnyObjectId)revCommit.getTree().getId());
            if (StringUtils.isNotEmpty((CharSequence)path)) {
                treeWalk.setFilter((TreeFilter)PathFilter.create((String)path));
            }
            boolean fixedDepth = depth != -1;
            treeWalk.setRecursive(!fixedDepth);
            while (treeWalk.next()) {
                if (!fixedDepth || treeWalk.getDepth() == depth) {
                    files.add(new RepoFile(treeWalk.getPathString(), treeWalk.getNameString(), treeWalk.isSubtree() ? FileType.DIRECTORY : FileType.FILE));
                }
                if (!fixedDepth || treeWalk.getDepth() >= depth) continue;
                treeWalk.enterSubtree();
            }
        }
        return files;
    }

    /*
     * Exception decompiling
     */
    public byte[] getFileContentAtCommit(String file, String commitId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void createAndCheckoutOrphanBranch(String name) throws GitAPIException {
        log.debug("Executing createAndCheckoutOrphanBranch [{}][{}]", (Object)this.settings.getRepositoryUri(), (Object)name);
        this.execute(this.git.checkout().setOrphan(true).setForced(true).setName(name));
    }

    public void checkoutBranch(String name) throws GitAPIException {
        log.debug("Executing checkoutBranch [{}][{}]", (Object)this.settings.getRepositoryUri(), (Object)name);
        this.git.checkout().setForced(true).setName(name).call();
    }

    public void add(String filesPattern) throws GitAPIException {
        log.debug("Executing add [{}][{}]", (Object)this.settings.getRepositoryUri(), (Object)filesPattern);
        this.execute(this.git.add().setUpdate(true).addFilepattern(filesPattern));
        this.execute(this.git.add().addFilepattern(filesPattern));
    }

    public Status status() throws GitAPIException {
        log.debug("Executing status [{}]", (Object)this.settings.getRepositoryUri());
        org.eclipse.jgit.api.Status status = (org.eclipse.jgit.api.Status)this.execute(this.git.status());
        HashSet<String> modified = new HashSet<String>();
        modified.addAll(status.getModified());
        modified.addAll(status.getChanged());
        return new Status(status.getAdded(), modified, status.getRemoved());
    }

    public Commit commit(String message, String authorName, String authorEmail) throws GitAPIException {
        log.debug("Executing commit [{}][{}]", (Object)this.settings.getRepositoryUri(), (Object)message);
        RevCommit revCommit = (RevCommit)this.execute(this.git.commit().setAuthor(authorName, authorEmail).setMessage(message));
        return this.toCommit(revCommit);
    }

    public void push(String localBranch, String remoteBranch) throws GitAPIException {
        if (this.settings.isLocalOnly()) {
            return;
        }
        log.debug("Executing push [{}][{}]", (Object)this.settings.getRepositoryUri(), (Object)remoteBranch);
        Iterable result = (Iterable)this.execute(this.git.push().setRefSpecs(new RefSpec[]{new RefSpec(localBranch + ":" + remoteBranch)}));
        result.forEach(pushResult -> {
            for (RemoteRefUpdate update : pushResult.getRemoteUpdates()) {
                RemoteRefUpdate.Status status = update.getStatus();
                if (status == RemoteRefUpdate.Status.OK || status == RemoteRefUpdate.Status.UP_TO_DATE) continue;
                throw new RuntimeException("Failed to push changes: " + Optional.ofNullable(update.getMessage()).orElseGet(() -> status.name()));
            }
        });
    }

    public String getContentsDiff(String content1, String content2) throws IOException {
        RawText rawContent1 = new RawText(content1.getBytes());
        RawText rawContent2 = new RawText(content2.getBytes());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DiffFormatter diffFormatter = new DiffFormatter((OutputStream)out);
        diffFormatter.setRepository(this.git.getRepository());
        EditList edits = new EditList();
        edits.addAll((Collection)new HistogramDiff().diff((SequenceComparator)RawTextComparator.DEFAULT, (Sequence)rawContent1, (Sequence)rawContent2));
        diffFormatter.format(edits, rawContent1, rawContent2);
        return out.toString();
    }

    public List<Diff> getDiffList(String commit1, String commit2, String path) throws IOException {
        ObjectReader reader = this.git.getRepository().newObjectReader();
        CanonicalTreeParser tree1Iter = new CanonicalTreeParser();
        RevTree tree1 = this.resolveCommit(commit1).getTree();
        tree1Iter.reset(reader, (AnyObjectId)tree1);
        CanonicalTreeParser tree2Iter = new CanonicalTreeParser();
        RevTree tree2 = this.resolveCommit(commit2).getTree();
        tree2Iter.reset(reader, (AnyObjectId)tree2);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DiffFormatter diffFormatter = new DiffFormatter((OutputStream)out);
        diffFormatter.setRepository(this.git.getRepository());
        if (StringUtils.isNotEmpty((CharSequence)path)) {
            diffFormatter.setPathFilter((TreeFilter)PathFilter.create((String)path));
        }
        return diffFormatter.scan((AnyObjectId)tree1, (AnyObjectId)tree2).stream().map(diffEntry -> {
            Diff diff = new Diff();
            try {
                out.reset();
                diffFormatter.format(diffEntry);
                diff.setDiffStringValue(out.toString());
                diff.setFilePath(diffEntry.getChangeType() != DiffEntry.ChangeType.DELETE ? diffEntry.getNewPath() : diffEntry.getOldPath());
                diff.setChangeType(diffEntry.getChangeType());
                try {
                    diff.setFileContentAtCommit1(new String(this.getFileContentAtCommit(diff.getFilePath(), commit1), StandardCharsets.UTF_8));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                try {
                    diff.setFileContentAtCommit2(new String(this.getFileContentAtCommit(diff.getFilePath(), commit2), StandardCharsets.UTF_8));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                return diff;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
    }

    private BranchInfo toBranchInfo(Ref ref) {
        String name = Repository.shortenRefName((String)ref.getName());
        String branchName = StringUtils.removeStart((String)name, (String)"origin/");
        boolean isDefault = this.headId != null && this.headId.equals((AnyObjectId)ref.getObjectId());
        return new BranchInfo(branchName, isDefault);
    }

    private Commit toCommit(RevCommit revCommit) {
        return new Commit((long)revCommit.getCommitTime() * 1000L, revCommit.getName(), revCommit.getFullMessage(), revCommit.getAuthorIdent().getName(), revCommit.getAuthorIdent().getEmailAddress());
    }

    private RevCommit resolveCommit(String id) throws IOException {
        return this.git.getRepository().parseCommit((AnyObjectId)this.resolve(id));
    }

    private ObjectId resolve(String rev) throws IOException {
        ObjectId result;
        if (this.settings.isLocalOnly()) {
            rev = StringUtils.removeStart((String)rev, (String)"origin/");
        }
        if ((result = this.git.getRepository().resolve(rev)) == null) {
            throw new IllegalArgumentException("Failed to parse git revision string: \"" + rev + "\"");
        }
        return result;
    }

    public static boolean exists(String directory) {
        File gitDirectory = Path.of(directory, ".git").toFile();
        return FileUtils.isDirectory((File)gitDirectory, (LinkOption[])new LinkOption[0]) && !FileUtils.isEmptyDirectory((File)gitDirectory);
    }

    private <C extends GitCommand<T>, T> T execute(C command) throws GitAPIException {
        if (command instanceof TransportCommand) {
            TransportCommand transportCommand = (TransportCommand)command;
            if (this.authHandler != null) {
                this.authHandler.configureCommand(transportCommand);
            }
        }
        return (T)command.call();
    }

    private static <T, R> PageData<R> iterableToPageData(Iterable<T> iterable, Function<? super T, ? extends R> mapper, PageLink pageLink, Function<PageLink, Comparator<T>> comparatorFunction) {
        Comparator<T> comparator;
        iterable = Streams.stream(iterable).collect(Collectors.toList());
        int totalElements = Iterables.size((Iterable)iterable);
        int totalPages = pageLink.getPageSize() > 0 ? (int)Math.ceil((float)totalElements / (float)pageLink.getPageSize()) : 1;
        int startIndex = pageLink.getPageSize() * pageLink.getPage();
        int limit = startIndex + pageLink.getPageSize();
        if (comparatorFunction != null && (comparator = comparatorFunction.apply(pageLink)) != null) {
            iterable = Ordering.from(comparator).immutableSortedCopy(iterable);
        }
        iterable = Iterables.limit((Iterable)iterable, (int)limit);
        iterable = startIndex < totalElements ? Iterables.skip(iterable, (int)startIndex) : Collections.emptyList();
        List data = Streams.stream(iterable).map(mapper).collect(Collectors.toList());
        boolean hasNext = pageLink.getPageSize() > 0 && totalElements > startIndex + data.size();
        return new PageData(data, totalPages, (long)totalElements, hasNext);
    }

    public RepositorySettings getSettings() {
        return this.settings;
    }

    public String getDirectory() {
        return this.directory;
    }

    private static class AuthHandler {
        private final CredentialsProvider credentialsProvider;
        private final SshdSessionFactory sshSessionFactory;

        protected static AuthHandler createFor(RepositorySettings settings, File directory) {
            if (settings.isLocalOnly()) {
                return null;
            }
            CredentialsProvider credentialsProvider = null;
            SshdSessionFactory sshSessionFactory = null;
            if (RepositoryAuthMethod.USERNAME_PASSWORD.equals((Object)settings.getAuthMethod())) {
                credentialsProvider = AuthHandler.newCredentialsProvider(settings.getUsername(), settings.getPassword());
            } else if (RepositoryAuthMethod.PRIVATE_KEY.equals((Object)settings.getAuthMethod())) {
                if (StringUtils.startsWith((CharSequence)settings.getRepositoryUri(), (CharSequence)"https://")) {
                    throw new IllegalArgumentException("Invalid URI format for private key authentication");
                }
                sshSessionFactory = AuthHandler.newSshdSessionFactory(settings.getPrivateKey(), settings.getPrivateKeyPassword(), directory);
            }
            return new AuthHandler(credentialsProvider, sshSessionFactory);
        }

        protected void configureCommand(TransportCommand command) {
            if (this.credentialsProvider != null) {
                command.setCredentialsProvider(this.credentialsProvider);
            }
            if (this.sshSessionFactory != null) {
                command.setTransportConfigCallback(transport -> {
                    if (transport instanceof SshTransport) {
                        SshTransport sshTransport = (SshTransport)transport;
                        sshTransport.setSshSessionFactory((SshSessionFactory)this.sshSessionFactory);
                    }
                });
            }
        }

        private static CredentialsProvider newCredentialsProvider(String username, String password) {
            return new UsernamePasswordCredentialsProvider(username, password == null ? "" : password);
        }

        private static SshdSessionFactory newSshdSessionFactory(String privateKey, String password, File directory) {
            SshdSessionFactory sshSessionFactory = null;
            if (StringUtils.isNotBlank((CharSequence)privateKey)) {
                Iterable<KeyPair> keyPairs = AuthHandler.loadKeyPairs(privateKey, password);
                sshSessionFactory = new SshdSessionFactoryBuilder().setPreferredAuthentications("publickey").setDefaultKeysProvider(file -> keyPairs).setHomeDirectory(directory).setSshDirectory(directory).setServerKeyDatabase((file, file2) -> new ServerKeyDatabase(){

                    public List<PublicKey> lookup(String connectAddress, InetSocketAddress remoteAddress, ServerKeyDatabase.Configuration config) {
                        return Collections.emptyList();
                    }

                    public boolean accept(String connectAddress, InetSocketAddress remoteAddress, PublicKey serverKey, ServerKeyDatabase.Configuration config, CredentialsProvider provider) {
                        return true;
                    }
                }).build((KeyCache)new JGitKeyCache());
            }
            return sshSessionFactory;
        }

        private static Iterable<KeyPair> loadKeyPairs(String privateKeyContent, String password) {
            Iterable keyPairs = null;
            try {
                keyPairs = SecurityUtils.loadKeyPairIdentities(null, null, (InputStream)new ByteArrayInputStream(privateKeyContent.getBytes()), (session, resourceKey, retryIndex) -> password);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (keyPairs == null) {
                throw new IllegalArgumentException("Failed to load ssh private key");
            }
            return keyPairs;
        }

        @ConstructorProperties(value={"credentialsProvider", "sshSessionFactory"})
        public AuthHandler(CredentialsProvider credentialsProvider, SshdSessionFactory sshSessionFactory) {
            this.credentialsProvider = credentialsProvider;
            this.sshSessionFactory = sshSessionFactory;
        }
    }

    private static class CommitFilter
    extends RevFilter {
        private final String textSearch;
        private final boolean showMergeCommits;

        CommitFilter(String textSearch, boolean showMergeCommits) {
            this.textSearch = textSearch.toLowerCase();
            this.showMergeCommits = showMergeCommits;
        }

        public boolean include(RevWalk walker, RevCommit c) {
            return !(!this.showMergeCommits && c.getParentCount() >= 2 || !StringUtils.isEmpty((CharSequence)this.textSearch) && !c.getFullMessage().toLowerCase().contains(this.textSearch));
        }

        public RevFilter clone() {
            return this;
        }

        public boolean requiresCommitBody() {
            return false;
        }
    }

    public record RepoFile(String path, String name, FileType type) {
    }

    public static enum FileType {
        FILE,
        DIRECTORY;

    }

    public static class Status {
        private final Set<String> added;
        private final Set<String> modified;
        private final Set<String> removed;

        @ConstructorProperties(value={"added", "modified", "removed"})
        public Status(Set<String> added, Set<String> modified, Set<String> removed) {
            this.added = added;
            this.modified = modified;
            this.removed = removed;
        }

        public Set<String> getAdded() {
            return this.added;
        }

        public Set<String> getModified() {
            return this.modified;
        }

        public Set<String> getRemoved() {
            return this.removed;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Status)) {
                return false;
            }
            Status other = (Status)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Set<String> this$added = this.getAdded();
            Set<String> other$added = other.getAdded();
            if (this$added == null ? other$added != null : !((Object)this$added).equals(other$added)) {
                return false;
            }
            Set<String> this$modified = this.getModified();
            Set<String> other$modified = other.getModified();
            if (this$modified == null ? other$modified != null : !((Object)this$modified).equals(other$modified)) {
                return false;
            }
            Set<String> this$removed = this.getRemoved();
            Set<String> other$removed = other.getRemoved();
            return !(this$removed == null ? other$removed != null : !((Object)this$removed).equals(other$removed));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Status;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Set<String> $added = this.getAdded();
            result = result * 59 + ($added == null ? 43 : ((Object)$added).hashCode());
            Set<String> $modified = this.getModified();
            result = result * 59 + ($modified == null ? 43 : ((Object)$modified).hashCode());
            Set<String> $removed = this.getRemoved();
            result = result * 59 + ($removed == null ? 43 : ((Object)$removed).hashCode());
            return result;
        }

        public String toString() {
            return "GitRepository.Status(added=" + this.getAdded() + ", modified=" + this.getModified() + ", removed=" + this.getRemoved() + ")";
        }
    }

    public static class Commit {
        private final long timestamp;
        private final String id;
        private final String message;
        private final String authorName;
        private final String authorEmail;

        @ConstructorProperties(value={"timestamp", "id", "message", "authorName", "authorEmail"})
        public Commit(long timestamp, String id, String message, String authorName, String authorEmail) {
            this.timestamp = timestamp;
            this.id = id;
            this.message = message;
            this.authorName = authorName;
            this.authorEmail = authorEmail;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public String getId() {
            return this.id;
        }

        public String getMessage() {
            return this.message;
        }

        public String getAuthorName() {
            return this.authorName;
        }

        public String getAuthorEmail() {
            return this.authorEmail;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Commit)) {
                return false;
            }
            Commit other = (Commit)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getTimestamp() != other.getTimestamp()) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                return false;
            }
            String this$authorName = this.getAuthorName();
            String other$authorName = other.getAuthorName();
            if (this$authorName == null ? other$authorName != null : !this$authorName.equals(other$authorName)) {
                return false;
            }
            String this$authorEmail = this.getAuthorEmail();
            String other$authorEmail = other.getAuthorEmail();
            return !(this$authorEmail == null ? other$authorEmail != null : !this$authorEmail.equals(other$authorEmail));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Commit;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $timestamp = this.getTimestamp();
            result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            String $authorName = this.getAuthorName();
            result = result * 59 + ($authorName == null ? 43 : $authorName.hashCode());
            String $authorEmail = this.getAuthorEmail();
            result = result * 59 + ($authorEmail == null ? 43 : $authorEmail.hashCode());
            return result;
        }

        public String toString() {
            return "GitRepository.Commit(timestamp=" + this.getTimestamp() + ", id=" + this.getId() + ", message=" + this.getMessage() + ", authorName=" + this.getAuthorName() + ", authorEmail=" + this.getAuthorEmail() + ")";
        }
    }

    public static class Diff {
        private String filePath;
        private DiffEntry.ChangeType changeType;
        private String fileContentAtCommit1;
        private String fileContentAtCommit2;
        private String diffStringValue;

        public String getFilePath() {
            return this.filePath;
        }

        public DiffEntry.ChangeType getChangeType() {
            return this.changeType;
        }

        public String getFileContentAtCommit1() {
            return this.fileContentAtCommit1;
        }

        public String getFileContentAtCommit2() {
            return this.fileContentAtCommit2;
        }

        public String getDiffStringValue() {
            return this.diffStringValue;
        }

        public void setFilePath(String filePath) {
            this.filePath = filePath;
        }

        public void setChangeType(DiffEntry.ChangeType changeType) {
            this.changeType = changeType;
        }

        public void setFileContentAtCommit1(String fileContentAtCommit1) {
            this.fileContentAtCommit1 = fileContentAtCommit1;
        }

        public void setFileContentAtCommit2(String fileContentAtCommit2) {
            this.fileContentAtCommit2 = fileContentAtCommit2;
        }

        public void setDiffStringValue(String diffStringValue) {
            this.diffStringValue = diffStringValue;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Diff)) {
                return false;
            }
            Diff other = (Diff)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$filePath = this.getFilePath();
            String other$filePath = other.getFilePath();
            if (this$filePath == null ? other$filePath != null : !this$filePath.equals(other$filePath)) {
                return false;
            }
            DiffEntry.ChangeType this$changeType = this.getChangeType();
            DiffEntry.ChangeType other$changeType = other.getChangeType();
            if (this$changeType == null ? other$changeType != null : !this$changeType.equals(other$changeType)) {
                return false;
            }
            String this$fileContentAtCommit1 = this.getFileContentAtCommit1();
            String other$fileContentAtCommit1 = other.getFileContentAtCommit1();
            if (this$fileContentAtCommit1 == null ? other$fileContentAtCommit1 != null : !this$fileContentAtCommit1.equals(other$fileContentAtCommit1)) {
                return false;
            }
            String this$fileContentAtCommit2 = this.getFileContentAtCommit2();
            String other$fileContentAtCommit2 = other.getFileContentAtCommit2();
            if (this$fileContentAtCommit2 == null ? other$fileContentAtCommit2 != null : !this$fileContentAtCommit2.equals(other$fileContentAtCommit2)) {
                return false;
            }
            String this$diffStringValue = this.getDiffStringValue();
            String other$diffStringValue = other.getDiffStringValue();
            return !(this$diffStringValue == null ? other$diffStringValue != null : !this$diffStringValue.equals(other$diffStringValue));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Diff;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $filePath = this.getFilePath();
            result = result * 59 + ($filePath == null ? 43 : $filePath.hashCode());
            DiffEntry.ChangeType $changeType = this.getChangeType();
            result = result * 59 + ($changeType == null ? 43 : $changeType.hashCode());
            String $fileContentAtCommit1 = this.getFileContentAtCommit1();
            result = result * 59 + ($fileContentAtCommit1 == null ? 43 : $fileContentAtCommit1.hashCode());
            String $fileContentAtCommit2 = this.getFileContentAtCommit2();
            result = result * 59 + ($fileContentAtCommit2 == null ? 43 : $fileContentAtCommit2.hashCode());
            String $diffStringValue = this.getDiffStringValue();
            result = result * 59 + ($diffStringValue == null ? 43 : $diffStringValue.hashCode());
            return result;
        }

        public String toString() {
            return "GitRepository.Diff(filePath=" + this.getFilePath() + ", changeType=" + this.getChangeType() + ", fileContentAtCommit1=" + this.getFileContentAtCommit1() + ", fileContentAtCommit2=" + this.getFileContentAtCommit2() + ", diffStringValue=" + this.getDiffStringValue() + ")";
        }
    }
}

