/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.common.util.geo;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.util.GeometryFixer;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.context.jts.JtsSpatialContext;
import org.locationtech.spatial4j.context.jts.JtsSpatialContextFactory;
import org.locationtech.spatial4j.shape.SpatialRelation;
import org.locationtech.spatial4j.shape.jts.JtsGeometry;
import org.thingsboard.common.util.geo.Coordinates;
import org.thingsboard.common.util.geo.RangeUnit;

public class GeoUtil {
    private static final SpatialContext distCtx = SpatialContext.GEO;
    private static final JtsSpatialContext jtsCtx;

    public static synchronized double distance(Coordinates x, Coordinates y, RangeUnit unit) {
        org.locationtech.spatial4j.shape.Point xLL = distCtx.getShapeFactory().pointXY(x.getLongitude(), x.getLatitude());
        org.locationtech.spatial4j.shape.Point yLL = distCtx.getShapeFactory().pointXY(y.getLongitude(), y.getLatitude());
        return unit.fromKm(distCtx.getDistCalc().distance(xLL, yLL) * 111.19507973436875);
    }

    public static synchronized boolean contains(@NonNull String polygonInString, @NonNull Coordinates coordinates) {
        if (polygonInString == null) {
            throw new NullPointerException("polygonInString is marked non-null but is null");
        }
        if (coordinates == null) {
            throw new NullPointerException("coordinates is marked non-null but is null");
        }
        if (polygonInString.isEmpty() || polygonInString.isBlank()) {
            throw new RuntimeException("Polygon string can't be empty or null!");
        }
        JsonArray polygonsJson = GeoUtil.normalizePolygonsJson(JsonParser.parseString((String)polygonInString).getAsJsonArray());
        List<Geometry> polygons = GeoUtil.buildPolygonsFromJson(polygonsJson);
        Set<Geometry> holes = GeoUtil.extractHolesFrom(polygons);
        polygons.removeIf(holes::contains);
        Geometry globalGeometry = GeoUtil.unionToGlobalGeometry(polygons, holes);
        Point point = jtsCtx.getShapeFactory().getGeometryFactory().createPoint(new Coordinate(coordinates.getLatitude(), coordinates.getLongitude()));
        return globalGeometry.contains((Geometry)point);
    }

    private static Geometry unionToGlobalGeometry(List<Geometry> polygons, Set<Geometry> holes) {
        Geometry globalPolygon = (Geometry)polygons.stream().reduce(Geometry::union).orElseThrow(() -> new RuntimeException("Error while calculating globalPolygon - the result of all polygons union is null"));
        Optional globalHole = holes.stream().reduce(Geometry::union);
        if (globalHole.isEmpty()) {
            return globalPolygon;
        }
        return globalPolygon.difference((Geometry)globalHole.get());
    }

    private static JsonArray normalizePolygonsJson(JsonArray polygonsJsonArray) {
        JsonArray result = new JsonArray();
        GeoUtil.normalizePolygonsJson(polygonsJsonArray, result);
        return result;
    }

    private static void normalizePolygonsJson(JsonArray polygonsJsonArray, JsonArray result) {
        if (GeoUtil.containsArrayWithPrimitives(polygonsJsonArray)) {
            result.add((JsonElement)polygonsJsonArray);
        } else {
            for (JsonElement element : polygonsJsonArray) {
                if (GeoUtil.containsArrayWithPrimitives(element.getAsJsonArray())) {
                    result.add(element);
                    continue;
                }
                GeoUtil.normalizePolygonsJson(element.getAsJsonArray(), result);
            }
        }
    }

    private static Set<Geometry> extractHolesFrom(List<Geometry> polygons) {
        HashMap polygonsHoles = new HashMap();
        for (Geometry polygon : polygons) {
            List holes = polygons.stream().filter(another -> !another.equalsExact(polygon)).filter(another -> {
                JtsGeometry currentGeo = jtsCtx.getShapeFactory().makeShape(polygon);
                JtsGeometry anotherGeo = jtsCtx.getShapeFactory().makeShape(another);
                boolean currentContainsAnother = currentGeo.relate(anotherGeo).equals((Object)SpatialRelation.CONTAINS);
                boolean anotherWithinCurrent = anotherGeo.relate(currentGeo).equals((Object)SpatialRelation.WITHIN);
                return currentContainsAnother && anotherWithinCurrent;
            }).collect(Collectors.toList());
            if (holes.isEmpty()) continue;
            polygonsHoles.put(polygon, holes);
        }
        return polygonsHoles.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private static List<Geometry> buildPolygonsFromJson(JsonArray polygonsJsonArray) {
        LinkedList<Geometry> polygons = new LinkedList<Geometry>();
        for (JsonElement polygonJsonArray : polygonsJsonArray) {
            polygons.add(GeoUtil.buildPolygonFromCoordinates(GeoUtil.parseCoordinates(polygonJsonArray.getAsJsonArray())));
        }
        return polygons;
    }

    private static Geometry buildPolygonFromCoordinates(List<Coordinate> coordinates) {
        if (coordinates.size() == 2) {
            Coordinate a = coordinates.get(0);
            Coordinate c = coordinates.get(1);
            coordinates.clear();
            Coordinate b = new Coordinate(a.x, c.y);
            Coordinate d = new Coordinate(c.x, a.y);
            coordinates.addAll(List.of(a, b, c, d, a));
        }
        CoordinateSequence coordinateSequence = jtsCtx.getShapeFactory().getGeometryFactory().getCoordinateSequenceFactory().create(coordinates.toArray(new Coordinate[0]));
        return GeometryFixer.fix((Geometry)jtsCtx.getShapeFactory().getGeometryFactory().createPolygon(coordinateSequence));
    }

    private static List<Coordinate> parseCoordinates(JsonArray coordinatesJson) {
        LinkedList<Coordinate> result = new LinkedList<Coordinate>();
        for (JsonElement coords : coordinatesJson) {
            double x = coords.getAsJsonArray().get(0).getAsDouble();
            double y = coords.getAsJsonArray().get(1).getAsDouble();
            result.add(new Coordinate(x, y));
        }
        if (result.size() >= 3) {
            result.add((Coordinate)result.get(0));
        }
        return result;
    }

    private static boolean containsPrimitives(JsonArray array) {
        Iterator iterator = array.iterator();
        if (iterator.hasNext()) {
            JsonElement element = (JsonElement)iterator.next();
            return element.isJsonPrimitive();
        }
        return false;
    }

    private static boolean containsArrayWithPrimitives(JsonArray array) {
        for (JsonElement element : array) {
            if (GeoUtil.containsPrimitives(element.getAsJsonArray())) continue;
            return false;
        }
        return true;
    }

    static {
        JtsSpatialContextFactory factory = new JtsSpatialContextFactory();
        factory.normWrapLongitude = true;
        jtsCtx = factory.newSpatialContext();
    }
}

