/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.common.util;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ThingsBoardScheduledThreadPoolExecutor
extends ScheduledThreadPoolExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ThingsBoardScheduledThreadPoolExecutor.class);

    public ThingsBoardScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory) {
        super(corePoolSize, threadFactory);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        if (command == null) {
            throw new NullPointerException("Command is null");
        }
        return super.scheduleAtFixedRate(new PeriodicRunnable(command), initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        if (command == null) {
            throw new NullPointerException("Command is null");
        }
        return super.scheduleWithFixedDelay(new PeriodicRunnable(command), initialDelay, delay, unit);
    }

    private record PeriodicRunnable(Runnable runnable) implements Runnable
    {
        @Override
        public void run() {
            try {
                this.runnable.run();
            }
            catch (Exception e) {
                log.error("Uncaught exception occurred during periodic task execution!", (Throwable)e);
            }
            catch (Throwable th) {
                log.error("Critical exception occurred during periodic task execution!", th);
                throw th;
            }
        }
    }
}

