/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.common.util;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.thingsboard.common.util.ThingsBoardForkJoinWorkerThreadFactory;
import org.thingsboard.common.util.ThingsBoardScheduledThreadPoolExecutor;
import org.thingsboard.common.util.ThingsBoardThreadFactory;

public class ThingsBoardExecutors {
    private ThingsBoardExecutors() {
    }

    public static ExecutorService newWorkStealingPool(int parallelism, String namePrefix) {
        return new ForkJoinPool(parallelism, new ThingsBoardForkJoinWorkerThreadFactory(namePrefix), null, true);
    }

    public static ExecutorService newWorkStealingPool(int parallelism, Class clazz) {
        return ThingsBoardExecutors.newWorkStealingPool(parallelism, clazz.getSimpleName());
    }

    public static ExecutorService newLimitedTasksExecutor(int threads, int maxQueueSize, String name) {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(threads, threads, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(maxQueueSize), ThingsBoardThreadFactory.forName(name), new ThreadPoolExecutor.CallerRunsPolicy());
        executor.allowCoreThreadTimeOut(true);
        return executor;
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor(String name) {
        return Executors.unconfigurableScheduledExecutorService(new ThingsBoardScheduledThreadPoolExecutor(1, ThingsBoardThreadFactory.forName(name)));
    }

    public static ScheduledExecutorService newScheduledThreadPool(int corePoolSize, String name) {
        return new ThingsBoardScheduledThreadPoolExecutor(corePoolSize, ThingsBoardThreadFactory.forName(name));
    }
}

