/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.common.util;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.concurrent.TimeUnit;

public class SetCache<K> {
    private static final Object DUMMY_VALUE = Boolean.TRUE;
    private final Cache<K, Object> cache;

    public SetCache(long valueTtlMs) {
        this.cache = Caffeine.newBuilder().expireAfterWrite(valueTtlMs, TimeUnit.MILLISECONDS).build();
    }

    public void add(K key) {
        this.cache.put(key, DUMMY_VALUE);
    }

    public boolean contains(K key) {
        return this.cache.asMap().containsKey(key);
    }

    public void remove(K key) {
        this.cache.invalidate(key);
    }
}

