/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.common.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.json.JsonWriteFeature;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Contract;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.RegexUtils;
import org.thingsboard.server.common.data.Views;
import org.thingsboard.server.common.data.kv.DataType;
import org.thingsboard.server.common.data.kv.KvEntry;

public class JacksonUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JacksonUtil.class);
    public static final ObjectMapper OBJECT_MAPPER = ((JsonMapper.Builder)JsonMapper.builder().addModule((Module)new Jdk8Module())).build();
    public static final ObjectMapper PRETTY_SORTED_JSON_MAPPER = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().addModule((Module)new Jdk8Module())).enable(new SerializationFeature[]{SerializationFeature.INDENT_OUTPUT})).configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true)).configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true)).build();
    public static ObjectMapper ALLOW_UNQUOTED_FIELD_NAMES_MAPPER = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().addModule((Module)new Jdk8Module())).configure(JsonWriteFeature.QUOTE_FIELD_NAMES.mappedFeature(), false)).configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true)).build();
    public static final ObjectMapper IGNORE_UNKNOWN_PROPERTIES_JSON_MAPPER = ((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().addModule((Module)new Jdk8Module())).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)).build();
    public static final ObjectMapper OBJECT_MAPPER_INCLUDE_NOT_NULL = ((JsonMapper.Builder)JsonMapper.builder().serializationInclusion(JsonInclude.Include.NON_NULL)).build();

    public static ObjectMapper getObjectMapperWithJavaTimeModule() {
        return ((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().addModule((Module)new Jdk8Module())).addModule((Module)new JavaTimeModule())).build();
    }

    public static <T> T convertValue(Object fromValue, Class<T> toValueType) {
        try {
            return (T)(fromValue != null ? OBJECT_MAPPER.convertValue(fromValue, toValueType) : null);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("The given object value cannot be converted to " + String.valueOf(toValueType) + ": " + String.valueOf(fromValue), e);
        }
    }

    public static <T> T convertValue(Object fromValue, TypeReference<T> toValueTypeRef) {
        try {
            return (T)(fromValue != null ? OBJECT_MAPPER.convertValue(fromValue, toValueTypeRef) : null);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("The given object value cannot be converted to " + String.valueOf(toValueTypeRef) + ": " + String.valueOf(fromValue), e);
        }
    }

    @Contract(value="null, _ -> null")
    public static <T> T fromString(String string, Class<T> clazz) {
        try {
            return (T)(string != null ? OBJECT_MAPPER.readValue(string, clazz) : null);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("The given string value cannot be transformed to Json object: " + string, e);
        }
    }

    public static <T> T fromString(String string, TypeReference<T> valueTypeRef) {
        try {
            return (T)(string != null ? OBJECT_MAPPER.readValue(string, valueTypeRef) : null);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("The given string value cannot be transformed to Json object: " + string, e);
        }
    }

    public static <T> T fromString(String string, JavaType javaType) {
        try {
            return (T)(string != null ? OBJECT_MAPPER.readValue(string, javaType) : null);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("The given String value cannot be transformed to Json object: " + string, e);
        }
    }

    public static <T> T fromString(String string, Class<T> clazz, boolean ignoreUnknownFields) {
        try {
            return (T)(string != null ? IGNORE_UNKNOWN_PROPERTIES_JSON_MAPPER.readValue(string, clazz) : null);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("The given string value cannot be transformed to Json object: " + string, e);
        }
    }

    public static <T> T fromBytes(byte[] bytes, Class<T> clazz) {
        try {
            return (T)(bytes != null ? OBJECT_MAPPER.readValue(bytes, clazz) : null);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("The given byte[] value cannot be transformed to Json object:" + Arrays.toString(bytes), e);
        }
    }

    public static <T> T fromBytes(byte[] bytes, TypeReference<T> valueTypeRef) {
        try {
            return (T)(bytes != null ? OBJECT_MAPPER.readValue(bytes, valueTypeRef) : null);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("The given string value cannot be transformed to Json object: " + Arrays.toString(bytes), e);
        }
    }

    public static JsonNode fromBytes(byte[] bytes) {
        try {
            return OBJECT_MAPPER.readTree(bytes);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("The given byte[] value cannot be transformed to Json object: " + Arrays.toString(bytes), e);
        }
    }

    public static String toString(Object value) {
        try {
            return value != null ? OBJECT_MAPPER.writeValueAsString(value) : null;
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("The given Json object value cannot be transformed to a String: " + String.valueOf(value), e);
        }
    }

    public static String writeValueAsString(Object value) {
        try {
            return OBJECT_MAPPER.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("The given Json object value: " + String.valueOf(value) + " cannot be transformed to a String", e);
        }
    }

    public static String writeValueAsViewIgnoringNullFields(Object value, Class<Views.Public> serializationView) throws JsonProcessingException {
        return value == null ? "" : OBJECT_MAPPER_INCLUDE_NOT_NULL.writerWithView(serializationView).writeValueAsString(value);
    }

    public static String writeValueAsStringWithDefaultPrettyPrinter(Object value) {
        try {
            return OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("The given Json object value: " + String.valueOf(value) + " cannot be transformed to a String", e);
        }
    }

    public static String toPrettyString(Object o) {
        try {
            return PRETTY_SORTED_JSON_MAPPER.writeValueAsString(o);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String toPlainText(String data) {
        if (data == null) {
            return null;
        }
        if (data.startsWith("\"") && data.endsWith("\"") && data.length() >= 2) {
            String dataBefore = data;
            try {
                data = JacksonUtil.fromString(data, String.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            log.trace("Trimming double quotes. Before trim: [{}], after trim: [{}]", (Object)dataBefore, (Object)data);
        }
        return data;
    }

    public static <T> T treeToValue(JsonNode node, Class<T> clazz) {
        try {
            return (T)OBJECT_MAPPER.treeToValue((TreeNode)node, clazz);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Can't convert value: " + node.toString(), e);
        }
    }

    public static JsonNode toJsonNode(String value) {
        return JacksonUtil.toJsonNode(value, OBJECT_MAPPER);
    }

    public static JsonNode toJsonNode(String value, ObjectMapper mapper) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        try {
            return mapper.readTree(value);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> T readValue(String file, CollectionType clazz) {
        try {
            return (T)OBJECT_MAPPER.readValue(file, (JavaType)clazz);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Can't read file: " + file, e);
        }
    }

    public static <T> T readValue(String object, TypeReference<T> clazz) {
        try {
            return (T)OBJECT_MAPPER.readValue(object, clazz);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Can't read object: " + object, e);
        }
    }

    public static <T> T readValue(File file, TypeReference<T> clazz) {
        try {
            return (T)OBJECT_MAPPER.readValue(file, clazz);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Can't read file: " + String.valueOf(file), e);
        }
    }

    public static <T> T readValue(File file, Class<T> clazz) {
        try {
            return (T)OBJECT_MAPPER.readValue(file, clazz);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Can't read file: " + String.valueOf(file), e);
        }
    }

    public static JsonNode toJsonNode(Path file) {
        try {
            return OBJECT_MAPPER.readTree(Files.readAllBytes(file));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Can't read file: " + String.valueOf(file), e);
        }
    }

    public static JsonNode toJsonNode(File value) {
        try {
            return value != null ? OBJECT_MAPPER.readTree(value) : null;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("The given File object value: " + String.valueOf(value) + " cannot be transformed to a JsonNode", e);
        }
    }

    public static JsonNode toJsonNode(InputStream value) {
        try {
            return value != null ? OBJECT_MAPPER.readTree(value) : null;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("The given InputStream value: " + String.valueOf(value) + " cannot be transformed to a JsonNode", e);
        }
    }

    public static ObjectNode newObjectNode() {
        return JacksonUtil.newObjectNode(OBJECT_MAPPER);
    }

    public static ObjectNode newObjectNode(ObjectMapper mapper) {
        return mapper.createObjectNode();
    }

    public static ArrayNode newArrayNode() {
        return JacksonUtil.newArrayNode(OBJECT_MAPPER);
    }

    public static ArrayNode newArrayNode(ObjectMapper mapper) {
        return mapper.createArrayNode();
    }

    public static <T> T clone(T value) {
        Class<?> valueClass = value.getClass();
        return (T)JacksonUtil.fromString(JacksonUtil.toString(value), valueClass);
    }

    public static <T> JsonNode valueToTree(T value) {
        return OBJECT_MAPPER.valueToTree(value);
    }

    public static <T> byte[] writeValueAsBytes(T value) {
        try {
            return OBJECT_MAPPER.writeValueAsBytes(value);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("The given Json object value cannot be transformed to a String: " + String.valueOf(value), e);
        }
    }

    public static JsonNode getSafely(JsonNode node, String ... path) {
        if (node == null) {
            return null;
        }
        for (String p : path) {
            if (!node.has(p)) {
                return null;
            }
            node = node.get(p);
        }
        return node;
    }

    public static ObjectNode asObject(JsonNode node) {
        return node != null && node.isObject() ? (ObjectNode)node : JacksonUtil.newObjectNode();
    }

    public static void replaceUuidsRecursively(JsonNode node, Set<String> skippedRootFields, Pattern includedFieldsPattern, UnaryOperator<UUID> replacer, boolean root) {
        block6: {
            block5: {
                if (node == null) {
                    return;
                }
                if (!node.isObject()) break block5;
                ObjectNode objectNode = (ObjectNode)node;
                ArrayList fieldNames = Lists.newArrayList((Iterator)objectNode.fieldNames());
                for (String fieldName : fieldNames) {
                    String newText;
                    String text;
                    if (root && skippedRootFields.contains(fieldName)) continue;
                    JsonNode child = objectNode.get(fieldName);
                    if (child.isObject() || child.isArray()) {
                        JacksonUtil.replaceUuidsRecursively(child, skippedRootFields, includedFieldsPattern, replacer, false);
                        continue;
                    }
                    if (!child.isTextual() || includedFieldsPattern != null && !RegexUtils.matches(fieldName, includedFieldsPattern) || (text = child.asText()).equals(newText = RegexUtils.replace(text, RegexUtils.UUID_PATTERN, uuid -> ((UUID)replacer.apply(UUID.fromString(uuid))).toString()))) continue;
                    objectNode.put(fieldName, newText);
                }
                break block6;
            }
            if (!node.isArray()) break block6;
            ArrayNode array = (ArrayNode)node;
            for (int i = 0; i < array.size(); ++i) {
                String newText;
                String text;
                JsonNode arrayElement = array.get(i);
                if (arrayElement.isObject() || arrayElement.isArray()) {
                    JacksonUtil.replaceUuidsRecursively(arrayElement, skippedRootFields, includedFieldsPattern, replacer, false);
                    continue;
                }
                if (!arrayElement.isTextual() || (text = arrayElement.asText()).equals(newText = RegexUtils.replace(text, RegexUtils.UUID_PATTERN, uuid -> ((UUID)replacer.apply(UUID.fromString(uuid))).toString()))) continue;
                array.set(i, newText);
            }
        }
    }

    public static Map<String, String> toFlatMap(JsonNode node) {
        HashMap<String, String> map = new HashMap<String, String>();
        JacksonUtil.toFlatMap(node, "", map);
        return map;
    }

    public static <T> T fromReader(Reader reader, Class<T> clazz) {
        try {
            return (T)(reader != null ? OBJECT_MAPPER.readValue(reader, clazz) : null);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid request payload", e);
        }
    }

    public static <T> void writeValue(Writer writer, T value) {
        try {
            OBJECT_MAPPER.writeValue(writer, value);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("The given writer value: " + String.valueOf(writer) + "cannot be wrote", e);
        }
    }

    public static JavaType constructCollectionType(Class collectionClass, Class<?> elementClass) {
        return OBJECT_MAPPER.getTypeFactory().constructCollectionType(collectionClass, elementClass);
    }

    private static void toFlatMap(JsonNode node, String currentPath, Map<String, String> map) {
        if (node.isObject()) {
            Iterator fields = node.fields();
            Object object = currentPath = ((String)currentPath).isEmpty() ? "" : (String)currentPath + ".";
            while (fields.hasNext()) {
                Map.Entry entry = (Map.Entry)fields.next();
                JacksonUtil.toFlatMap((JsonNode)entry.getValue(), (String)currentPath + (String)entry.getKey(), map);
            }
        } else if (node.isValueNode()) {
            map.put((String)currentPath, node.asText());
        }
    }

    public static void addKvEntry(ObjectNode entityNode, KvEntry kvEntry) {
        JacksonUtil.addKvEntry(entityNode, kvEntry, kvEntry.getKey());
    }

    public static void addKvEntry(ObjectNode entityNode, KvEntry kvEntry, String key) {
        JacksonUtil.addKvEntry(entityNode, kvEntry, key, OBJECT_MAPPER);
    }

    public static void addKvEntry(ObjectNode entityNode, KvEntry kvEntry, String key, ObjectMapper mapper) {
        if (kvEntry.getDataType() == DataType.BOOLEAN) {
            kvEntry.getBooleanValue().ifPresent(value -> entityNode.put(key, value));
        } else if (kvEntry.getDataType() == DataType.DOUBLE) {
            kvEntry.getDoubleValue().ifPresent(value -> entityNode.put(key, value));
        } else if (kvEntry.getDataType() == DataType.LONG) {
            kvEntry.getLongValue().ifPresent(value -> entityNode.put(key, value));
        } else if (kvEntry.getDataType() == DataType.JSON) {
            if (kvEntry.getJsonValue().isPresent()) {
                entityNode.set(key, JacksonUtil.toJsonNode((String)kvEntry.getJsonValue().get(), mapper));
            }
        } else {
            entityNode.put(key, kvEntry.getValueAsString());
        }
    }

    public static Set<String> extractKeys(JsonNode jsonNode) {
        HashSet<String> keyPaths = new HashSet<String>();
        JacksonUtil.extractKeyPathsRecursively("", jsonNode, keyPaths);
        return keyPaths;
    }

    private static void extractKeyPathsRecursively(String currentPath, JsonNode jsonNode, Set<String> keyPaths) {
        if (jsonNode.isObject()) {
            ObjectNode objectNode = (ObjectNode)jsonNode;
            Iterator fieldNames = objectNode.fieldNames();
            while (fieldNames.hasNext()) {
                String fieldName = (String)fieldNames.next();
                String newPath = currentPath.isEmpty() ? fieldName : currentPath + "." + fieldName;
                JacksonUtil.extractKeyPathsRecursively(newPath, objectNode.get(fieldName), keyPaths);
            }
        } else if (jsonNode.isArray()) {
            for (int i = 0; i < jsonNode.size(); ++i) {
                String newPath = currentPath.isEmpty() ? "[" + i + "]" : currentPath + "[" + i + "]";
                JacksonUtil.extractKeyPathsRecursively(newPath, jsonNode.get(i), keyPaths);
            }
        } else {
            keyPaths.add(currentPath);
        }
    }

    public static JsonNode update(JsonNode mainNode, JsonNode updateNode) {
        Iterator fieldNames = updateNode.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldExpression = (String)fieldNames.next();
            String[] fieldPath = fieldExpression.trim().split("\\.");
            ObjectNode node = (ObjectNode)mainNode;
            for (int i = 0; i < fieldPath.length; ++i) {
                boolean last;
                String fieldName = fieldPath[i];
                boolean bl = last = i == fieldPath.length - 1;
                if (last) {
                    node.set(fieldName, updateNode.get(fieldExpression));
                    continue;
                }
                if (!node.has(fieldName)) {
                    node.set(fieldName, (JsonNode)JacksonUtil.newObjectNode());
                }
                node = (ObjectNode)node.get(fieldName);
            }
        }
        return mainNode;
    }

    public static JsonNode merge(JsonNode mainNode, JsonNode updateNode) {
        JacksonUtil.mergeNodes(mainNode, updateNode);
        return mainNode;
    }

    public static void mergeNodes(JsonNode mainNode, JsonNode updateNode) {
        Iterator fieldNames = updateNode.fieldNames();
        while (fieldNames.hasNext()) {
            JsonNode value;
            String fieldName = (String)fieldNames.next();
            JsonNode jsonNode = mainNode.get(fieldName);
            if (jsonNode != null) {
                if (jsonNode.isObject()) {
                    JacksonUtil.mergeNodes(jsonNode, updateNode.get(fieldName));
                    continue;
                }
                if (jsonNode.isArray()) {
                    for (int i = 0; i < jsonNode.size(); ++i) {
                        JacksonUtil.mergeNodes(jsonNode.get(i), updateNode.get(fieldName).get(i));
                    }
                    continue;
                }
                ((ObjectNode)mainNode).set(fieldName, updateNode.get(fieldName));
                continue;
            }
            if (!(mainNode instanceof ObjectNode) || (value = updateNode.get(fieldName)).isNull()) continue;
            ((ObjectNode)mainNode).set(fieldName, value);
        }
    }

    public static JsonNode deleteByKeyPath(JsonNode mainNode, String keyPath) {
        String[] fieldPath = keyPath.trim().split("\\.");
        ObjectNode node = (ObjectNode)mainNode;
        for (int i = 0; i < fieldPath.length; ++i) {
            boolean last;
            String fieldName = fieldPath[i];
            boolean bl = last = i == fieldPath.length - 1;
            if (last) {
                node.remove(fieldName);
                continue;
            }
            if (!node.has(fieldName)) break;
            node = (ObjectNode)node.get(fieldName);
        }
        if (node.isEmpty() && keyPath.contains(".")) {
            JacksonUtil.deleteByKeyPath(mainNode, keyPath.substring(0, keyPath.lastIndexOf(".")));
        }
        return mainNode;
    }

    public static JsonNode getByKeyPath(JsonNode node, String keyPath) {
        return node.at("/" + keyPath.replace('.', '/'));
    }

    public static void replaceAll(JsonNode root, String pathPrefix, BiFunction<String, String, String> processor) {
        LinkedList<JsonNodeProcessingTask> tasks = new LinkedList<JsonNodeProcessingTask>();
        tasks.add(new JsonNodeProcessingTask(pathPrefix, root));
        while (!tasks.isEmpty()) {
            String currentPath;
            JsonNodeProcessingTask task = (JsonNodeProcessingTask)tasks.poll();
            JsonNode node = task.getNode();
            if (node == null) continue;
            String string = currentPath = StringUtils.isBlank((CharSequence)task.getPath()) ? "" : task.getPath() + ".";
            if (node.isObject()) {
                ObjectNode on = (ObjectNode)node;
                Iterator it = on.fieldNames();
                while (it.hasNext()) {
                    String childName = (String)it.next();
                    JsonNode childValue = on.get(childName);
                    if (childValue.isTextual()) {
                        on.put(childName, processor.apply(currentPath + childName, childValue.asText()));
                        continue;
                    }
                    if (!childValue.isObject() && !childValue.isArray()) continue;
                    tasks.add(new JsonNodeProcessingTask(currentPath + childName, childValue));
                }
                continue;
            }
            if (!node.isArray()) continue;
            ArrayNode childArray = (ArrayNode)node;
            for (int i = 0; i < childArray.size(); ++i) {
                JsonNode element = childArray.get(i);
                if (element.isObject()) {
                    tasks.add(new JsonNodeProcessingTask(currentPath + "." + i, element));
                    continue;
                }
                if (!element.isTextual()) continue;
                childArray.set(i, processor.apply(currentPath + "." + i, element.asText()));
            }
        }
    }

    public static void replaceAllByMapping(JsonNode jsonNode, Map<String, String> mapping, Map<String, String> templateParams, BiFunction<String, String, String> processor) {
        JacksonUtil.replaceByMapping(jsonNode, mapping, templateParams, (name, value) -> {
            if (value.isTextual()) {
                return new TextNode((String)processor.apply((String)name, value.asText()));
            }
            if (value.isArray()) {
                ArrayNode array = (ArrayNode)value;
                for (int i = 0; i < array.size(); ++i) {
                    String arrayElementName = name.replace("$index", Integer.toString(i));
                    array.set(i, (String)processor.apply(arrayElementName, array.get(i).asText()));
                }
                return array;
            }
            return value;
        });
    }

    public static void replaceByMapping(JsonNode jsonNode, Map<String, String> mapping, Map<String, String> templateParams, BiFunction<String, JsonNode, JsonNode> processor) {
        for (Map.Entry<String, String> entry : mapping.entrySet()) {
            String expression = entry.getValue();
            LinkedList<JsonPathProcessingTask> tasks = new LinkedList<JsonPathProcessingTask>();
            tasks.add(new JsonPathProcessingTask(entry.getKey().split("\\."), templateParams, jsonNode));
            while (!tasks.isEmpty()) {
                String variableName;
                JsonPathProcessingTask task = (JsonPathProcessingTask)tasks.poll();
                String token = task.currentToken();
                JsonNode node = task.getNode();
                if (node == null) continue;
                if (token.equals("*") || token.startsWith("$")) {
                    String string = variableName = token.startsWith("$") ? token.substring(1) : null;
                    if (node.isArray()) {
                        ArrayNode childArray = (ArrayNode)node;
                        for (JsonNode element : childArray) {
                            tasks.add(task.next(element));
                        }
                        continue;
                    }
                    if (!node.isObject()) continue;
                    ObjectNode on = (ObjectNode)node;
                    Iterator it = on.fields();
                    while (it.hasNext()) {
                        Map.Entry kv = (Map.Entry)it.next();
                        if (variableName != null) {
                            tasks.add(task.next((JsonNode)kv.getValue(), variableName, (String)kv.getKey()));
                            continue;
                        }
                        tasks.add(task.next((JsonNode)kv.getValue()));
                    }
                    continue;
                }
                variableName = null;
                String variableValue = null;
                if (token.contains("[$")) {
                    variableName = StringUtils.substringBetween((String)token, (String)"[$", (String)"]");
                    token = StringUtils.substringBefore((String)token, (String)"[$");
                }
                if (!node.has(token)) continue;
                JsonNode value = node.get(token);
                if (variableName != null && value.has(variableName) && value.get(variableName).isTextual()) {
                    variableValue = value.get(variableName).asText();
                }
                if (task.isLast()) {
                    String name = expression;
                    for (Map.Entry<String, String> replacement : task.getVariables().entrySet()) {
                        name = name.replace("$" + replacement.getKey(), Strings.nullToEmpty((String)replacement.getValue()));
                    }
                    ((ObjectNode)node).set(token, processor.apply(name, value));
                    continue;
                }
                if (StringUtils.isNotEmpty((CharSequence)variableName)) {
                    tasks.add(task.next(value, variableName, variableValue));
                    continue;
                }
                tasks.add(task.next(value));
            }
        }
    }

    public static class JsonNodeProcessingTask {
        private final String path;
        private final JsonNode node;

        public JsonNodeProcessingTask(String path, JsonNode node) {
            this.path = path;
            this.node = node;
        }

        @Generated
        public String getPath() {
            return this.path;
        }

        @Generated
        public JsonNode getNode() {
            return this.node;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JsonNodeProcessingTask)) {
                return false;
            }
            JsonNodeProcessingTask other = (JsonNodeProcessingTask)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$path = this.getPath();
            String other$path = other.getPath();
            if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
                return false;
            }
            JsonNode this$node = this.getNode();
            JsonNode other$node = other.getNode();
            return !(this$node == null ? other$node != null : !this$node.equals(other$node));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof JsonNodeProcessingTask;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            JsonNode $node = this.getNode();
            result = result * 59 + ($node == null ? 43 : $node.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "JacksonUtil.JsonNodeProcessingTask(path=" + this.getPath() + ", node=" + String.valueOf(this.getNode()) + ")";
        }
    }

    public static class JsonPathProcessingTask {
        private final String[] tokens;
        private final Map<String, String> variables;
        private final JsonNode node;

        public JsonPathProcessingTask(String[] tokens, Map<String, String> variables, JsonNode node) {
            this.tokens = tokens;
            this.variables = variables;
            this.node = node;
        }

        public boolean isLast() {
            return this.tokens.length == 1;
        }

        public String currentToken() {
            return this.tokens[0];
        }

        public JsonPathProcessingTask next(JsonNode next) {
            return new JsonPathProcessingTask(Arrays.copyOfRange(this.tokens, 1, this.tokens.length), this.variables, next);
        }

        public JsonPathProcessingTask next(JsonNode next, String key, String value) {
            HashMap<String, String> variables = new HashMap<String, String>(this.variables);
            variables.put(key, value);
            return new JsonPathProcessingTask(Arrays.copyOfRange(this.tokens, 1, this.tokens.length), variables, next);
        }

        public String toString() {
            return "JsonPathProcessingTask{tokens=" + Arrays.toString(this.tokens) + ", variables=" + String.valueOf(this.variables) + ", node=" + this.node.toString().substring(0, 20) + "}";
        }

        @Generated
        public String[] getTokens() {
            return this.tokens;
        }

        @Generated
        public Map<String, String> getVariables() {
            return this.variables;
        }

        @Generated
        public JsonNode getNode() {
            return this.node;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JsonPathProcessingTask)) {
                return false;
            }
            JsonPathProcessingTask other = (JsonPathProcessingTask)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!Arrays.deepEquals(this.getTokens(), other.getTokens())) {
                return false;
            }
            Map<String, String> this$variables = this.getVariables();
            Map<String, String> other$variables = other.getVariables();
            if (this$variables == null ? other$variables != null : !((Object)this$variables).equals(other$variables)) {
                return false;
            }
            JsonNode this$node = this.getNode();
            JsonNode other$node = other.getNode();
            return !(this$node == null ? other$node != null : !this$node.equals(other$node));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof JsonPathProcessingTask;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.deepHashCode(this.getTokens());
            Map<String, String> $variables = this.getVariables();
            result = result * 59 + ($variables == null ? 43 : ((Object)$variables).hashCode());
            JsonNode $node = this.getNode();
            result = result * 59 + ($node == null ? 43 : $node.hashCode());
            return result;
        }
    }
}

