/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.common.util;

import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class DonAsynchron {
    public static <T> void withCallback(ListenableFuture<T> future, Consumer<T> onSuccess, Consumer<Throwable> onFailure) {
        DonAsynchron.withCallback(future, onSuccess, onFailure, null);
    }

    public static <T> void withCallback(ListenableFuture<T> future, final Consumer<T> onSuccess, final Consumer<Throwable> onFailure, Executor executor) {
        FutureCallback callback = new FutureCallback<T>(){

            public void onSuccess(T result) {
                if (onSuccess == null) {
                    return;
                }
                try {
                    onSuccess.accept(result);
                }
                catch (Throwable th) {
                    this.onFailure(th);
                }
            }

            public void onFailure(Throwable t) {
                if (onFailure == null) {
                    return;
                }
                onFailure.accept(t);
            }
        };
        if (executor != null) {
            Futures.addCallback(future, (FutureCallback)callback, (Executor)executor);
        } else {
            Futures.addCallback(future, (FutureCallback)callback, (Executor)MoreExecutors.directExecutor());
        }
    }

    public static <T> ListenableFuture<T> submit(Callable<T> task, Consumer<T> onSuccess, Consumer<Throwable> onFailure, Executor executor) {
        return DonAsynchron.submit(task, onSuccess, onFailure, executor, null);
    }

    public static <T> ListenableFuture<T> submit(Callable<T> task, Consumer<T> onSuccess, Consumer<Throwable> onFailure, Executor executor, Executor callbackExecutor) {
        ListenableFuture future = Futures.submit(task, (Executor)executor);
        DonAsynchron.withCallback(future, onSuccess, onFailure, callbackExecutor);
        return future;
    }

    public static <T> FluentFuture<T> toFluentFuture(CompletableFuture<T> completable) {
        SettableFuture future = SettableFuture.create();
        completable.whenComplete((result, exception) -> {
            if (exception != null) {
                future.setException(exception);
            } else {
                future.set(result);
            }
        });
        return FluentFuture.from((ListenableFuture)future);
    }
}

