/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.common.util;

import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.util.ConcurrentReferenceHashMap;

public class DeduplicationUtil {
    private static final ConcurrentMap<Object, Long> cache = new ConcurrentReferenceHashMap(16, ConcurrentReferenceHashMap.ReferenceType.SOFT);

    public static boolean alreadyProcessed(Object deduplicationKey, long deduplicationDuration) {
        AtomicBoolean alreadyProcessed = new AtomicBoolean(false);
        cache.compute(deduplicationKey, (key, lastProcessedTs) -> {
            long passed;
            if (lastProcessedTs != null && (passed = System.currentTimeMillis() - lastProcessedTs) <= deduplicationDuration) {
                alreadyProcessed.set(true);
                return lastProcessedTs;
            }
            return System.currentTimeMillis();
        });
        return alreadyProcessed.get();
    }
}

