/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.common.util;

import java.util.Set;
import org.thingsboard.server.common.data.HasDebugSettings;
import org.thingsboard.server.common.data.debug.DebugSettings;

public final class DebugModeUtil {
    public static final int DEBUG_MODE_DEFAULT_DURATION_MINUTES = 15;

    private DebugModeUtil() {
    }

    public static int getMaxDebugAllDuration(int tenantProfileDuration, int systemDefaultDuration) {
        if (tenantProfileDuration > 0) {
            return tenantProfileDuration;
        }
        return systemDefaultDuration > 0 ? systemDefaultDuration : 15;
    }

    public static boolean isDebugAllAvailable(HasDebugSettings debugSettingsAware) {
        DebugSettings debugSettings = debugSettingsAware.getDebugSettings();
        return debugSettings != null && debugSettings.getAllEnabledUntil() > System.currentTimeMillis();
    }

    public static boolean isDebugAvailable(HasDebugSettings debugSettingsAware, String nodeConnection) {
        if (DebugModeUtil.isDebugAllAvailable(debugSettingsAware)) {
            return true;
        }
        DebugSettings debugSettings = debugSettingsAware.getDebugSettings();
        return debugSettings != null && debugSettings.isFailuresEnabled() && ("Failure".equals(nodeConnection) || "ERROR".equals(nodeConnection) || "FAILURE".equals(nodeConnection));
    }

    public static boolean isDebugFailuresAvailable(HasDebugSettings debugSettingsAware, Set<String> nodeConnections) {
        if (DebugModeUtil.isDebugAllAvailable(debugSettingsAware)) {
            return true;
        }
        DebugSettings debugSettings = debugSettingsAware.getDebugSettings();
        return debugSettings != null && nodeConnections != null && debugSettings.isFailuresEnabled() && nodeConnections.contains("Failure");
    }

    public static boolean isDebugIntegrationFailuresAvailable(HasDebugSettings debugSettingsAware) {
        if (DebugModeUtil.isDebugAllAvailable(debugSettingsAware)) {
            return true;
        }
        DebugSettings debugSettings = debugSettingsAware.getDebugSettings();
        return debugSettings != null && debugSettings.isFailuresEnabled();
    }

    public static boolean isDebugFailuresAvailable(HasDebugSettings debugSettingsAware) {
        if (DebugModeUtil.isDebugAllAvailable(debugSettingsAware)) {
            return true;
        }
        DebugSettings debugSettings = debugSettingsAware.getDebugSettings();
        return debugSettings != null && debugSettings.isFailuresEnabled();
    }
}

