/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.common.util;

import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Clock;
import java.util.Base64;
import java.util.Iterator;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.HmacSHA256Util;

public final class AzureIotHubUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AzureIotHubUtil.class);
    private static final String BASE_DIR_PATH = System.getProperty("user.dir");
    private static final String APP_DIR = "application";
    private static final String SRC_DIR = "src";
    private static final String MAIN_DIR = "main";
    private static final String DATA_DIR = "data";
    private static final String CERTS_DIR = "certs";
    private static final String AZURE_DIR = "azure";
    private static final String FILE_NAME = "DigiCertGlobalRootG2.crt.pem";
    private static final Path FULL_FILE_PATH = BASE_DIR_PATH.endsWith("bin") ? Paths.get(BASE_DIR_PATH.replaceAll("bin$", ""), "data", "certs", "azure", "DigiCertGlobalRootG2.crt.pem") : (BASE_DIR_PATH.endsWith("conf") ? Paths.get(BASE_DIR_PATH.replaceAll("conf$", ""), "data", "certs", "azure", "DigiCertGlobalRootG2.crt.pem") : Paths.get(BASE_DIR_PATH, "application", "src", "main", "data", "certs", "azure", "DigiCertGlobalRootG2.crt.pem"));
    private static final long SAS_TOKEN_VALID_SECS = 31536000L;
    private static final String SAS_TOKEN_FORMAT = "SharedAccessSignature sr=%s&sig=%s&se=%s";
    private static final String USERNAME_FORMAT = "%s/%s/?api-version=2018-06-30";

    private AzureIotHubUtil() {
    }

    public static String buildUsername(String host, String deviceId) {
        return String.format(USERNAME_FORMAT, host, deviceId);
    }

    public static String buildSasToken(String host, String sasKey, Clock clock) {
        try {
            String targetUri = URLEncoder.encode(host.toLowerCase(), StandardCharsets.UTF_8);
            long expiryTime = AzureIotHubUtil.buildExpiresOn(clock);
            String toSign = targetUri + "\n" + expiryTime;
            byte[] rawHmac = HmacSHA256Util.sign(toSign, Base64.getDecoder().decode(sasKey.getBytes(StandardCharsets.UTF_8)));
            String signature = URLEncoder.encode(Base64.getEncoder().encodeToString(rawHmac), StandardCharsets.UTF_8);
            return String.format(SAS_TOKEN_FORMAT, targetUri, signature, expiryTime);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to build SAS token!", e);
        }
    }

    private static long buildExpiresOn(Clock clock) {
        return clock.instant().plusSeconds(31536000L).getEpochSecond();
    }

    public static String getDefaultCaCert() {
        byte[] fileBytes;
        block12: {
            if (Files.exists(FULL_FILE_PATH, new LinkOption[0])) {
                try {
                    fileBytes = Files.readAllBytes(FULL_FILE_PATH);
                }
                catch (IOException e) {
                    log.error("Failed to load Default CaCert file!!! [{}]", (Object)FULL_FILE_PATH, (Object)e);
                    throw new RuntimeException("Failed to load Default CaCert file!!!");
                }
            }
            Path azureDirectory = FULL_FILE_PATH.getParent();
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(azureDirectory);){
                Iterator<Path> iterator = stream.iterator();
                if (iterator.hasNext()) {
                    Path firstFile = iterator.next();
                    fileBytes = Files.readAllBytes(firstFile);
                    break block12;
                }
                log.error("Default CaCert file not found in the directory [{}]!!!", (Object)azureDirectory);
                throw new RuntimeException("Default CaCert file not found in the directory!!!");
            }
            catch (IOException e) {
                log.error("Failed to load Default CaCert file from the directory [{}]!!!", (Object)azureDirectory, (Object)e);
                throw new RuntimeException("Failed to load Default CaCert file from the directory!!!");
            }
        }
        return new String(fileBytes);
    }
}

