/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.common.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.SystemInfo;
import oshi.hardware.GlobalMemory;
import oshi.hardware.HardwareAbstractionLayer;

public class SystemUtil {
    private static final Logger log = LoggerFactory.getLogger(SystemUtil.class);
    private static final HardwareAbstractionLayer HARDWARE = new SystemInfo().getHardware();

    public static Optional<Integer> getMemoryUsage() {
        try {
            GlobalMemory memory = HARDWARE.getMemory();
            long total = memory.getTotal();
            long available = memory.getAvailable();
            return Optional.of(SystemUtil.toPercent(total - available, total));
        }
        catch (Throwable e) {
            log.debug("Failed to get memory usage!!!", e);
            return Optional.empty();
        }
    }

    public static Optional<Long> getTotalMemory() {
        try {
            return Optional.of(HARDWARE.getMemory().getTotal());
        }
        catch (Throwable e) {
            log.debug("Failed to get total memory!!!", e);
            return Optional.empty();
        }
    }

    public static Optional<Integer> getCpuUsage() {
        try {
            return Optional.of((int)(HARDWARE.getProcessor().getSystemCpuLoad(1000L) * 100.0));
        }
        catch (Throwable e) {
            log.debug("Failed to get cpu usage!!!", e);
            return Optional.empty();
        }
    }

    public static Optional<Integer> getCpuCount() {
        try {
            return Optional.of(HARDWARE.getProcessor().getLogicalProcessorCount());
        }
        catch (Throwable e) {
            log.debug("Failed to get total cpu count!!!", e);
            return Optional.empty();
        }
    }

    public static Optional<Integer> getDiscSpaceUsage() {
        try {
            FileStore store = Files.getFileStore(Paths.get("/", new String[0]));
            long total = store.getTotalSpace();
            long available = store.getUsableSpace();
            return Optional.of(SystemUtil.toPercent(total - available, total));
        }
        catch (Throwable e) {
            log.debug("Failed to get free disc space!!!", e);
            return Optional.empty();
        }
    }

    public static Optional<Long> getTotalDiscSpace() {
        try {
            FileStore store = Files.getFileStore(Paths.get("/", new String[0]));
            return Optional.of(store.getTotalSpace());
        }
        catch (Throwable e) {
            log.debug("Failed to get total disc space!!!", e);
            return Optional.empty();
        }
    }

    private static int toPercent(long used, long total) {
        BigDecimal u = new BigDecimal(used);
        BigDecimal t = new BigDecimal(total);
        BigDecimal i = new BigDecimal(100);
        return u.multiply(i).divide(t, RoundingMode.HALF_UP).intValue();
    }
}

