/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.common.util;

import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.pkcs.PKCSException;
import org.bouncycastle.pkcs.jcajce.JcePKCSPBEInputDecryptorProviderBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.StringUtils;

public class SslUtil {
    private static final Logger log = LoggerFactory.getLogger(SslUtil.class);
    public static final char[] EMPTY_PASS = new char[0];
    public static final BouncyCastleProvider DEFAULT_PROVIDER = new BouncyCastleProvider();

    private SslUtil() {
    }

    public static List<X509Certificate> readCertFile(String fileContent) {
        return SslUtil.readCertFile(new StringReader(fileContent));
    }

    public static List<X509Certificate> readCertFileByPath(String filePath) {
        return SslUtil.readCertFile(new FileReader(filePath));
    }

    private static List<X509Certificate> readCertFile(Reader reader) throws IOException, CertificateException {
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
        JcaX509CertificateConverter certConverter = new JcaX509CertificateConverter();
        try (PEMParser pemParser = new PEMParser(reader);){
            Object object;
            while ((object = pemParser.readObject()) != null) {
                if (!(object instanceof X509CertificateHolder)) continue;
                X509Certificate x509Cert = certConverter.getCertificate((X509CertificateHolder)object);
                certificates.add(x509Cert);
            }
        }
        return certificates;
    }

    public static PrivateKey readPrivateKey(String fileContent, String passStr) {
        if (StringUtils.isNotEmpty((String)fileContent)) {
            StringReader reader = new StringReader(fileContent);
            return SslUtil.readPrivateKey(reader, passStr);
        }
        return null;
    }

    public static PrivateKey readPrivateKeyByFilePath(String filePath, String passStr) {
        if (StringUtils.isNotEmpty((String)filePath)) {
            FileReader fileReader = new FileReader(filePath);
            return SslUtil.readPrivateKey(fileReader, passStr);
        }
        return null;
    }

    private static PrivateKey readPrivateKey(Reader reader, String passStr) throws IOException, PKCSException {
        char[] password = SslUtil.getPassword(passStr);
        PrivateKey privateKey = null;
        JcaPEMKeyConverter keyConverter = new JcaPEMKeyConverter();
        try (PEMParser pemParser = new PEMParser(reader);){
            Object object;
            while ((object = pemParser.readObject()) != null) {
                if (object instanceof PEMEncryptedKeyPair) {
                    PEMDecryptorProvider decProv = new JcePEMDecryptorProviderBuilder().build(password);
                    privateKey = keyConverter.getKeyPair(((PEMEncryptedKeyPair)object).decryptKeyPair(decProv)).getPrivate();
                    break;
                }
                if (object instanceof PKCS8EncryptedPrivateKeyInfo) {
                    InputDecryptorProvider decProv = new JcePKCSPBEInputDecryptorProviderBuilder().setProvider((Provider)DEFAULT_PROVIDER).build(password);
                    privateKey = keyConverter.getPrivateKey(((PKCS8EncryptedPrivateKeyInfo)object).decryptPrivateKeyInfo(decProv));
                    break;
                }
                if (object instanceof PEMKeyPair) {
                    privateKey = keyConverter.getKeyPair((PEMKeyPair)object).getPrivate();
                    break;
                }
                if (!(object instanceof PrivateKeyInfo)) continue;
                privateKey = keyConverter.getPrivateKey((PrivateKeyInfo)object);
            }
        }
        return privateKey;
    }

    public static char[] getPassword(String passStr) {
        return StringUtils.isEmpty((String)passStr) ? EMPTY_PASS : passStr.toCharArray();
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)DEFAULT_PROVIDER);
        }
    }
}

