/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.common.util;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;

public class LinkedHashMapRemoveEldest<K, V>
extends LinkedHashMap<K, V> {
    final int maxEntries;
    final BiConsumer<K, V> removalConsumer;

    public LinkedHashMapRemoveEldest(int maxEntries, BiConsumer<K, V> removalConsumer) {
        this.maxEntries = maxEntries;
        this.removalConsumer = removalConsumer;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        if (this.size() <= this.maxEntries) {
            return false;
        }
        this.removalConsumer.accept(eldest.getKey(), eldest.getValue());
        return true;
    }

    public int getMaxEntries() {
        return this.maxEntries;
    }

    public BiConsumer<K, V> getRemovalConsumer() {
        return this.removalConsumer;
    }

    @Override
    public String toString() {
        return "LinkedHashMapRemoveEldest(super=" + super.toString() + ", maxEntries=" + this.getMaxEntries() + ", removalConsumer=" + String.valueOf(this.getRemovalConsumer()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LinkedHashMapRemoveEldest)) {
            return false;
        }
        LinkedHashMapRemoveEldest other = (LinkedHashMapRemoveEldest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getMaxEntries() != other.getMaxEntries()) {
            return false;
        }
        BiConsumer<K, V> this$removalConsumer = this.getRemovalConsumer();
        BiConsumer<K, V> other$removalConsumer = other.getRemovalConsumer();
        return !(this$removalConsumer == null ? other$removalConsumer != null : !this$removalConsumer.equals(other$removalConsumer));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LinkedHashMapRemoveEldest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getMaxEntries();
        BiConsumer<K, V> $removalConsumer = this.getRemovalConsumer();
        result = result * 59 + ($removalConsumer == null ? 43 : $removalConsumer.hashCode());
        return result;
    }
}

