/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.common.util;

import org.thingsboard.server.common.data.kv.KvEntry;

public class KvUtil {
    public static String getStringValue(KvEntry entry) {
        switch (entry.getDataType()) {
            case LONG: {
                return entry.getLongValue().map(String::valueOf).orElse(null);
            }
            case DOUBLE: {
                return entry.getDoubleValue().map(String::valueOf).orElse(null);
            }
            case BOOLEAN: {
                return entry.getBooleanValue().map(String::valueOf).orElse(null);
            }
            case STRING: {
                return entry.getStrValue().orElse("");
            }
            case JSON: {
                return entry.getJsonValue().orElse("");
            }
        }
        return null;
    }

    public static Double getDoubleValue(KvEntry entry) {
        switch (entry.getDataType()) {
            case LONG: {
                return entry.getLongValue().map(Long::doubleValue).orElse(null);
            }
            case DOUBLE: {
                return entry.getDoubleValue().orElse(null);
            }
            case BOOLEAN: {
                return entry.getBooleanValue().map(e -> e != false ? 1.0 : 0.0).orElse(null);
            }
            case STRING: {
                try {
                    return Double.parseDouble(entry.getStrValue().orElse(""));
                }
                catch (RuntimeException e2) {
                    return null;
                }
            }
            case JSON: {
                try {
                    return Double.parseDouble(entry.getJsonValue().orElse(""));
                }
                catch (RuntimeException e3) {
                    return null;
                }
            }
        }
        return null;
    }

    public static Boolean getBoolValue(KvEntry entry) {
        switch (entry.getDataType()) {
            case LONG: {
                return entry.getLongValue().map(e -> e != 0L).orElse(null);
            }
            case DOUBLE: {
                return entry.getDoubleValue().map(e -> e != 0.0).orElse(null);
            }
            case BOOLEAN: {
                return entry.getBooleanValue().orElse(null);
            }
            case STRING: {
                try {
                    return Boolean.parseBoolean(entry.getStrValue().orElse(""));
                }
                catch (RuntimeException e2) {
                    return null;
                }
            }
            case JSON: {
                try {
                    return Boolean.parseBoolean(entry.getJsonValue().orElse(""));
                }
                catch (RuntimeException e3) {
                    return null;
                }
            }
        }
        return null;
    }
}

