/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.common.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.json.JsonWriteFeature;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.RegexUtils;
import org.thingsboard.server.common.data.kv.DataType;
import org.thingsboard.server.common.data.kv.KvEntry;

public class JacksonUtil {
    private static final Logger log = LoggerFactory.getLogger(JacksonUtil.class);
    public static final ObjectMapper OBJECT_MAPPER = ((JsonMapper.Builder)JsonMapper.builder().addModule((Module)new Jdk8Module())).build();
    public static final ObjectMapper PRETTY_SORTED_JSON_MAPPER = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().addModule((Module)new Jdk8Module())).enable(new SerializationFeature[]{SerializationFeature.INDENT_OUTPUT})).configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true)).configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true)).build();
    public static ObjectMapper ALLOW_UNQUOTED_FIELD_NAMES_MAPPER = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().addModule((Module)new Jdk8Module())).configure(JsonWriteFeature.QUOTE_FIELD_NAMES.mappedFeature(), false)).configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true)).build();
    public static final ObjectMapper IGNORE_UNKNOWN_PROPERTIES_JSON_MAPPER = ((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().addModule((Module)new Jdk8Module())).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)).build();

    public static ObjectMapper getObjectMapperWithJavaTimeModule() {
        return ((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().addModule((Module)new Jdk8Module())).addModule((Module)new JavaTimeModule())).build();
    }

    public static <T> T convertValue(Object fromValue, Class<T> toValueType) {
        try {
            return (T)(fromValue != null ? OBJECT_MAPPER.convertValue(fromValue, toValueType) : null);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("The given object value cannot be converted to " + toValueType + ": " + fromValue, e);
        }
    }

    public static <T> T convertValue(Object fromValue, TypeReference<T> toValueTypeRef) {
        try {
            return (T)(fromValue != null ? OBJECT_MAPPER.convertValue(fromValue, toValueTypeRef) : null);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("The given object value cannot be converted to " + toValueTypeRef + ": " + fromValue, e);
        }
    }

    public static <T> T fromString(String string, Class<T> clazz) {
        try {
            return (T)(string != null ? OBJECT_MAPPER.readValue(string, clazz) : null);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("The given string value cannot be transformed to Json object: " + string, e);
        }
    }

    public static <T> T fromString(String string, TypeReference<T> valueTypeRef) {
        try {
            return (T)(string != null ? OBJECT_MAPPER.readValue(string, valueTypeRef) : null);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("The given string value cannot be transformed to Json object: " + string, e);
        }
    }

    public static <T> T fromString(String string, JavaType javaType) {
        try {
            return (T)(string != null ? OBJECT_MAPPER.readValue(string, javaType) : null);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("The given String value cannot be transformed to Json object: " + string, e);
        }
    }

    public static <T> T fromString(String string, Class<T> clazz, boolean ignoreUnknownFields) {
        try {
            return (T)(string != null ? IGNORE_UNKNOWN_PROPERTIES_JSON_MAPPER.readValue(string, clazz) : null);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("The given string value cannot be transformed to Json object: " + string, e);
        }
    }

    public static <T> T fromBytes(byte[] bytes, Class<T> clazz) {
        try {
            return (T)(bytes != null ? OBJECT_MAPPER.readValue(bytes, clazz) : null);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("The given byte[] value cannot be transformed to Json object:" + Arrays.toString(bytes), e);
        }
    }

    public static <T> T fromBytes(byte[] bytes, TypeReference<T> valueTypeRef) {
        try {
            return (T)(bytes != null ? OBJECT_MAPPER.readValue(bytes, valueTypeRef) : null);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("The given string value cannot be transformed to Json object: " + Arrays.toString(bytes), e);
        }
    }

    public static JsonNode fromBytes(byte[] bytes) {
        try {
            return OBJECT_MAPPER.readTree(bytes);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("The given byte[] value cannot be transformed to Json object: " + Arrays.toString(bytes), e);
        }
    }

    public static String toString(Object value) {
        try {
            return value != null ? OBJECT_MAPPER.writeValueAsString(value) : null;
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("The given Json object value cannot be transformed to a String: " + value, e);
        }
    }

    public static String writeValueAsString(Object value) {
        try {
            return OBJECT_MAPPER.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("The given Json object value: " + value + " cannot be transformed to a String", e);
        }
    }

    public static String toPrettyString(Object o) {
        try {
            return PRETTY_SORTED_JSON_MAPPER.writeValueAsString(o);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String toPlainText(String data) {
        if (data == null) {
            return null;
        }
        if (data.startsWith("\"") && data.endsWith("\"") && data.length() >= 2) {
            String dataBefore = data;
            try {
                data = JacksonUtil.fromString(data, String.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            log.trace("Trimming double quotes. Before trim: [{}], after trim: [{}]", (Object)dataBefore, (Object)data);
        }
        return data;
    }

    public static <T> T treeToValue(JsonNode node, Class<T> clazz) {
        try {
            return (T)OBJECT_MAPPER.treeToValue((TreeNode)node, clazz);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Can't convert value: " + node.toString(), e);
        }
    }

    public static JsonNode toJsonNode(String value) {
        return JacksonUtil.toJsonNode(value, OBJECT_MAPPER);
    }

    public static JsonNode toJsonNode(String value, ObjectMapper mapper) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        try {
            return mapper.readTree(value);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> T readValue(String file, CollectionType clazz) {
        try {
            return (T)OBJECT_MAPPER.readValue(file, (JavaType)clazz);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Can't read file: " + file, e);
        }
    }

    public static <T> T readValue(File file, TypeReference<T> clazz) {
        try {
            return (T)OBJECT_MAPPER.readValue(file, clazz);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Can't read file: " + file, e);
        }
    }

    public static <T> T readValue(File file, Class<T> clazz) {
        try {
            return (T)OBJECT_MAPPER.readValue(file, clazz);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Can't read file: " + file, e);
        }
    }

    public static JsonNode toJsonNode(Path file) {
        try {
            return OBJECT_MAPPER.readTree(Files.readAllBytes(file));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Can't read file: " + file, e);
        }
    }

    public static JsonNode toJsonNode(File value) {
        try {
            return value != null ? OBJECT_MAPPER.readTree(value) : null;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("The given File object value: " + value + " cannot be transformed to a JsonNode", e);
        }
    }

    public static JsonNode toJsonNode(InputStream value) {
        try {
            return value != null ? OBJECT_MAPPER.readTree(value) : null;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("The given InputStream value: " + value + " cannot be transformed to a JsonNode", e);
        }
    }

    public static ObjectNode newObjectNode() {
        return JacksonUtil.newObjectNode(OBJECT_MAPPER);
    }

    public static ObjectNode newObjectNode(ObjectMapper mapper) {
        return mapper.createObjectNode();
    }

    public static ArrayNode newArrayNode() {
        return JacksonUtil.newArrayNode(OBJECT_MAPPER);
    }

    public static ArrayNode newArrayNode(ObjectMapper mapper) {
        return mapper.createArrayNode();
    }

    public static <T> T clone(T value) {
        Class<?> valueClass = value.getClass();
        return (T)JacksonUtil.fromString(JacksonUtil.toString(value), valueClass);
    }

    public static <T> JsonNode valueToTree(T value) {
        return OBJECT_MAPPER.valueToTree(value);
    }

    public static <T> byte[] writeValueAsBytes(T value) {
        try {
            return OBJECT_MAPPER.writeValueAsBytes(value);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("The given Json object value cannot be transformed to a String: " + value, e);
        }
    }

    public static JsonNode getSafely(JsonNode node, String ... path) {
        if (node == null) {
            return null;
        }
        for (String p : path) {
            if (!node.has(p)) {
                return null;
            }
            node = node.get(p);
        }
        return node;
    }

    public static ObjectNode asObject(JsonNode node) {
        return node != null && node.isObject() ? (ObjectNode)node : JacksonUtil.newObjectNode();
    }

    public static void replaceUuidsRecursively(JsonNode node, Set<String> skippedRootFields, Pattern includedFieldsPattern, UnaryOperator<UUID> replacer, boolean root) {
        block6: {
            block5: {
                if (node == null) {
                    return;
                }
                if (!node.isObject()) break block5;
                ObjectNode objectNode = (ObjectNode)node;
                ArrayList fieldNames = Lists.newArrayList((Iterator)objectNode.fieldNames());
                for (String fieldName : fieldNames) {
                    String newText;
                    String text;
                    if (root && skippedRootFields.contains(fieldName)) continue;
                    JsonNode child = objectNode.get(fieldName);
                    if (child.isObject() || child.isArray()) {
                        JacksonUtil.replaceUuidsRecursively(child, skippedRootFields, includedFieldsPattern, replacer, false);
                        continue;
                    }
                    if (!child.isTextual() || includedFieldsPattern != null && !RegexUtils.matches(fieldName, includedFieldsPattern) || (text = child.asText()).equals(newText = RegexUtils.replace(text, RegexUtils.UUID_PATTERN, uuid -> ((UUID)replacer.apply(UUID.fromString(uuid))).toString()))) continue;
                    objectNode.put(fieldName, newText);
                }
                break block6;
            }
            if (!node.isArray()) break block6;
            ArrayNode array = (ArrayNode)node;
            for (int i = 0; i < array.size(); ++i) {
                String newText;
                String text;
                JsonNode arrayElement = array.get(i);
                if (arrayElement.isObject() || arrayElement.isArray()) {
                    JacksonUtil.replaceUuidsRecursively(arrayElement, skippedRootFields, includedFieldsPattern, replacer, false);
                    continue;
                }
                if (!arrayElement.isTextual() || (text = arrayElement.asText()).equals(newText = RegexUtils.replace(text, RegexUtils.UUID_PATTERN, uuid -> ((UUID)replacer.apply(UUID.fromString(uuid))).toString()))) continue;
                array.set(i, newText);
            }
        }
    }

    public static Map<String, String> toFlatMap(JsonNode node) {
        HashMap<String, String> map = new HashMap<String, String>();
        JacksonUtil.toFlatMap(node, "", map);
        return map;
    }

    public static <T> T fromReader(Reader reader, Class<T> clazz) {
        try {
            return (T)(reader != null ? OBJECT_MAPPER.readValue(reader, clazz) : null);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid request payload", e);
        }
    }

    public static <T> void writeValue(Writer writer, T value) {
        try {
            OBJECT_MAPPER.writeValue(writer, value);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("The given writer value: " + writer + "cannot be wrote", e);
        }
    }

    public static JavaType constructCollectionType(Class collectionClass, Class<?> elementClass) {
        return OBJECT_MAPPER.getTypeFactory().constructCollectionType(collectionClass, elementClass);
    }

    private static void toFlatMap(JsonNode node, String currentPath, Map<String, String> map) {
        if (node.isObject()) {
            Iterator fields = node.fields();
            Object object = currentPath = ((String)currentPath).isEmpty() ? "" : (String)currentPath + ".";
            while (fields.hasNext()) {
                Map.Entry entry = (Map.Entry)fields.next();
                JacksonUtil.toFlatMap((JsonNode)entry.getValue(), (String)currentPath + (String)entry.getKey(), map);
            }
        } else if (node.isValueNode()) {
            map.put((String)currentPath, node.asText());
        }
    }

    public static void addKvEntry(ObjectNode entityNode, KvEntry kvEntry) {
        JacksonUtil.addKvEntry(entityNode, kvEntry, kvEntry.getKey());
    }

    public static void addKvEntry(ObjectNode entityNode, KvEntry kvEntry, String key) {
        JacksonUtil.addKvEntry(entityNode, kvEntry, key, OBJECT_MAPPER);
    }

    public static void addKvEntry(ObjectNode entityNode, KvEntry kvEntry, String key, ObjectMapper mapper) {
        if (kvEntry.getDataType() == DataType.BOOLEAN) {
            kvEntry.getBooleanValue().ifPresent(value -> entityNode.put(key, value));
        } else if (kvEntry.getDataType() == DataType.DOUBLE) {
            kvEntry.getDoubleValue().ifPresent(value -> entityNode.put(key, value));
        } else if (kvEntry.getDataType() == DataType.LONG) {
            kvEntry.getLongValue().ifPresent(value -> entityNode.put(key, value));
        } else if (kvEntry.getDataType() == DataType.JSON) {
            if (kvEntry.getJsonValue().isPresent()) {
                entityNode.set(key, JacksonUtil.toJsonNode((String)kvEntry.getJsonValue().get(), mapper));
            }
        } else {
            entityNode.put(key, kvEntry.getValueAsString());
        }
    }
}

