/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.common.util;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class ThingsBoardThreadFactory
implements ThreadFactory {
    private static final String THREAD_TOPIC_SEPARATOR = " | ";
    private static final AtomicInteger poolNumber = new AtomicInteger(1);
    private final ThreadGroup group;
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final String namePrefix;

    public static ThingsBoardThreadFactory forName(String name) {
        return new ThingsBoardThreadFactory(name);
    }

    private ThingsBoardThreadFactory(String name) {
        SecurityManager s = System.getSecurityManager();
        this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.namePrefix = name + "-" + poolNumber.getAndIncrement() + "-thread-";
    }

    public static void updateCurrentThreadName(String threadSuffix) {
        Object name = Thread.currentThread().getName();
        int spliteratorIndex = ((String)name).indexOf(THREAD_TOPIC_SEPARATOR);
        if (spliteratorIndex > 0) {
            name = ((String)name).substring(0, spliteratorIndex);
        }
        name = (String)name + THREAD_TOPIC_SEPARATOR + threadSuffix;
        Thread.currentThread().setName((String)name);
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
        if (t.isDaemon()) {
            t.setDaemon(false);
        }
        if (t.getPriority() != 5) {
            t.setPriority(5);
        }
        return t;
    }
}

