/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.common.util;

import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.atomic.AtomicLong;
import lombok.NonNull;

public class ThingsBoardForkJoinWorkerThreadFactory
implements ForkJoinPool.ForkJoinWorkerThreadFactory {
    private final String namePrefix;
    private final AtomicLong threadNumber = new AtomicLong(1L);

    public ThingsBoardForkJoinWorkerThreadFactory(@NonNull String namePrefix) {
        if (namePrefix == null) {
            throw new NullPointerException("namePrefix is marked non-null but is null");
        }
        this.namePrefix = namePrefix;
    }

    @Override
    public final ForkJoinWorkerThread newThread(ForkJoinPool pool) {
        ForkJoinWorkerThread thread = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
        thread.setContextClassLoader(this.getClass().getClassLoader());
        thread.setName(this.namePrefix + "-" + thread.getPoolIndex() + "-" + this.threadNumber.getAndIncrement());
        return thread;
    }

    public String toString() {
        return "ThingsBoardForkJoinWorkerThreadFactory(namePrefix=" + this.namePrefix + ", threadNumber=" + this.threadNumber + ")";
    }
}

