/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.common.util;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.thingsboard.common.util.ListeningExecutor;
import org.thingsboard.common.util.ThingsBoardExecutors;

public abstract class AbstractListeningExecutor
implements ListeningExecutor {
    private ListeningExecutorService service;

    @PostConstruct
    public void init() {
        this.service = MoreExecutors.listeningDecorator((ExecutorService)ThingsBoardExecutors.newWorkStealingPool(this.getThreadPollSize(), this.getClass()));
    }

    @PreDestroy
    public void destroy() {
        if (this.service != null) {
            this.service.shutdown();
        }
    }

    @Override
    public <T> ListenableFuture<T> executeAsync(Callable<T> task) {
        return this.service.submit(task);
    }

    @Override
    public ListenableFuture<?> executeAsync(Runnable task) {
        return this.service.submit(task);
    }

    @Override
    public void execute(Runnable command) {
        this.service.execute(command);
    }

    public ListeningExecutorService executor() {
        return this.service;
    }

    protected abstract int getThreadPollSize();
}

