/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.transport.util;

import java.io.ByteArrayInputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Base64;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.msg.EncryptionUtil;

public class SslUtil {
    private static final Logger log = LoggerFactory.getLogger(SslUtil.class);

    private SslUtil() {
    }

    public static String getCertificateString(Certificate cert) throws CertificateEncodingException {
        return EncryptionUtil.certTrimNewLines((String)Base64.getEncoder().encodeToString(cert.getEncoded()));
    }

    public static String getCertificateChainString(Certificate[] chain) throws CertificateEncodingException {
        String begin = "-----BEGIN CERTIFICATE-----";
        String end = "-----END CERTIFICATE-----";
        StringBuilder stringBuilder = new StringBuilder();
        for (Certificate cert : chain) {
            stringBuilder.append(begin).append(EncryptionUtil.certTrimNewLines((String)Base64.getEncoder().encodeToString(cert.getEncoded()))).append(end).append("\n");
        }
        return stringBuilder.toString();
    }

    public static X509Certificate readCertFile(String fileContent) {
        X509Certificate certificate;
        block7: {
            certificate = null;
            try {
                if (fileContent == null || fileContent.trim().isEmpty()) break block7;
                fileContent = fileContent.replace("-----BEGIN CERTIFICATE-----", "").replace("-----END CERTIFICATE-----", "").replaceAll("\\s", "");
                byte[] decoded = Base64.getDecoder().decode(fileContent);
                CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
                try (ByteArrayInputStream inStream = new ByteArrayInputStream(decoded);){
                    certificate = (X509Certificate)certFactory.generateCertificate(inStream);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return certificate;
    }

    public static String parseCommonName(X509Certificate certificate) {
        X500Name x500name;
        try {
            x500name = new JcaX509CertificateHolder(certificate).getSubject();
        }
        catch (CertificateEncodingException e) {
            log.warn("Cannot parse CN from device certificate");
            throw new RuntimeException(e);
        }
        RDN cn = x500name.getRDNs(BCStyle.CN)[0];
        return IETFUtils.valueToString((ASN1Encodable)cn.getFirst().getValue());
    }
}

