/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.transport.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.util.List;
import java.util.Map;
import org.thingsboard.server.gen.transport.TransportProtos;

public class JsonUtils {
    public static JsonObject getJsonObject(List<TransportProtos.KeyValueProto> tsKv) {
        JsonObject json = new JsonObject();
        for (TransportProtos.KeyValueProto kv : tsKv) {
            switch (kv.getType()) {
                case BOOLEAN_V: {
                    json.addProperty(kv.getKey(), Boolean.valueOf(kv.getBoolV()));
                    break;
                }
                case LONG_V: {
                    json.addProperty(kv.getKey(), (Number)kv.getLongV());
                    break;
                }
                case DOUBLE_V: {
                    json.addProperty(kv.getKey(), (Number)kv.getDoubleV());
                    break;
                }
                case STRING_V: {
                    json.addProperty(kv.getKey(), kv.getStringV());
                    break;
                }
                case JSON_V: {
                    json.add(kv.getKey(), JsonParser.parseString((String)kv.getJsonV()));
                }
            }
        }
        return json;
    }

    public static JsonElement parse(Object value) {
        if (value instanceof Integer) {
            return new JsonPrimitive((Number)((Integer)value));
        }
        if (value instanceof Long) {
            return new JsonPrimitive((Number)((Long)value));
        }
        if (value instanceof String) {
            return JsonParser.parseString((String)((String)value));
        }
        if (value instanceof Boolean) {
            return new JsonPrimitive((Boolean)value);
        }
        if (value instanceof Double) {
            return new JsonPrimitive((Number)((Double)value));
        }
        if (value instanceof Float) {
            return new JsonPrimitive((Number)((Float)value));
        }
        throw new IllegalArgumentException("Unsupported type: " + value.getClass().getSimpleName());
    }

    public static JsonObject convertToJsonObject(Map<String, ?> map) {
        JsonObject jsonObject = new JsonObject();
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            jsonObject.add(entry.getKey(), JsonUtils.parse(entry.getValue()));
        }
        return jsonObject;
    }
}

