/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.transport.service;

import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.thingsboard.server.common.transport.TransportService;
import org.thingsboard.server.common.transport.TransportServiceCallback;
import org.thingsboard.server.common.transport.activity.AbstractActivityManager;
import org.thingsboard.server.common.transport.activity.ActivityReportCallback;
import org.thingsboard.server.common.transport.activity.ActivityState;
import org.thingsboard.server.common.transport.activity.strategy.ActivityStrategy;
import org.thingsboard.server.common.transport.activity.strategy.ActivityStrategyType;
import org.thingsboard.server.common.transport.service.SessionMetaData;
import org.thingsboard.server.gen.transport.TransportProtos;

public abstract class TransportActivityManager
extends AbstractActivityManager<UUID, TransportProtos.SessionInfoProto>
implements TransportService {
    private static final Logger log = LoggerFactory.getLogger(TransportActivityManager.class);
    public static final String SESSION_EXPIRED_MESSAGE = "Session has expired due to last activity time!";
    public static final TransportProtos.SessionEventMsg SESSION_EVENT_MSG_CLOSED = TransportProtos.SessionEventMsg.newBuilder().setSessionType(TransportProtos.SessionType.ASYNC).setEvent(TransportProtos.SessionEvent.CLOSED).build();
    public static final TransportProtos.SessionCloseNotificationProto SESSION_EXPIRED_NOTIFICATION_PROTO = TransportProtos.SessionCloseNotificationProto.newBuilder().setMessage("Session has expired due to last activity time!").build();
    public final ConcurrentMap<UUID, SessionMetaData> sessions = new ConcurrentHashMap<UUID, SessionMetaData>();
    @Value(value="${transport.sessions.report_timeout}")
    protected long sessionReportTimeout;
    @Value(value="${transport.sessions.inactivity_timeout}")
    protected long sessionInactivityTimeout;
    @Value(value="${transport.activity.reporting_strategy:LAST}")
    private ActivityStrategyType reportingStrategyType;

    @Override
    protected long getReportingPeriodMillis() {
        return this.sessionReportTimeout;
    }

    @Override
    protected ActivityStrategy getStrategy() {
        return this.reportingStrategyType.toStrategy();
    }

    @Override
    protected ActivityState<TransportProtos.SessionInfoProto> updateState(UUID sessionId, ActivityState<TransportProtos.SessionInfoProto> state) {
        SessionMetaData session = (SessionMetaData)this.sessions.get(sessionId);
        if (session == null) {
            return null;
        }
        state.setMetadata(session.getSessionInfo());
        TransportProtos.SessionInfoProto sessionInfo = state.getMetadata();
        if (sessionInfo.getGwSessionIdMSB() == 0L || sessionInfo.getGwSessionIdLSB() == 0L) {
            return state;
        }
        UUID gwSessionId = new UUID(sessionInfo.getGwSessionIdMSB(), sessionInfo.getGwSessionIdLSB());
        SessionMetaData gwSession = (SessionMetaData)this.sessions.get(gwSessionId);
        if (gwSession == null || !gwSession.isOverwriteActivityTime()) {
            return state;
        }
        long lastRecordedTime = state.getLastRecordedTime();
        long gwLastRecordedTime = this.getLastRecordedTime(gwSessionId);
        log.debug("Session with id: [{}] has gateway session with id: [{}] with overwrite activity time enabled. Updating last activity time. Session last recorded time: [{}], gateway session last recorded time: [{}].", new Object[]{sessionId, gwSessionId, lastRecordedTime, gwLastRecordedTime});
        state.setLastRecordedTime(Math.max(lastRecordedTime, gwLastRecordedTime));
        return state;
    }

    @Override
    protected boolean hasExpired(long lastRecordedTime) {
        return this.getCurrentTimeMillis() - this.sessionInactivityTimeout > lastRecordedTime;
    }

    @Override
    protected void onStateExpiry(UUID sessionId, TransportProtos.SessionInfoProto sessionInfo) {
        log.debug("Session with id: [{}] has expired due to last activity time.", (Object)sessionId);
        SessionMetaData expiredSession = (SessionMetaData)this.sessions.remove(sessionId);
        if (expiredSession != null) {
            this.deregisterSession(sessionInfo);
            this.process(sessionInfo, SESSION_EVENT_MSG_CLOSED, null);
            expiredSession.getListener().onRemoteSessionCloseCommand(sessionId, SESSION_EXPIRED_NOTIFICATION_PROTO);
        }
    }

    @Override
    protected void reportActivity(final UUID sessionId, TransportProtos.SessionInfoProto currentSessionInfo, final long timeToReport, final ActivityReportCallback<UUID> callback) {
        log.debug("Reporting activity state for session with id: [{}]. Time to report: [{}].", (Object)sessionId, (Object)timeToReport);
        SessionMetaData session = (SessionMetaData)this.sessions.get(sessionId);
        TransportProtos.SubscriptionInfoProto subscriptionInfo = TransportProtos.SubscriptionInfoProto.newBuilder().setAttributeSubscription(session != null && session.isSubscribedToAttributes()).setRpcSubscription(session != null && session.isSubscribedToRPC()).setLastActivityTime(timeToReport).build();
        TransportProtos.SessionInfoProto sessionInfo = session != null ? session.getSessionInfo() : currentSessionInfo;
        this.process(sessionInfo, subscriptionInfo, new TransportServiceCallback<Void>(){

            @Override
            public void onSuccess(Void msgAcknowledged) {
                callback.onSuccess(sessionId, timeToReport);
            }

            @Override
            public void onError(Throwable e) {
                callback.onFailure(sessionId, e);
            }
        });
    }

    protected long getCurrentTimeMillis() {
        return System.currentTimeMillis();
    }
}

