/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.transport.service;

import java.util.concurrent.ScheduledFuture;
import org.thingsboard.server.common.transport.SessionMsgListener;
import org.thingsboard.server.gen.transport.TransportProtos;

public class SessionMetaData {
    private volatile TransportProtos.SessionInfoProto sessionInfo;
    private final TransportProtos.SessionType sessionType;
    private final SessionMsgListener listener;
    private volatile ScheduledFuture scheduledFuture;
    private volatile boolean subscribedToAttributes;
    private volatile boolean subscribedToRPC;
    private volatile boolean overwriteActivityTime;

    SessionMetaData(TransportProtos.SessionInfoProto sessionInfo, TransportProtos.SessionType sessionType, SessionMsgListener listener) {
        this.sessionInfo = sessionInfo;
        this.sessionType = sessionType;
        this.listener = listener;
        this.scheduledFuture = null;
    }

    void setScheduledFuture(ScheduledFuture scheduledFuture) {
        this.scheduledFuture = scheduledFuture;
    }

    public ScheduledFuture getScheduledFuture() {
        return this.scheduledFuture;
    }

    public boolean hasScheduledFuture() {
        return null != this.scheduledFuture;
    }

    public TransportProtos.SessionInfoProto getSessionInfo() {
        return this.sessionInfo;
    }

    public TransportProtos.SessionType getSessionType() {
        return this.sessionType;
    }

    public SessionMsgListener getListener() {
        return this.listener;
    }

    public boolean isSubscribedToAttributes() {
        return this.subscribedToAttributes;
    }

    public boolean isSubscribedToRPC() {
        return this.subscribedToRPC;
    }

    public boolean isOverwriteActivityTime() {
        return this.overwriteActivityTime;
    }

    public void setSessionInfo(TransportProtos.SessionInfoProto sessionInfo) {
        this.sessionInfo = sessionInfo;
    }

    public void setSubscribedToAttributes(boolean subscribedToAttributes) {
        this.subscribedToAttributes = subscribedToAttributes;
    }

    public void setSubscribedToRPC(boolean subscribedToRPC) {
        this.subscribedToRPC = subscribedToRPC;
    }

    public void setOverwriteActivityTime(boolean overwriteActivityTime) {
        this.overwriteActivityTime = overwriteActivityTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SessionMetaData)) {
            return false;
        }
        SessionMetaData other = (SessionMetaData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSubscribedToAttributes() != other.isSubscribedToAttributes()) {
            return false;
        }
        if (this.isSubscribedToRPC() != other.isSubscribedToRPC()) {
            return false;
        }
        if (this.isOverwriteActivityTime() != other.isOverwriteActivityTime()) {
            return false;
        }
        TransportProtos.SessionInfoProto this$sessionInfo = this.getSessionInfo();
        TransportProtos.SessionInfoProto other$sessionInfo = other.getSessionInfo();
        if (this$sessionInfo == null ? other$sessionInfo != null : !this$sessionInfo.equals(other$sessionInfo)) {
            return false;
        }
        TransportProtos.SessionType this$sessionType = this.getSessionType();
        TransportProtos.SessionType other$sessionType = other.getSessionType();
        if (this$sessionType == null ? other$sessionType != null : !this$sessionType.equals(other$sessionType)) {
            return false;
        }
        SessionMsgListener this$listener = this.getListener();
        SessionMsgListener other$listener = other.getListener();
        if (this$listener == null ? other$listener != null : !this$listener.equals(other$listener)) {
            return false;
        }
        ScheduledFuture this$scheduledFuture = this.getScheduledFuture();
        ScheduledFuture other$scheduledFuture = other.getScheduledFuture();
        return !(this$scheduledFuture == null ? other$scheduledFuture != null : !this$scheduledFuture.equals(other$scheduledFuture));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SessionMetaData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSubscribedToAttributes() ? 79 : 97);
        result = result * 59 + (this.isSubscribedToRPC() ? 79 : 97);
        result = result * 59 + (this.isOverwriteActivityTime() ? 79 : 97);
        TransportProtos.SessionInfoProto $sessionInfo = this.getSessionInfo();
        result = result * 59 + ($sessionInfo == null ? 43 : $sessionInfo.hashCode());
        TransportProtos.SessionType $sessionType = this.getSessionType();
        result = result * 59 + ($sessionType == null ? 43 : $sessionType.hashCode());
        SessionMsgListener $listener = this.getListener();
        result = result * 59 + ($listener == null ? 43 : $listener.hashCode());
        ScheduledFuture $scheduledFuture = this.getScheduledFuture();
        result = result * 59 + ($scheduledFuture == null ? 43 : $scheduledFuture.hashCode());
        return result;
    }

    public String toString() {
        return "SessionMetaData(sessionInfo=" + this.getSessionInfo() + ", sessionType=" + this.getSessionType() + ", listener=" + this.getListener() + ", scheduledFuture=" + this.getScheduledFuture() + ", subscribedToAttributes=" + this.isSubscribedToAttributes() + ", subscribedToRPC=" + this.isSubscribedToRPC() + ", overwriteActivityTime=" + this.isOverwriteActivityTime() + ")";
    }
}

