/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.transport.service;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.ApiUsageState;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.TenantProfile;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.TenantProfileId;
import org.thingsboard.server.common.transport.TransportService;
import org.thingsboard.server.common.transport.TransportTenantProfileCache;
import org.thingsboard.server.common.transport.limits.TransportRateLimitService;
import org.thingsboard.server.common.transport.profile.TenantProfileUpdateResult;
import org.thingsboard.server.common.util.ProtoUtils;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.util.TbTransportComponent;

@Component
@TbTransportComponent
public class DefaultTransportTenantProfileCache
implements TransportTenantProfileCache {
    private static final Logger log = LoggerFactory.getLogger(DefaultTransportTenantProfileCache.class);
    private final Lock tenantProfileFetchLock = new ReentrantLock();
    private final ConcurrentMap<TenantProfileId, TenantProfile> profiles = new ConcurrentHashMap<TenantProfileId, TenantProfile>();
    private final ConcurrentMap<TenantId, TenantProfileId> tenantIds = new ConcurrentHashMap<TenantId, TenantProfileId>();
    private final ConcurrentMap<TenantProfileId, Set<TenantId>> tenantProfileIds = new ConcurrentHashMap<TenantProfileId, Set<TenantId>>();
    private TransportRateLimitService rateLimitService;
    private TransportService transportService;

    @Lazy
    @Autowired
    public void setRateLimitService(TransportRateLimitService rateLimitService) {
        this.rateLimitService = rateLimitService;
    }

    @Lazy
    @Autowired
    public void setTransportService(TransportService transportService) {
        this.transportService = transportService;
    }

    @Override
    public TenantProfile get(TenantId tenantId) {
        return this.getTenantProfile(tenantId);
    }

    @Override
    public TenantProfileUpdateResult put(TransportProtos.TenantProfileProto proto) {
        TenantProfile profile = ProtoUtils.fromProto((TransportProtos.TenantProfileProto)proto);
        log.trace("[{}] put: {}", (Object)profile.getId(), (Object)profile);
        this.profiles.put(profile.getId(), profile);
        Set<TenantId> affectedTenants = (Set<TenantId>)this.tenantProfileIds.get(profile.getId());
        return new TenantProfileUpdateResult(profile, affectedTenants != null ? affectedTenants : Collections.emptySet());
    }

    @Override
    public boolean put(TenantId tenantId, TenantProfileId profileId) {
        log.trace("[{}] put: {}", (Object)tenantId, (Object)profileId);
        TenantProfileId oldProfileId = (TenantProfileId)this.tenantIds.get(tenantId);
        if (oldProfileId != null && !oldProfileId.equals((Object)profileId)) {
            this.tenantProfileIds.computeIfAbsent(oldProfileId, id -> ConcurrentHashMap.newKeySet()).remove(tenantId);
            this.tenantIds.put(tenantId, profileId);
            this.tenantProfileIds.computeIfAbsent(profileId, id -> ConcurrentHashMap.newKeySet()).add(tenantId);
            return true;
        }
        return false;
    }

    @Override
    public Set<TenantId> remove(TenantProfileId profileId) {
        Set tenants = (Set)this.tenantProfileIds.remove(profileId);
        if (tenants != null) {
            tenants.forEach(this.tenantIds::remove);
        }
        this.profiles.remove(profileId);
        return tenants;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TenantProfile getTenantProfile(TenantId tenantId) {
        TenantProfile profile = null;
        TenantProfileId tenantProfileId = (TenantProfileId)this.tenantIds.get(tenantId);
        if (tenantProfileId != null) {
            profile = (TenantProfile)this.profiles.get(tenantProfileId);
        }
        if (profile == null) {
            this.tenantProfileFetchLock.lock();
            try {
                tenantProfileId = (TenantProfileId)this.tenantIds.get(tenantId);
                if (tenantProfileId != null) {
                    profile = (TenantProfile)this.profiles.get(tenantProfileId);
                }
                if (profile == null) {
                    TransportProtos.GetEntityProfileRequestMsg msg = TransportProtos.GetEntityProfileRequestMsg.newBuilder().setEntityType(EntityType.TENANT.name()).setEntityIdMSB(tenantId.getId().getMostSignificantBits()).setEntityIdLSB(tenantId.getId().getLeastSignificantBits()).build();
                    TransportProtos.GetEntityProfileResponseMsg entityProfileMsg = this.transportService.getEntityProfile(msg);
                    profile = ProtoUtils.fromProto((TransportProtos.TenantProfileProto)entityProfileMsg.getTenantProfile());
                    TenantProfile existingProfile = (TenantProfile)this.profiles.get(profile.getId());
                    if (existingProfile != null) {
                        profile = existingProfile;
                    } else {
                        this.profiles.put(profile.getId(), profile);
                    }
                    this.tenantProfileIds.computeIfAbsent(profile.getId(), id -> ConcurrentHashMap.newKeySet()).add(tenantId);
                    this.tenantIds.put(tenantId, profile.getId());
                    ApiUsageState apiUsageState = ProtoUtils.fromProto((TransportProtos.ApiUsageStateProto)entityProfileMsg.getApiState());
                    this.rateLimitService.update(tenantId, apiUsageState.isTransportEnabled());
                }
            }
            finally {
                this.tenantProfileFetchLock.unlock();
            }
        }
        return profile;
    }
}

