/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.transport.service;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.DeviceProfile;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.id.DeviceProfileId;
import org.thingsboard.server.common.transport.TransportDeviceProfileCache;
import org.thingsboard.server.common.transport.TransportService;
import org.thingsboard.server.common.util.ProtoUtils;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.util.TbTransportComponent;

@Component
@TbTransportComponent
public class DefaultTransportDeviceProfileCache
implements TransportDeviceProfileCache {
    private static final Logger log = LoggerFactory.getLogger(DefaultTransportDeviceProfileCache.class);
    private final Lock deviceProfileFetchLock = new ReentrantLock();
    private final ConcurrentMap<DeviceProfileId, DeviceProfile> deviceProfiles = new ConcurrentHashMap<DeviceProfileId, DeviceProfile>();
    private TransportService transportService;

    @Lazy
    @Autowired
    public void setTransportService(TransportService transportService) {
        this.transportService = transportService;
    }

    @Override
    public DeviceProfile getOrCreate(DeviceProfileId id, TransportProtos.DeviceProfileProto proto) {
        DeviceProfile profile = (DeviceProfile)this.deviceProfiles.get(id);
        if (profile == null) {
            profile = ProtoUtils.fromProto((TransportProtos.DeviceProfileProto)proto);
            this.deviceProfiles.put(id, profile);
        }
        return profile;
    }

    @Override
    public DeviceProfile get(DeviceProfileId id) {
        return this.getDeviceProfile(id);
    }

    @Override
    public void put(DeviceProfile profile) {
        this.deviceProfiles.put(profile.getId(), profile);
    }

    @Override
    public DeviceProfile put(TransportProtos.DeviceProfileProto proto) {
        DeviceProfile deviceProfile = ProtoUtils.fromProto((TransportProtos.DeviceProfileProto)proto);
        this.put(deviceProfile);
        return deviceProfile;
    }

    @Override
    public void evict(DeviceProfileId id) {
        this.deviceProfiles.remove(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DeviceProfile getDeviceProfile(DeviceProfileId id) {
        DeviceProfile profile = (DeviceProfile)this.deviceProfiles.get(id);
        if (profile == null) {
            this.deviceProfileFetchLock.lock();
            try {
                TransportProtos.GetEntityProfileRequestMsg msg = TransportProtos.GetEntityProfileRequestMsg.newBuilder().setEntityType(EntityType.DEVICE_PROFILE.name()).setEntityIdMSB(id.getId().getMostSignificantBits()).setEntityIdLSB(id.getId().getLeastSignificantBits()).build();
                TransportProtos.GetEntityProfileResponseMsg entityProfileMsg = this.transportService.getEntityProfile(msg);
                profile = ProtoUtils.fromProto((TransportProtos.DeviceProfileProto)entityProfileMsg.getDeviceProfile());
                this.put(profile);
            }
            finally {
                this.deviceProfileFetchLock.unlock();
            }
        }
        return profile;
    }
}

