/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.transport.limits;

import java.beans.ConstructorProperties;
import org.thingsboard.server.common.msg.tools.TbRateLimits;
import org.thingsboard.server.common.transport.limits.TransportRateLimit;

public class SimpleTransportRateLimit
implements TransportRateLimit {
    private final TbRateLimits rateLimit;
    private final String configuration;

    public SimpleTransportRateLimit(String configuration) {
        this.configuration = configuration;
        this.rateLimit = new TbRateLimits(configuration);
    }

    @Override
    public boolean tryConsume() {
        return this.rateLimit.tryConsume();
    }

    @Override
    public boolean tryConsume(long number) {
        return number <= 0L || this.rateLimit.tryConsume(number);
    }

    @ConstructorProperties(value={"rateLimit", "configuration"})
    public SimpleTransportRateLimit(TbRateLimits rateLimit, String configuration) {
        this.rateLimit = rateLimit;
        this.configuration = configuration;
    }

    @Override
    public String getConfiguration() {
        return this.configuration;
    }
}

