/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.transport.limits;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class InetAddressRateLimitStats {
    private final Lock lock = new ReentrantLock();
    private boolean blocked;
    private long lastActivityTs;
    private int failureCount;
    private int connectionsCount;

    public Lock getLock() {
        return this.lock;
    }

    public boolean isBlocked() {
        return this.blocked;
    }

    public long getLastActivityTs() {
        return this.lastActivityTs;
    }

    public int getFailureCount() {
        return this.failureCount;
    }

    public int getConnectionsCount() {
        return this.connectionsCount;
    }

    public void setBlocked(boolean blocked) {
        this.blocked = blocked;
    }

    public void setLastActivityTs(long lastActivityTs) {
        this.lastActivityTs = lastActivityTs;
    }

    public void setFailureCount(int failureCount) {
        this.failureCount = failureCount;
    }

    public void setConnectionsCount(int connectionsCount) {
        this.connectionsCount = connectionsCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InetAddressRateLimitStats)) {
            return false;
        }
        InetAddressRateLimitStats other = (InetAddressRateLimitStats)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isBlocked() != other.isBlocked()) {
            return false;
        }
        if (this.getLastActivityTs() != other.getLastActivityTs()) {
            return false;
        }
        if (this.getFailureCount() != other.getFailureCount()) {
            return false;
        }
        if (this.getConnectionsCount() != other.getConnectionsCount()) {
            return false;
        }
        Lock this$lock = this.getLock();
        Lock other$lock = other.getLock();
        return !(this$lock == null ? other$lock != null : !this$lock.equals(other$lock));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InetAddressRateLimitStats;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isBlocked() ? 79 : 97);
        long $lastActivityTs = this.getLastActivityTs();
        result = result * 59 + (int)($lastActivityTs >>> 32 ^ $lastActivityTs);
        result = result * 59 + this.getFailureCount();
        result = result * 59 + this.getConnectionsCount();
        Lock $lock = this.getLock();
        result = result * 59 + ($lock == null ? 43 : $lock.hashCode());
        return result;
    }

    public String toString() {
        return "InetAddressRateLimitStats(lock=" + this.getLock() + ", blocked=" + this.isBlocked() + ", lastActivityTs=" + this.getLastActivityTs() + ", failureCount=" + this.getFailureCount() + ", connectionsCount=" + this.getConnectionsCount() + ")";
    }
}

