/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.transport.limits;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.transport.limits.EntityLimitKey;
import org.thingsboard.server.common.transport.limits.EntityLimitsCache;
import org.thingsboard.server.queue.util.TbTransportComponent;

@Service
@TbTransportComponent
public class DefaultEntityLimitsCache
implements EntityLimitsCache {
    private static final Logger log = LoggerFactory.getLogger(DefaultEntityLimitsCache.class);
    private static final int DEVIATION = 10;
    private final Cache<EntityLimitKey, Boolean> cache;

    public DefaultEntityLimitsCache(@Value(value="${cache.entityLimits.timeToLiveInMinutes:5}") int ttl, @Value(value="${cache.entityLimits.maxSize:100000}") int maxSize) {
        final long mainPart = TimeUnit.MINUTES.toNanos(ttl) / 100L * 90L;
        final long randomPart = TimeUnit.MINUTES.toNanos(ttl) / 100L * 10L;
        this.cache = Caffeine.newBuilder().expireAfter((Expiry)new Expiry<EntityLimitKey, Boolean>(){

            public long expireAfterCreate(@NotNull EntityLimitKey key, @NotNull Boolean value, long currentTime) {
                return mainPart + (long)((double)randomPart * ThreadLocalRandom.current().nextDouble());
            }

            public long expireAfterUpdate(@NotNull EntityLimitKey key, @NotNull Boolean value, long currentTime, long currentDuration) {
                return currentDuration;
            }

            public long expireAfterRead(@NotNull EntityLimitKey key, @NotNull Boolean value, long currentTime, long currentDuration) {
                return currentDuration;
            }
        }).maximumSize((long)maxSize).build();
    }

    @Override
    public boolean get(EntityLimitKey key) {
        Boolean result = (Boolean)this.cache.getIfPresent((Object)key);
        return result != null ? result : false;
    }

    @Override
    public void put(EntityLimitKey key, boolean value) {
        this.cache.put((Object)key, (Object)value);
    }
}

