/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.transport.config.ssl;

import java.security.KeyStore;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.web.server.Ssl;
import org.springframework.boot.web.server.SslStoreProvider;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.boot.web.servlet.server.ConfigurableServletWebServerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.transport.config.ssl.SslCredentials;
import org.thingsboard.server.common.transport.config.ssl.SslCredentialsConfig;

@Component
@ConditionalOnExpression(value="'${spring.main.web-environment:true}'=='true' && '${server.ssl.enabled:false}'=='true'")
public class SslCredentialsWebServerCustomizer
implements WebServerFactoryCustomizer<ConfigurableServletWebServerFactory> {
    @Autowired
    @Qualifier(value="httpServerSslCredentials")
    private SslCredentialsConfig httpServerSslCredentialsConfig;
    private final ServerProperties serverProperties;

    @Bean
    @ConfigurationProperties(prefix="server.ssl.credentials")
    public SslCredentialsConfig httpServerSslCredentials() {
        return new SslCredentialsConfig("HTTP Server SSL Credentials", false);
    }

    public SslCredentialsWebServerCustomizer(ServerProperties serverProperties) {
        this.serverProperties = serverProperties;
    }

    public void customize(ConfigurableServletWebServerFactory factory) {
        final SslCredentials sslCredentials = this.httpServerSslCredentialsConfig.getCredentials();
        Ssl ssl = this.serverProperties.getSsl();
        ssl.setKeyAlias(sslCredentials.getKeyAlias());
        ssl.setKeyPassword(sslCredentials.getKeyPassword());
        factory.setSsl(ssl);
        factory.setSslStoreProvider(new SslStoreProvider(){

            public KeyStore getKeyStore() {
                return sslCredentials.getKeyStore();
            }

            public KeyStore getTrustStore() {
                return null;
            }
        });
    }
}

