/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.transport.config.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.thingsboard.server.common.data.ResourceUtils;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.transport.config.ssl.AbstractSslCredentials;

public class PemSslCredentials
extends AbstractSslCredentials {
    private static final String DEFAULT_KEY_ALIAS = "server";
    private String certFile;
    private String keyFile;
    private String keyPassword;

    @Override
    protected boolean canUse() {
        return ResourceUtils.resourceExists((Object)this, (String)this.certFile);
    }

    @Override
    protected KeyStore loadKeyStore(boolean trustsOnly, char[] keyPasswordArray) throws IOException, GeneralSecurityException {
        PEMDecryptorProvider decProv;
        Object object;
        PEMParser pemParser;
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
        PrivateKey privateKey = null;
        JcaX509CertificateConverter certConverter = new JcaX509CertificateConverter();
        JcaPEMKeyConverter keyConverter = new JcaPEMKeyConverter();
        try (InputStream inStream = ResourceUtils.getInputStream((Object)this, (String)this.certFile);){
            pemParser = new PEMParser((Reader)new InputStreamReader(inStream));
            try {
                while ((object = pemParser.readObject()) != null) {
                    if (object instanceof X509CertificateHolder) {
                        X509Certificate x509Cert = certConverter.getCertificate((X509CertificateHolder)object);
                        certificates.add(x509Cert);
                        continue;
                    }
                    if (object instanceof PEMEncryptedKeyPair) {
                        decProv = new JcePEMDecryptorProviderBuilder().build(keyPasswordArray);
                        privateKey = keyConverter.getKeyPair(((PEMEncryptedKeyPair)object).decryptKeyPair(decProv)).getPrivate();
                        continue;
                    }
                    if (object instanceof PEMKeyPair) {
                        privateKey = keyConverter.getKeyPair((PEMKeyPair)object).getPrivate();
                        continue;
                    }
                    if (!(object instanceof PrivateKeyInfo)) continue;
                    privateKey = keyConverter.getPrivateKey((PrivateKeyInfo)object);
                }
            }
            finally {
                pemParser.close();
            }
        }
        if (privateKey == null && !StringUtils.isEmpty((String)this.keyFile) && ResourceUtils.resourceExists((Object)this, (String)this.keyFile)) {
            inStream = ResourceUtils.getInputStream((Object)this, (String)this.keyFile);
            try {
                pemParser = new PEMParser((Reader)new InputStreamReader(inStream));
                try {
                    while ((object = pemParser.readObject()) != null) {
                        if (object instanceof PEMEncryptedKeyPair) {
                            decProv = new JcePEMDecryptorProviderBuilder().build(keyPasswordArray);
                            privateKey = keyConverter.getKeyPair(((PEMEncryptedKeyPair)object).decryptKeyPair(decProv)).getPrivate();
                            break;
                        }
                        if (object instanceof PEMKeyPair) {
                            privateKey = keyConverter.getKeyPair((PEMKeyPair)object).getPrivate();
                            break;
                        }
                        if (!(object instanceof PrivateKeyInfo)) continue;
                        privateKey = keyConverter.getPrivateKey((PrivateKeyInfo)object);
                    }
                }
                finally {
                    pemParser.close();
                }
            }
            finally {
                if (inStream != null) {
                    inStream.close();
                }
            }
        }
        if (certificates.isEmpty()) {
            throw new IllegalArgumentException("No certificates found in certFile: " + this.certFile);
        }
        if (privateKey == null && !trustsOnly) {
            throw new IllegalArgumentException("Unable to load private key neither from certFile: " + this.certFile + " nor from keyFile: " + this.keyFile);
        }
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(null);
        if (trustsOnly) {
            List unique = certificates.stream().distinct().collect(Collectors.toList());
            for (int i = 0; i < unique.size(); ++i) {
                keyStore.setCertificateEntry("root-" + i, (Certificate)unique.get(i));
            }
        }
        if (privateKey != null) {
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            CertPath certPath = factory.generateCertPath(certificates);
            List<? extends Certificate> path = certPath.getCertificates();
            Certificate[] x509Certificates = path.toArray(new Certificate[0]);
            keyStore.setKeyEntry(DEFAULT_KEY_ALIAS, privateKey, keyPasswordArray, x509Certificates);
        }
        return keyStore;
    }

    @Override
    public String getKeyAlias() {
        return DEFAULT_KEY_ALIAS;
    }

    @Override
    protected void updateKeyAlias(String keyAlias) {
    }

    public String getCertFile() {
        return this.certFile;
    }

    public String getKeyFile() {
        return this.keyFile;
    }

    @Override
    public String getKeyPassword() {
        return this.keyPassword;
    }

    public void setCertFile(String certFile) {
        this.certFile = certFile;
    }

    public void setKeyFile(String keyFile) {
        this.keyFile = keyFile;
    }

    public void setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
    }

    public String toString() {
        return "PemSslCredentials(certFile=" + this.getCertFile() + ", keyFile=" + this.getKeyFile() + ", keyPassword=" + this.getKeyPassword() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PemSslCredentials)) {
            return false;
        }
        PemSslCredentials other = (PemSslCredentials)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$certFile = this.getCertFile();
        String other$certFile = other.getCertFile();
        if (this$certFile == null ? other$certFile != null : !this$certFile.equals(other$certFile)) {
            return false;
        }
        String this$keyFile = this.getKeyFile();
        String other$keyFile = other.getKeyFile();
        if (this$keyFile == null ? other$keyFile != null : !this$keyFile.equals(other$keyFile)) {
            return false;
        }
        String this$keyPassword = this.getKeyPassword();
        String other$keyPassword = other.getKeyPassword();
        return !(this$keyPassword == null ? other$keyPassword != null : !this$keyPassword.equals(other$keyPassword));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PemSslCredentials;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $certFile = this.getCertFile();
        result = result * 59 + ($certFile == null ? 43 : $certFile.hashCode());
        String $keyFile = this.getKeyFile();
        result = result * 59 + ($keyFile == null ? 43 : $keyFile.hashCode());
        String $keyPassword = this.getKeyPassword();
        result = result * 59 + ($keyPassword == null ? 43 : $keyPassword.hashCode());
        return result;
    }
}

