/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.transport.config.ssl;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.transport.config.ssl.SslCredentials;

public abstract class AbstractSslCredentials
implements SslCredentials {
    private char[] keyPasswordArray;
    private KeyStore keyStore;
    private PrivateKey privateKey;
    private PublicKey publicKey;
    private X509Certificate[] chain;
    private X509Certificate[] trusts;

    @Override
    public void init(boolean trustsOnly) throws IOException, GeneralSecurityException {
        String keyPassword = this.getKeyPassword();
        this.keyPasswordArray = StringUtils.isEmpty((String)keyPassword) ? new char[0] : keyPassword.toCharArray();
        this.keyStore = this.loadKeyStore(trustsOnly, this.keyPasswordArray);
        Set<X509Certificate> trustedCerts = AbstractSslCredentials.getTrustedCerts(this.keyStore, trustsOnly);
        this.trusts = trustedCerts.toArray(new X509Certificate[0]);
        if (!trustsOnly) {
            KeyStore.PrivateKeyEntry privateKeyEntry = null;
            String keyAlias = this.getKeyAlias();
            if (!StringUtils.isEmpty((String)keyAlias)) {
                privateKeyEntry = AbstractSslCredentials.tryGetPrivateKeyEntry(this.keyStore, keyAlias, this.keyPasswordArray);
            } else {
                Enumeration<String> e = this.keyStore.aliases();
                while (e.hasMoreElements()) {
                    String alias = e.nextElement();
                    privateKeyEntry = AbstractSslCredentials.tryGetPrivateKeyEntry(this.keyStore, alias, this.keyPasswordArray);
                    if (privateKeyEntry == null) continue;
                    this.updateKeyAlias(alias);
                    break;
                }
            }
            if (privateKeyEntry == null) {
                throw new IllegalArgumentException("Failed to get private key from the keystore or pem files. Please check if the private key exists in the keystore or pem files and if the provided private key password is valid.");
            }
            this.chain = AbstractSslCredentials.asX509Certificates(privateKeyEntry.getCertificateChain());
            this.privateKey = privateKeyEntry.getPrivateKey();
            if (this.chain.length > 0) {
                this.publicKey = this.chain[0].getPublicKey();
            }
        }
    }

    @Override
    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    @Override
    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    @Override
    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    @Override
    public X509Certificate[] getCertificateChain() {
        return this.chain;
    }

    @Override
    public X509Certificate[] getTrustedCertificates() {
        return this.trusts;
    }

    @Override
    public TrustManagerFactory createTrustManagerFactory() throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory tmFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmFactory.init(this.keyStore);
        return tmFactory;
    }

    @Override
    public KeyManagerFactory createKeyManagerFactory() throws NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException {
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(this.keyStore, this.keyPasswordArray);
        return kmf;
    }

    @Override
    public String getValueFromSubjectNameByKey(String subjectName, String key) {
        String[] dns = subjectName.split(",");
        Optional<String> cn = Arrays.stream(dns).filter(dn -> dn.contains(key + "=")).findFirst();
        String value = cn.isPresent() ? cn.get().replace(key + "=", "") : null;
        return StringUtils.isNotEmpty(value) ? value : null;
    }

    protected abstract boolean canUse();

    protected abstract KeyStore loadKeyStore(boolean var1, char[] var2) throws IOException, GeneralSecurityException;

    protected abstract void updateKeyAlias(String var1);

    private static X509Certificate[] asX509Certificates(Certificate[] certificates) {
        if (null == certificates || 0 == certificates.length) {
            throw new IllegalArgumentException("certificates missing!");
        }
        X509Certificate[] x509Certificates = new X509Certificate[certificates.length];
        for (int index = 0; certificates.length > index; ++index) {
            if (null == certificates[index]) {
                throw new IllegalArgumentException("[" + index + "] is null!");
            }
            try {
                x509Certificates[index] = (X509Certificate)certificates[index];
                continue;
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("[" + index + "] is not a x509 certificate! Instead it's a " + certificates[index].getClass().getName());
            }
        }
        return x509Certificates;
    }

    private static KeyStore.PrivateKeyEntry tryGetPrivateKeyEntry(KeyStore keyStore, String alias, char[] pwd) {
        KeyStore.PrivateKeyEntry entry = null;
        try {
            if (keyStore.entryInstanceOf(alias, KeyStore.PrivateKeyEntry.class)) {
                try {
                    entry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(alias, new KeyStore.PasswordProtection(pwd));
                }
                catch (UnsupportedOperationException e) {
                    PrivateKey key = (PrivateKey)keyStore.getKey(alias, pwd);
                    Certificate[] certs = keyStore.getCertificateChain(alias);
                    entry = new KeyStore.PrivateKeyEntry(key, certs);
                }
            }
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableEntryException generalSecurityException) {
            // empty catch block
        }
        return entry;
    }

    private static Set<X509Certificate> getTrustedCerts(KeyStore ks, boolean trustsOnly) {
        HashSet<X509Certificate> set = new HashSet<X509Certificate>();
        try {
            Enumeration<String> e = ks.aliases();
            while (e.hasMoreElements()) {
                Certificate[] certs;
                String alias = e.nextElement();
                if (ks.isCertificateEntry(alias)) {
                    Certificate cert = ks.getCertificate(alias);
                    if (!(cert instanceof X509Certificate)) continue;
                    if (trustsOnly) {
                        if (((X509Certificate)cert).getBasicConstraints() < 0) continue;
                        set.add((X509Certificate)cert);
                        continue;
                    }
                    set.add((X509Certificate)cert);
                    continue;
                }
                if (!ks.isKeyEntry(alias) || (certs = ks.getCertificateChain(alias)) == null || certs.length <= 0 || !(certs[0] instanceof X509Certificate)) continue;
                if (trustsOnly) {
                    for (Certificate cert : certs) {
                        if (((X509Certificate)cert).getBasicConstraints() < 0) continue;
                        set.add((X509Certificate)cert);
                    }
                    continue;
                }
                set.add((X509Certificate)certs[0]);
            }
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
        return Collections.unmodifiableSet(set);
    }
}

