/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.transport.activity.strategy;

import org.thingsboard.server.common.transport.activity.strategy.ActivityStrategy;
import org.thingsboard.server.common.transport.activity.strategy.AllEventsActivityStrategy;
import org.thingsboard.server.common.transport.activity.strategy.FirstAndLastEventActivityStrategy;
import org.thingsboard.server.common.transport.activity.strategy.FirstEventActivityStrategy;
import org.thingsboard.server.common.transport.activity.strategy.LastEventActivityStrategy;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ActivityStrategyType {
    ALL{

        @Override
        public ActivityStrategy toStrategy() {
            return AllEventsActivityStrategy.getInstance();
        }
    }
    ,
    FIRST{

        @Override
        public ActivityStrategy toStrategy() {
            return new FirstEventActivityStrategy();
        }
    }
    ,
    LAST{

        @Override
        public ActivityStrategy toStrategy() {
            return LastEventActivityStrategy.getInstance();
        }
    }
    ,
    FIRST_AND_LAST{

        @Override
        public ActivityStrategy toStrategy() {
            return new FirstAndLastEventActivityStrategy();
        }
    };


    public abstract ActivityStrategy toStrategy();
}

