/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.transport.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.protobuf.GeneratedMessageV3;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.beans.ConstructorProperties;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.ThingsBoardExecutors;
import org.thingsboard.common.util.ThingsBoardThreadFactory;
import org.thingsboard.server.common.data.ApiUsageRecordKey;
import org.thingsboard.server.common.data.ApiUsageState;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.DeviceProfile;
import org.thingsboard.server.common.data.DeviceTransportType;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.ResourceType;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.Tenant;
import org.thingsboard.server.common.data.device.data.PowerMode;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.DeviceProfileId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.TenantProfileId;
import org.thingsboard.server.common.data.limit.LimitedApi;
import org.thingsboard.server.common.data.msg.TbMsgType;
import org.thingsboard.server.common.data.notification.rule.trigger.NotificationRuleTrigger;
import org.thingsboard.server.common.data.notification.rule.trigger.RateLimitsTrigger;
import org.thingsboard.server.common.data.plugin.ComponentLifecycleEvent;
import org.thingsboard.server.common.data.rpc.RpcStatus;
import org.thingsboard.server.common.data.util.TbPair;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.TbMsgMetaData;
import org.thingsboard.server.common.msg.notification.NotificationRuleProcessor;
import org.thingsboard.server.common.msg.queue.ServiceType;
import org.thingsboard.server.common.msg.queue.TopicPartitionInfo;
import org.thingsboard.server.common.msg.tools.TbRateLimitsException;
import org.thingsboard.server.common.stats.MessagesStats;
import org.thingsboard.server.common.stats.StatsFactory;
import org.thingsboard.server.common.stats.StatsType;
import org.thingsboard.server.common.stats.TbApiUsageReportClient;
import org.thingsboard.server.common.transport.DeviceDeletedEvent;
import org.thingsboard.server.common.transport.DeviceProfileUpdatedEvent;
import org.thingsboard.server.common.transport.DeviceUpdatedEvent;
import org.thingsboard.server.common.transport.SessionMsgListener;
import org.thingsboard.server.common.transport.TransportDeviceProfileCache;
import org.thingsboard.server.common.transport.TransportResourceCache;
import org.thingsboard.server.common.transport.TransportService;
import org.thingsboard.server.common.transport.TransportServiceCallback;
import org.thingsboard.server.common.transport.TransportTenantProfileCache;
import org.thingsboard.server.common.transport.auth.GetOrCreateDeviceFromGatewayResponse;
import org.thingsboard.server.common.transport.auth.TransportDeviceInfo;
import org.thingsboard.server.common.transport.auth.ValidateDeviceCredentialsResponse;
import org.thingsboard.server.common.transport.limits.EntityLimitKey;
import org.thingsboard.server.common.transport.limits.EntityLimitsCache;
import org.thingsboard.server.common.transport.limits.TransportRateLimitService;
import org.thingsboard.server.common.transport.service.RpcRequestMetadata;
import org.thingsboard.server.common.transport.service.SessionMetaData;
import org.thingsboard.server.common.transport.service.TransportActivityManager;
import org.thingsboard.server.common.transport.util.JsonUtils;
import org.thingsboard.server.common.util.ProtoUtils;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.TbQueueCallback;
import org.thingsboard.server.queue.TbQueueConsumer;
import org.thingsboard.server.queue.TbQueueMsg;
import org.thingsboard.server.queue.TbQueueMsgMetadata;
import org.thingsboard.server.queue.TbQueueProducer;
import org.thingsboard.server.queue.TbQueueRequestTemplate;
import org.thingsboard.server.queue.common.AsyncCallbackTemplate;
import org.thingsboard.server.queue.common.TbProtoQueueMsg;
import org.thingsboard.server.queue.common.TbRuleEngineProducerService;
import org.thingsboard.server.queue.common.consumer.QueueConsumerManager;
import org.thingsboard.server.queue.discovery.PartitionService;
import org.thingsboard.server.queue.discovery.TbServiceInfoProvider;
import org.thingsboard.server.queue.discovery.TopicService;
import org.thingsboard.server.queue.provider.TbQueueProducerProvider;
import org.thingsboard.server.queue.provider.TbTransportQueueFactory;
import org.thingsboard.server.queue.scheduler.SchedulerComponent;
import org.thingsboard.server.queue.util.AfterStartUp;
import org.thingsboard.server.queue.util.TbTransportComponent;

@Service
@TbTransportComponent
public class DefaultTransportService
extends TransportActivityManager
implements TransportService {
    private static final Logger log = LoggerFactory.getLogger(DefaultTransportService.class);
    public static final TransportProtos.SessionEventMsg SESSION_EVENT_MSG_OPEN = TransportProtos.SessionEventMsg.newBuilder().setSessionType(TransportProtos.SessionType.ASYNC).setEvent(TransportProtos.SessionEvent.OPEN).build();
    public static final TransportProtos.SubscribeToAttributeUpdatesMsg SUBSCRIBE_TO_ATTRIBUTE_UPDATES_ASYNC_MSG = TransportProtos.SubscribeToAttributeUpdatesMsg.newBuilder().setSessionType(TransportProtos.SessionType.ASYNC).build();
    public static final TransportProtos.SubscribeToRPCMsg SUBSCRIBE_TO_RPC_ASYNC_MSG = TransportProtos.SubscribeToRPCMsg.newBuilder().setSessionType(TransportProtos.SessionType.ASYNC).build();
    private final AtomicInteger atomicTs = new AtomicInteger(0);
    @Value(value="${transport.log.enabled:true}")
    private boolean logEnabled;
    @Value(value="${transport.log.max_length:1024}")
    private int logMaxLength;
    @Value(value="${transport.client_side_rpc.timeout:60000}")
    private long clientSideRpcTimeout;
    @Value(value="${queue.transport.poll_interval}")
    private int notificationsPollDuration;
    @Value(value="${transport.stats.enabled:false}")
    private boolean statsEnabled;
    @Autowired
    @Lazy
    private TbApiUsageReportClient apiUsageClient;
    private final Map<String, Number> statsMap = new LinkedHashMap<String, Number>();
    private final Gson gson = new Gson();
    private final PartitionService partitionService;
    private final TbTransportQueueFactory queueProvider;
    private final TbQueueProducerProvider producerProvider;
    private final TbRuleEngineProducerService ruleEngineProducerService;
    private final TopicService topicService;
    private final TbServiceInfoProvider serviceInfoProvider;
    private final StatsFactory statsFactory;
    private final TransportDeviceProfileCache deviceProfileCache;
    private final TransportTenantProfileCache tenantProfileCache;
    private final TransportRateLimitService rateLimitService;
    private final SchedulerComponent scheduler;
    private final ApplicationEventPublisher eventPublisher;
    private final TransportResourceCache transportResourceCache;
    private final NotificationRuleProcessor notificationRuleProcessor;
    private final EntityLimitsCache entityLimitsCache;
    protected TbQueueRequestTemplate<TbProtoQueueMsg<TransportProtos.TransportApiRequestMsg>, TbProtoQueueMsg<TransportProtos.TransportApiResponseMsg>> transportApiRequestTemplate;
    protected TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToRuleEngineMsg>> ruleEngineMsgProducer;
    protected TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToCoreMsg>> tbCoreMsgProducer;
    protected QueueConsumerManager<TbProtoQueueMsg<TransportProtos.ToTransportMsg>> transportNotificationsConsumer;
    protected MessagesStats ruleEngineProducerStats;
    protected MessagesStats tbCoreProducerStats;
    protected MessagesStats transportApiStats;
    protected ExecutorService transportCallbackExecutor;
    private ExecutorService consumerExecutor;
    private final Map<String, RpcRequestMetadata> toServerRpcPendingMap = new ConcurrentHashMap<String, RpcRequestMetadata>();

    @Override
    @PostConstruct
    public void init() {
        super.init();
        this.ruleEngineProducerStats = this.statsFactory.createMessagesStats(StatsType.RULE_ENGINE.getName() + ".producer");
        this.tbCoreProducerStats = this.statsFactory.createMessagesStats(StatsType.CORE.getName() + ".producer");
        this.transportApiStats = this.statsFactory.createMessagesStats(StatsType.TRANSPORT.getName() + ".producer");
        this.transportCallbackExecutor = ThingsBoardExecutors.newWorkStealingPool((int)20, this.getClass());
        this.scheduler.scheduleAtFixedRate(this::invalidateRateLimits, (long)new Random().nextInt((int)this.sessionReportTimeout), this.sessionReportTimeout, TimeUnit.MILLISECONDS);
        this.transportApiRequestTemplate = this.queueProvider.createTransportApiRequestTemplate();
        this.transportApiRequestTemplate.setMessagesStats(this.transportApiStats);
        this.ruleEngineMsgProducer = this.producerProvider.getRuleEngineMsgProducer();
        this.tbCoreMsgProducer = this.producerProvider.getTbCoreMsgProducer();
        this.transportApiRequestTemplate.init();
        this.consumerExecutor = Executors.newSingleThreadExecutor((ThreadFactory)ThingsBoardThreadFactory.forName((String)"transport-consumer"));
        this.transportNotificationsConsumer = QueueConsumerManager.builder().name("TB Transport").msgPackProcessor(this::processNotificationMsgs).pollInterval((long)this.notificationsPollDuration).consumerCreator(() -> ((TbTransportQueueFactory)this.queueProvider).createTransportNotificationsConsumer()).consumerExecutor(this.consumerExecutor).build();
    }

    @AfterStartUp(order=2147482647)
    public void start() {
        TopicPartitionInfo tpi = this.topicService.getNotificationsTopic(ServiceType.TB_TRANSPORT, this.serviceInfoProvider.getServiceId());
        this.transportNotificationsConsumer.subscribe(Set.of(tpi));
        this.transportNotificationsConsumer.launch();
    }

    private void processNotificationMsgs(List<TbProtoQueueMsg<TransportProtos.ToTransportMsg>> msgs, TbQueueConsumer<TbProtoQueueMsg<TransportProtos.ToTransportMsg>> consumer) {
        msgs.forEach(msg -> {
            try {
                this.processToTransportMsg((TransportProtos.ToTransportMsg)msg.getValue());
            }
            catch (Throwable e) {
                log.warn("Failed to process the notification.", e);
            }
        });
        consumer.commit();
    }

    private void invalidateRateLimits() {
        this.rateLimitService.invalidateRateLimitsIpTable(this.sessionInactivityTimeout);
    }

    @PreDestroy
    public void destroy() {
        if (this.transportNotificationsConsumer != null) {
            this.transportNotificationsConsumer.stop();
        }
        if (this.transportCallbackExecutor != null) {
            this.transportCallbackExecutor.shutdownNow();
        }
        if (this.consumerExecutor != null) {
            this.consumerExecutor.shutdownNow();
        }
        if (this.transportApiRequestTemplate != null) {
            this.transportApiRequestTemplate.stop();
        }
    }

    @Override
    public SessionMetaData registerAsyncSession(TransportProtos.SessionInfoProto sessionInfo, SessionMsgListener listener) {
        return this.sessions.computeIfAbsent(this.toSessionId(sessionInfo), x -> new SessionMetaData(sessionInfo, TransportProtos.SessionType.ASYNC, listener));
    }

    @Override
    public TransportProtos.GetEntityProfileResponseMsg getEntityProfile(TransportProtos.GetEntityProfileRequestMsg msg) {
        TbProtoQueueMsg protoMsg = new TbProtoQueueMsg(UUID.randomUUID(), (GeneratedMessageV3)TransportProtos.TransportApiRequestMsg.newBuilder().setEntityProfileRequestMsg(msg).build());
        try {
            TbProtoQueueMsg response = (TbProtoQueueMsg)this.transportApiRequestTemplate.send((TbQueueMsg)protoMsg).get();
            return ((TransportProtos.TransportApiResponseMsg)response.getValue()).getEntityProfileResponseMsg();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<TransportProtos.GetQueueRoutingInfoResponseMsg> getQueueRoutingInfo(TransportProtos.GetAllQueueRoutingInfoRequestMsg msg) {
        TbProtoQueueMsg protoMsg = new TbProtoQueueMsg(UUID.randomUUID(), (GeneratedMessageV3)TransportProtos.TransportApiRequestMsg.newBuilder().setGetAllQueueRoutingInfoRequestMsg(msg).build());
        try {
            TbProtoQueueMsg response = (TbProtoQueueMsg)this.transportApiRequestTemplate.send((TbQueueMsg)protoMsg).get();
            return ((TransportProtos.TransportApiResponseMsg)response.getValue()).getGetQueueRoutingInfoResponseMsgsList();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public TransportProtos.GetResourceResponseMsg getResource(TransportProtos.GetResourceRequestMsg msg) {
        TbProtoQueueMsg protoMsg = new TbProtoQueueMsg(UUID.randomUUID(), (GeneratedMessageV3)TransportProtos.TransportApiRequestMsg.newBuilder().setResourceRequestMsg(msg).build());
        try {
            TbProtoQueueMsg response = (TbProtoQueueMsg)this.transportApiRequestTemplate.send((TbQueueMsg)protoMsg).get();
            return ((TransportProtos.TransportApiResponseMsg)response.getValue()).getResourceResponseMsg();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public TransportProtos.GetSnmpDevicesResponseMsg getSnmpDevicesIds(TransportProtos.GetSnmpDevicesRequestMsg requestMsg) {
        TbProtoQueueMsg protoMsg = new TbProtoQueueMsg(UUID.randomUUID(), (GeneratedMessageV3)TransportProtos.TransportApiRequestMsg.newBuilder().setSnmpDevicesRequestMsg(requestMsg).build());
        try {
            TbProtoQueueMsg response = (TbProtoQueueMsg)this.transportApiRequestTemplate.send((TbQueueMsg)protoMsg).get();
            return ((TransportProtos.TransportApiResponseMsg)response.getValue()).getSnmpDevicesResponseMsg();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public TransportProtos.GetDeviceResponseMsg getDevice(TransportProtos.GetDeviceRequestMsg requestMsg) {
        TbProtoQueueMsg protoMsg = new TbProtoQueueMsg(UUID.randomUUID(), (GeneratedMessageV3)TransportProtos.TransportApiRequestMsg.newBuilder().setDeviceRequestMsg(requestMsg).build());
        try {
            TransportProtos.TransportApiResponseMsg response = (TransportProtos.TransportApiResponseMsg)((TbProtoQueueMsg)this.transportApiRequestTemplate.send((TbQueueMsg)protoMsg).get()).getValue();
            if (response.hasDeviceResponseMsg()) {
                return response.getDeviceResponseMsg();
            }
            return null;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public TransportProtos.GetDeviceCredentialsResponseMsg getDeviceCredentials(TransportProtos.GetDeviceCredentialsRequestMsg requestMsg) {
        TbProtoQueueMsg protoMsg = new TbProtoQueueMsg(UUID.randomUUID(), (GeneratedMessageV3)TransportProtos.TransportApiRequestMsg.newBuilder().setDeviceCredentialsRequestMsg(requestMsg).build());
        try {
            TbProtoQueueMsg response = (TbProtoQueueMsg)this.transportApiRequestTemplate.send((TbQueueMsg)protoMsg).get();
            return ((TransportProtos.TransportApiResponseMsg)response.getValue()).getDeviceCredentialsResponseMsg();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void process(DeviceTransportType transportType, TransportProtos.ValidateDeviceTokenRequestMsg msg, TransportServiceCallback<ValidateDeviceCredentialsResponse> callback) {
        log.trace("Processing msg: {}", (Object)msg);
        TbProtoQueueMsg protoMsg = new TbProtoQueueMsg(UUID.randomUUID(), (GeneratedMessageV3)TransportProtos.TransportApiRequestMsg.newBuilder().setValidateTokenRequestMsg(msg).build());
        this.doProcess(transportType, (TbProtoQueueMsg<TransportProtos.TransportApiRequestMsg>)protoMsg, callback);
    }

    @Override
    public void process(DeviceTransportType transportType, TransportProtos.ValidateBasicMqttCredRequestMsg msg, TransportServiceCallback<ValidateDeviceCredentialsResponse> callback) {
        log.trace("Processing msg: {}", (Object)msg);
        TbProtoQueueMsg protoMsg = new TbProtoQueueMsg(UUID.randomUUID(), (GeneratedMessageV3)TransportProtos.TransportApiRequestMsg.newBuilder().setValidateBasicMqttCredRequestMsg(msg).build());
        this.doProcess(transportType, (TbProtoQueueMsg<TransportProtos.TransportApiRequestMsg>)protoMsg, callback);
    }

    @Override
    public void process(TransportProtos.ValidateDeviceLwM2MCredentialsRequestMsg requestMsg, TransportServiceCallback<ValidateDeviceCredentialsResponse> callback) {
        log.trace("Processing msg: {}", (Object)requestMsg);
        TbProtoQueueMsg protoMsg = new TbProtoQueueMsg(UUID.randomUUID(), (GeneratedMessageV3)TransportProtos.TransportApiRequestMsg.newBuilder().setValidateDeviceLwM2MCredentialsRequestMsg(requestMsg).build());
        ListenableFuture response = Futures.transform((ListenableFuture)this.transportApiRequestTemplate.send((TbQueueMsg)protoMsg), tmp -> {
            TransportProtos.ValidateDeviceCredentialsResponseMsg msg = ((TransportProtos.TransportApiResponseMsg)tmp.getValue()).getValidateCredResponseMsg();
            ValidateDeviceCredentialsResponse.ValidateDeviceCredentialsResponseBuilder result = ValidateDeviceCredentialsResponse.builder();
            if (msg.hasDeviceInfo()) {
                result.credentials(msg.getCredentialsBody());
                TransportDeviceInfo tdi = this.getTransportDeviceInfo(msg.getDeviceInfo());
                result.deviceInfo(tdi);
                if (msg.hasDeviceProfile()) {
                    DeviceProfile profile = this.deviceProfileCache.getOrCreate(tdi.getDeviceProfileId(), msg.getDeviceProfile());
                    result.deviceProfile(profile);
                }
            }
            return result.build();
        }, (Executor)MoreExecutors.directExecutor());
        AsyncCallbackTemplate.withCallback((ListenableFuture)response, callback::onSuccess, callback::onError, (Executor)this.transportCallbackExecutor);
    }

    @Override
    public void process(DeviceTransportType transportType, TransportProtos.ValidateDeviceX509CertRequestMsg msg, TransportServiceCallback<ValidateDeviceCredentialsResponse> callback) {
        log.trace("Processing msg: {}", (Object)msg);
        TbProtoQueueMsg protoMsg = new TbProtoQueueMsg(UUID.randomUUID(), (GeneratedMessageV3)TransportProtos.TransportApiRequestMsg.newBuilder().setValidateX509CertRequestMsg(msg).build());
        this.doProcess(transportType, (TbProtoQueueMsg<TransportProtos.TransportApiRequestMsg>)protoMsg, callback);
    }

    @Override
    public void process(DeviceTransportType transportType, TransportProtos.ValidateOrCreateDeviceX509CertRequestMsg msg, TransportServiceCallback<ValidateDeviceCredentialsResponse> callback) {
        log.trace("Processing msg: {}", (Object)msg);
        TbProtoQueueMsg protoMsg = new TbProtoQueueMsg(UUID.randomUUID(), (GeneratedMessageV3)TransportProtos.TransportApiRequestMsg.newBuilder().setValidateOrCreateX509CertRequestMsg(msg).build());
        this.doProcess(transportType, (TbProtoQueueMsg<TransportProtos.TransportApiRequestMsg>)protoMsg, callback);
    }

    private void doProcess(DeviceTransportType transportType, TbProtoQueueMsg<TransportProtos.TransportApiRequestMsg> protoMsg, TransportServiceCallback<ValidateDeviceCredentialsResponse> callback) {
        ListenableFuture response = Futures.transform((ListenableFuture)this.transportApiRequestTemplate.send(protoMsg), tmp -> {
            TransportProtos.ValidateDeviceCredentialsResponseMsg msg = ((TransportProtos.TransportApiResponseMsg)tmp.getValue()).getValidateCredResponseMsg();
            ValidateDeviceCredentialsResponse.ValidateDeviceCredentialsResponseBuilder result = ValidateDeviceCredentialsResponse.builder();
            if (msg.hasDeviceInfo()) {
                result.credentials(msg.getCredentialsBody());
                TransportDeviceInfo tdi = this.getTransportDeviceInfo(msg.getDeviceInfo());
                result.deviceInfo(tdi);
                if (msg.hasDeviceProfile()) {
                    DeviceProfile profile = this.deviceProfileCache.getOrCreate(tdi.getDeviceProfileId(), msg.getDeviceProfile());
                    if (transportType != DeviceTransportType.DEFAULT && profile != null && profile.getTransportType() != DeviceTransportType.DEFAULT && profile.getTransportType() != transportType) {
                        log.debug("[{}] Device profile [{}] has different transport type: {}, expected: {}", new Object[]{tdi.getDeviceId(), tdi.getDeviceProfileId(), profile.getTransportType(), transportType});
                        throw new IllegalStateException("Device profile has different transport type: " + profile.getTransportType() + ". Expected: " + transportType);
                    }
                    result.deviceProfile(profile);
                }
            }
            return result.build();
        }, (Executor)MoreExecutors.directExecutor());
        AsyncCallbackTemplate.withCallback((ListenableFuture)response, callback::onSuccess, callback::onError, (Executor)this.transportCallbackExecutor);
    }

    @Override
    public void process(TenantId tenantId, TransportProtos.GetOrCreateDeviceFromGatewayRequestMsg requestMsg, TransportServiceCallback<GetOrCreateDeviceFromGatewayResponse> callback) {
        log.trace("Processing msg: {}", (Object)requestMsg);
        DeviceId gatewayId = new DeviceId(new UUID(requestMsg.getGatewayIdMSB(), requestMsg.getGatewayIdLSB()));
        if (!this.checkLimits(tenantId, gatewayId, null, requestMsg.getDeviceName(), requestMsg, callback, 0, false)) {
            return;
        }
        TbProtoQueueMsg protoMsg = new TbProtoQueueMsg(UUID.randomUUID(), (GeneratedMessageV3)TransportProtos.TransportApiRequestMsg.newBuilder().setGetOrCreateDeviceRequestMsg(requestMsg).build());
        EntityLimitKey key = new EntityLimitKey(tenantId, StringUtils.truncate((String)requestMsg.getDeviceName(), (int)256));
        if (this.entityLimitsCache.get(key)) {
            this.transportCallbackExecutor.submit(() -> callback.onError(new RuntimeException("Maximum number of devices reached!")));
        } else {
            ListenableFuture response = Futures.transform((ListenableFuture)this.transportApiRequestTemplate.send((TbQueueMsg)protoMsg), tmp -> {
                TransportProtos.GetOrCreateDeviceFromGatewayResponseMsg msg = ((TransportProtos.TransportApiResponseMsg)tmp.getValue()).getGetOrCreateDeviceResponseMsg();
                GetOrCreateDeviceFromGatewayResponse.GetOrCreateDeviceFromGatewayResponseBuilder result = GetOrCreateDeviceFromGatewayResponse.builder();
                if (msg.hasDeviceInfo()) {
                    TransportDeviceInfo tdi = this.getTransportDeviceInfo(msg.getDeviceInfo());
                    result.deviceInfo(tdi);
                    if (msg.hasDeviceProfile()) {
                        result.deviceProfile(this.deviceProfileCache.getOrCreate(tdi.getDeviceProfileId(), msg.getDeviceProfile()));
                    }
                } else if (TransportProtos.TransportApiRequestErrorCode.ENTITY_LIMIT.equals((Object)msg.getError())) {
                    this.entityLimitsCache.put(key, true);
                    throw new RuntimeException("Maximum number of devices reached!");
                }
                return result.build();
            }, (Executor)MoreExecutors.directExecutor());
            AsyncCallbackTemplate.withCallback((ListenableFuture)response, callback::onSuccess, callback::onError, (Executor)this.transportCallbackExecutor);
        }
    }

    @Override
    public void process(TransportProtos.LwM2MRequestMsg msg, TransportServiceCallback<TransportProtos.LwM2MResponseMsg> callback) {
        log.trace("Processing msg: {}", (Object)msg);
        TbProtoQueueMsg protoMsg = new TbProtoQueueMsg(UUID.randomUUID(), (GeneratedMessageV3)TransportProtos.TransportApiRequestMsg.newBuilder().setLwM2MRequestMsg(msg).build());
        AsyncCallbackTemplate.withCallback((ListenableFuture)this.transportApiRequestTemplate.send((TbQueueMsg)protoMsg), response -> callback.onSuccess(((TransportProtos.TransportApiResponseMsg)response.getValue()).getLwM2MResponseMsg()), callback::onError, (Executor)this.transportCallbackExecutor);
    }

    private TransportDeviceInfo getTransportDeviceInfo(TransportProtos.DeviceInfoProto di) {
        TransportDeviceInfo tdi = new TransportDeviceInfo();
        tdi.setTenantId(TenantId.fromUUID((UUID)new UUID(di.getTenantIdMSB(), di.getTenantIdLSB())));
        tdi.setCustomerId(new CustomerId(new UUID(di.getCustomerIdMSB(), di.getCustomerIdLSB())));
        tdi.setDeviceId(new DeviceId(new UUID(di.getDeviceIdMSB(), di.getDeviceIdLSB())));
        tdi.setDeviceProfileId(new DeviceProfileId(new UUID(di.getDeviceProfileIdMSB(), di.getDeviceProfileIdLSB())));
        tdi.setAdditionalInfo(di.getAdditionalInfo());
        tdi.setDeviceName(di.getDeviceName());
        tdi.setDeviceType(di.getDeviceType());
        tdi.setGateway(di.getIsGateway());
        if (StringUtils.isNotEmpty((String)di.getPowerMode())) {
            tdi.setPowerMode(PowerMode.valueOf((String)di.getPowerMode()));
            tdi.setEdrxCycle(di.getEdrxCycle());
            tdi.setPsmActivityTimer(di.getPsmActivityTimer());
            tdi.setPagingTransmissionWindow(di.getPagingTransmissionWindow());
        }
        return tdi;
    }

    @Override
    public void process(TransportProtos.ProvisionDeviceRequestMsg requestMsg, TransportServiceCallback<TransportProtos.ProvisionDeviceResponseMsg> callback) {
        log.trace("Processing msg: {}", (Object)requestMsg);
        TbProtoQueueMsg protoMsg = new TbProtoQueueMsg(UUID.randomUUID(), (GeneratedMessageV3)TransportProtos.TransportApiRequestMsg.newBuilder().setProvisionDeviceRequestMsg(requestMsg).build());
        ListenableFuture response = Futures.transform((ListenableFuture)this.transportApiRequestTemplate.send((TbQueueMsg)protoMsg), tmp -> ((TransportProtos.TransportApiResponseMsg)tmp.getValue()).getProvisionDeviceResponseMsg(), (Executor)MoreExecutors.directExecutor());
        AsyncCallbackTemplate.withCallback((ListenableFuture)response, callback::onSuccess, callback::onError, (Executor)this.transportCallbackExecutor);
    }

    @Override
    public void process(TransportProtos.SessionInfoProto sessionInfo, TransportProtos.SubscriptionInfoProto msg, TransportServiceCallback<Void> callback) {
        if (log.isTraceEnabled()) {
            log.trace("[{}] Processing msg: {}", (Object)this.toSessionId(sessionInfo), (Object)msg);
        }
        this.sendToDeviceActor(sessionInfo, TransportProtos.TransportToDeviceActorMsg.newBuilder().setSessionInfo(sessionInfo).setSubscriptionInfo(msg).build(), callback);
    }

    @Override
    public void process(TransportProtos.SessionInfoProto sessionInfo, TransportProtos.SessionEventMsg msg, TransportServiceCallback<Void> callback) {
        if (this.checkLimits(sessionInfo, msg, callback)) {
            this.recordActivityInternal(sessionInfo);
            this.sendToDeviceActor(sessionInfo, TransportProtos.TransportToDeviceActorMsg.newBuilder().setSessionInfo(sessionInfo).setSessionEvent(msg).build(), callback);
        }
    }

    @Override
    public void process(TransportProtos.TransportToDeviceActorMsg msg, TransportServiceCallback<Void> callback) {
        TransportProtos.SessionInfoProto sessionInfo = msg.getSessionInfo();
        if (this.checkLimits(sessionInfo, msg, callback)) {
            SessionMetaData sessionMetaData = (SessionMetaData)this.sessions.get(this.toSessionId(sessionInfo));
            if (sessionMetaData != null) {
                if (msg.hasSubscribeToAttributes()) {
                    sessionMetaData.setSubscribedToAttributes(true);
                }
                if (msg.hasSubscribeToRPC()) {
                    sessionMetaData.setSubscribedToRPC(true);
                }
            }
            this.recordActivityInternal(sessionInfo);
            this.sendToDeviceActor(sessionInfo, msg, callback);
        }
    }

    @Override
    public void process(TransportProtos.SessionInfoProto sessionInfo, TransportProtos.PostTelemetryMsg msg, TransportServiceCallback<Void> callback) {
        this.process(sessionInfo, msg, null, callback);
    }

    @Override
    public void process(TransportProtos.SessionInfoProto sessionInfo, TransportProtos.PostTelemetryMsg msg, TbMsgMetaData md, TransportServiceCallback<Void> callback) {
        int dataPoints = 0;
        for (TransportProtos.TsKvListProto tsKv : msg.getTsKvListList()) {
            dataPoints += tsKv.getKvCount();
        }
        if (this.checkLimits(sessionInfo, msg, callback, dataPoints)) {
            this.recordActivityInternal(sessionInfo);
            TenantId tenantId = this.getTenantId(sessionInfo);
            DeviceId deviceId = new DeviceId(new UUID(sessionInfo.getDeviceIdMSB(), sessionInfo.getDeviceIdLSB()));
            CustomerId customerId = this.getCustomerId(sessionInfo);
            MsgPackCallback packCallback = new MsgPackCallback(msg.getTsKvListCount(), new ApiStatsProxyCallback<Void>(tenantId, customerId, dataPoints, callback));
            for (TransportProtos.TsKvListProto tsKv : msg.getTsKvListList()) {
                TbMsgMetaData metaData = md != null ? md.copy() : new TbMsgMetaData();
                metaData.putValue("deviceName", sessionInfo.getDeviceName());
                metaData.putValue("deviceType", sessionInfo.getDeviceType());
                metaData.putValue("ts", "" + tsKv.getTs());
                JsonObject json = JsonUtils.getJsonObject(tsKv.getKvList());
                this.sendToRuleEngine(tenantId, deviceId, customerId, sessionInfo, json, metaData, TbMsgType.POST_TELEMETRY_REQUEST, packCallback);
            }
        }
    }

    @Override
    public void process(TransportProtos.SessionInfoProto sessionInfo, TransportProtos.PostAttributeMsg msg, TransportServiceCallback<Void> callback) {
        this.process(sessionInfo, msg, null, callback);
    }

    @Override
    public void process(TransportProtos.SessionInfoProto sessionInfo, TransportProtos.PostAttributeMsg msg, TbMsgMetaData md, TransportServiceCallback<Void> callback) {
        if (this.checkLimits(sessionInfo, msg, callback, msg.getKvCount())) {
            this.recordActivityInternal(sessionInfo);
            TenantId tenantId = this.getTenantId(sessionInfo);
            DeviceId deviceId = new DeviceId(new UUID(sessionInfo.getDeviceIdMSB(), sessionInfo.getDeviceIdLSB()));
            JsonObject json = JsonUtils.getJsonObject(msg.getKvList());
            TbMsgMetaData metaData = md != null ? md.copy() : new TbMsgMetaData();
            metaData.putValue("deviceName", sessionInfo.getDeviceName());
            metaData.putValue("deviceType", sessionInfo.getDeviceType());
            if (msg.getShared()) {
                metaData.putValue("scope", "SHARED_SCOPE");
            }
            metaData.putValue("notifyDevice", "false");
            CustomerId customerId = this.getCustomerId(sessionInfo);
            this.sendToRuleEngine(tenantId, deviceId, customerId, sessionInfo, json, metaData, TbMsgType.POST_ATTRIBUTES_REQUEST, new TransportTbQueueCallback(new ApiStatsProxyCallback<Void>(tenantId, customerId, msg.getKvList().size(), callback)));
        }
    }

    @Override
    public void process(TransportProtos.SessionInfoProto sessionInfo, TransportProtos.GetAttributeRequestMsg msg, TransportServiceCallback<Void> callback) {
        if (this.checkLimits(sessionInfo, msg, callback)) {
            this.recordActivityInternal(sessionInfo);
            this.sendToDeviceActor(sessionInfo, TransportProtos.TransportToDeviceActorMsg.newBuilder().setSessionInfo(sessionInfo).setGetAttributes(msg).build(), new ApiStatsProxyCallback<Void>(this.getTenantId(sessionInfo), this.getCustomerId(sessionInfo), 1, callback));
        }
    }

    @Override
    public void process(TransportProtos.SessionInfoProto sessionInfo, TransportProtos.SubscribeToAttributeUpdatesMsg msg, TransportServiceCallback<Void> callback) {
        if (this.checkLimits(sessionInfo, msg, callback)) {
            SessionMetaData sessionMetaData = (SessionMetaData)this.sessions.get(this.toSessionId(sessionInfo));
            if (sessionMetaData != null) {
                sessionMetaData.setSubscribedToAttributes(!msg.getUnsubscribe());
            }
            this.recordActivityInternal(sessionInfo);
            this.sendToDeviceActor(sessionInfo, TransportProtos.TransportToDeviceActorMsg.newBuilder().setSessionInfo(sessionInfo).setSubscribeToAttributes(msg).build(), new ApiStatsProxyCallback<Void>(this.getTenantId(sessionInfo), this.getCustomerId(sessionInfo), 1, callback));
        }
    }

    @Override
    public void process(TransportProtos.SessionInfoProto sessionInfo, TransportProtos.SubscribeToRPCMsg msg, TransportServiceCallback<Void> callback) {
        if (this.checkLimits(sessionInfo, msg, callback)) {
            SessionMetaData sessionMetaData = (SessionMetaData)this.sessions.get(this.toSessionId(sessionInfo));
            if (sessionMetaData != null) {
                sessionMetaData.setSubscribedToRPC(!msg.getUnsubscribe());
            }
            this.recordActivityInternal(sessionInfo);
            this.sendToDeviceActor(sessionInfo, TransportProtos.TransportToDeviceActorMsg.newBuilder().setSessionInfo(sessionInfo).setSubscribeToRPC(msg).build(), new ApiStatsProxyCallback<Void>(this.getTenantId(sessionInfo), this.getCustomerId(sessionInfo), 1, callback));
        }
    }

    @Override
    public void process(TransportProtos.SessionInfoProto sessionInfo, TransportProtos.ToDeviceRpcResponseMsg msg, TransportServiceCallback<Void> callback) {
        if (this.checkLimits(sessionInfo, msg, callback)) {
            this.recordActivityInternal(sessionInfo);
            this.sendToDeviceActor(sessionInfo, TransportProtos.TransportToDeviceActorMsg.newBuilder().setSessionInfo(sessionInfo).setToDeviceRPCCallResponse(msg).build(), new ApiStatsProxyCallback<Void>(this.getTenantId(sessionInfo), this.getCustomerId(sessionInfo), 1, callback));
        }
    }

    @Override
    public void notifyAboutUplink(TransportProtos.SessionInfoProto sessionInfo, TransportProtos.UplinkNotificationMsg msg, TransportServiceCallback<Void> callback) {
        if (this.checkLimits(sessionInfo, msg, callback)) {
            this.recordActivityInternal(sessionInfo);
            this.sendToDeviceActor(sessionInfo, TransportProtos.TransportToDeviceActorMsg.newBuilder().setSessionInfo(sessionInfo).setUplinkNotificationMsg(msg).build(), callback);
        }
    }

    @Override
    public void process(TransportProtos.SessionInfoProto sessionInfo, TransportProtos.ToDeviceRpcRequestMsg msg, RpcStatus rpcStatus, TransportServiceCallback<Void> callback) {
        this.process(sessionInfo, msg, rpcStatus, false, callback);
    }

    @Override
    public void process(TransportProtos.SessionInfoProto sessionInfo, TransportProtos.ToDeviceRpcRequestMsg msg, RpcStatus rpcStatus, boolean reportActivity, TransportServiceCallback<Void> callback) {
        TransportProtos.ToDeviceRpcResponseStatusMsg responseMsg = TransportProtos.ToDeviceRpcResponseStatusMsg.newBuilder().setRequestId(msg.getRequestId()).setRequestIdLSB(msg.getRequestIdLSB()).setRequestIdMSB(msg.getRequestIdMSB()).setStatus(rpcStatus.name()).build();
        if (this.checkLimits(sessionInfo, responseMsg, callback)) {
            if (reportActivity) {
                this.recordActivityInternal(sessionInfo);
            }
            this.sendToDeviceActor(sessionInfo, TransportProtos.TransportToDeviceActorMsg.newBuilder().setSessionInfo(sessionInfo).setRpcResponseStatusMsg(responseMsg).build(), new ApiStatsProxyCallback<Void>(this.getTenantId(sessionInfo), this.getCustomerId(sessionInfo), 1, TransportServiceCallback.EMPTY));
        }
    }

    private void processTimeout(String requestId) {
        RpcRequestMetadata data = this.toServerRpcPendingMap.remove(requestId);
        if (data != null) {
            SessionMetaData md = (SessionMetaData)this.sessions.get(data.getSessionId());
            if (md != null) {
                SessionMsgListener listener = md.getListener();
                this.transportCallbackExecutor.submit(() -> {
                    TransportProtos.ToServerRpcResponseMsg responseMsg = TransportProtos.ToServerRpcResponseMsg.newBuilder().setRequestId(data.getRequestId()).setError("timeout").build();
                    listener.onToServerRpcResponse(responseMsg);
                });
                if (md.getSessionType() == TransportProtos.SessionType.SYNC) {
                    this.deregisterSession(md.getSessionInfo());
                }
            } else {
                log.debug("[{}] Missing session.", (Object)data.getSessionId());
            }
        }
    }

    @Override
    public void process(TransportProtos.SessionInfoProto sessionInfo, TransportProtos.ToServerRpcRequestMsg msg, TransportServiceCallback<Void> callback) {
        if (this.checkLimits(sessionInfo, msg, callback)) {
            this.recordActivityInternal(sessionInfo);
            UUID sessionId = this.toSessionId(sessionInfo);
            TenantId tenantId = this.getTenantId(sessionInfo);
            DeviceId deviceId = this.getDeviceId(sessionInfo);
            JsonObject json = new JsonObject();
            json.addProperty("method", msg.getMethodName());
            json.add("params", JsonUtils.parse(msg.getParams()));
            TbMsgMetaData metaData = new TbMsgMetaData();
            metaData.putValue("deviceName", sessionInfo.getDeviceName());
            metaData.putValue("deviceType", sessionInfo.getDeviceType());
            metaData.putValue("requestId", Integer.toString(msg.getRequestId()));
            metaData.putValue("serviceId", this.serviceInfoProvider.getServiceId());
            metaData.putValue("sessionId", sessionId.toString());
            this.sendToRuleEngine(tenantId, deviceId, this.getCustomerId(sessionInfo), sessionInfo, json, metaData, TbMsgType.TO_SERVER_RPC_REQUEST, new TransportTbQueueCallback(callback));
            String requestId = sessionId + "-" + msg.getRequestId();
            this.toServerRpcPendingMap.put(requestId, new RpcRequestMetadata(sessionId, msg.getRequestId()));
            this.scheduler.schedule(() -> this.processTimeout(requestId), this.clientSideRpcTimeout, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void process(TransportProtos.SessionInfoProto sessionInfo, TransportProtos.ClaimDeviceMsg msg, TransportServiceCallback<Void> callback) {
        if (this.checkLimits(sessionInfo, msg, callback)) {
            this.recordActivityInternal(sessionInfo);
            this.sendToDeviceActor(sessionInfo, TransportProtos.TransportToDeviceActorMsg.newBuilder().setSessionInfo(sessionInfo).setClaimDevice(msg).build(), callback);
        }
    }

    @Override
    public void process(TransportProtos.SessionInfoProto sessionInfo, TransportProtos.GetOtaPackageRequestMsg msg, TransportServiceCallback<TransportProtos.GetOtaPackageResponseMsg> callback) {
        if (this.checkLimits(sessionInfo, msg, callback)) {
            TbProtoQueueMsg protoMsg = new TbProtoQueueMsg(UUID.randomUUID(), (GeneratedMessageV3)TransportProtos.TransportApiRequestMsg.newBuilder().setOtaPackageRequestMsg(msg).build());
            AsyncCallbackTemplate.withCallback((ListenableFuture)this.transportApiRequestTemplate.send((TbQueueMsg)protoMsg), response -> callback.onSuccess(((TransportProtos.TransportApiResponseMsg)response.getValue()).getOtaPackageResponseMsg()), callback::onError, (Executor)this.transportCallbackExecutor);
        }
    }

    @Override
    public void recordActivity(TransportProtos.SessionInfoProto sessionInfo) {
        this.recordActivityInternal(sessionInfo);
    }

    private void recordActivityInternal(TransportProtos.SessionInfoProto sessionInfo) {
        this.onActivity(this.toSessionId(sessionInfo), sessionInfo, this.getCurrentTimeMillis());
    }

    @Override
    public void lifecycleEvent(TenantId tenantId, DeviceId deviceId, ComponentLifecycleEvent eventType, boolean success, Throwable error) {
        TransportProtos.ToCoreMsg msg = TransportProtos.ToCoreMsg.newBuilder().setLifecycleEventMsg(TransportProtos.LifecycleEventProto.newBuilder().setTenantIdMSB(tenantId.getId().getMostSignificantBits()).setTenantIdLSB(tenantId.getId().getLeastSignificantBits()).setEntityIdMSB(deviceId.getId().getMostSignificantBits()).setEntityIdLSB(deviceId.getId().getLeastSignificantBits()).setServiceId(this.serviceInfoProvider.getServiceId()).setLcEventType(eventType.name()).setSuccess(success).setError(error != null ? ExceptionUtils.getStackTrace((Throwable)error) : "")).build();
        try {
            this.sendToCore(tenantId, (EntityId)deviceId, msg, deviceId.getId(), TransportServiceCallback.EMPTY);
        }
        catch (Exception e) {
            log.error("[{}][{}] Failed to send lifecycle event to core", new Object[]{tenantId, deviceId, e});
        }
    }

    @Override
    public void errorEvent(TenantId tenantId, DeviceId deviceId, String method, Throwable error) {
        TransportProtos.ToCoreMsg msg = TransportProtos.ToCoreMsg.newBuilder().setErrorEventMsg(TransportProtos.ErrorEventProto.newBuilder().setTenantIdMSB(tenantId.getId().getMostSignificantBits()).setTenantIdLSB(tenantId.getId().getLeastSignificantBits()).setEntityIdMSB(deviceId.getId().getMostSignificantBits()).setEntityIdLSB(deviceId.getId().getLeastSignificantBits()).setServiceId(this.serviceInfoProvider.getServiceId()).setMethod(method).setError(ExceptionUtils.getRootCauseMessage((Throwable)error))).build();
        try {
            this.sendToCore(tenantId, (EntityId)deviceId, msg, deviceId.getId(), TransportServiceCallback.EMPTY);
        }
        catch (Exception e) {
            log.error("[{}][{}] Failed to send error event to core", new Object[]{tenantId, deviceId, e});
        }
    }

    @Override
    public SessionMetaData registerSyncSession(TransportProtos.SessionInfoProto sessionInfo, SessionMsgListener listener, long timeout) {
        SessionMetaData currentSession = new SessionMetaData(sessionInfo, TransportProtos.SessionType.SYNC, listener);
        UUID sessionId = this.toSessionId(sessionInfo);
        this.sessions.putIfAbsent(sessionId, currentSession);
        TransportProtos.SessionCloseNotificationProto notification = TransportProtos.SessionCloseNotificationProto.newBuilder().setMessage("session timeout!").build();
        ScheduledFuture executorFuture = this.scheduler.schedule(() -> {
            listener.onRemoteSessionCloseCommand(sessionId, notification);
            this.deregisterSession(sessionInfo);
        }, timeout, TimeUnit.MILLISECONDS);
        currentSession.setScheduledFuture(executorFuture);
        return currentSession;
    }

    @Override
    public void deregisterSession(TransportProtos.SessionInfoProto sessionInfo) {
        SessionMetaData currentSession = (SessionMetaData)this.sessions.get(this.toSessionId(sessionInfo));
        if (currentSession != null && currentSession.hasScheduledFuture()) {
            log.debug("Stopping scheduler to avoid resending response if request has been ack.");
            currentSession.getScheduledFuture().cancel(false);
        }
        this.sessions.remove(this.toSessionId(sessionInfo));
    }

    @Override
    public void log(TransportProtos.SessionInfoProto sessionInfo, String msg) {
        if (!this.logEnabled || sessionInfo == null || StringUtils.isEmpty((String)msg)) {
            return;
        }
        if (msg.length() > this.logMaxLength) {
            msg = msg.substring(0, this.logMaxLength);
        }
        TransportProtos.PostTelemetryMsg.Builder request = TransportProtos.PostTelemetryMsg.newBuilder();
        TransportProtos.TsKvListProto.Builder builder = TransportProtos.TsKvListProto.newBuilder();
        builder.setTs(TimeUnit.MILLISECONDS.toSeconds(this.getCurrentTimeMillis()) * 1000L + (long)(this.atomicTs.getAndIncrement() % 1000));
        builder.addKv(TransportProtos.KeyValueProto.newBuilder().setKey("transportLog").setType(TransportProtos.KeyValueType.STRING_V).setStringV(msg).build());
        request.addTsKvList(builder.build());
        TransportProtos.PostTelemetryMsg postTelemetryMsg = request.build();
        this.process(sessionInfo, postTelemetryMsg, TransportServiceCallback.EMPTY);
    }

    private boolean checkLimits(TransportProtos.SessionInfoProto sessionInfo, Object msg, TransportServiceCallback<?> callback) {
        return this.checkLimits(sessionInfo, msg, callback, 0);
    }

    private boolean checkLimits(TransportProtos.SessionInfoProto sessionInfo, Object msg, TransportServiceCallback<?> callback, int dataPoints) {
        if (log.isTraceEnabled()) {
            log.trace("[{}] Processing msg: {}", (Object)this.toSessionId(sessionInfo), msg);
        }
        TenantId tenantId = TenantId.fromUUID((UUID)new UUID(sessionInfo.getTenantIdMSB(), sessionInfo.getTenantIdLSB()));
        DeviceId deviceId = new DeviceId(new UUID(sessionInfo.getDeviceIdMSB(), sessionInfo.getDeviceIdLSB()));
        DeviceId gatewayId = null;
        if (sessionInfo.hasGatewayIdMSB() && sessionInfo.hasGatewayIdLSB()) {
            gatewayId = new DeviceId(new UUID(sessionInfo.getGatewayIdMSB(), sessionInfo.getGatewayIdLSB()));
        }
        return this.checkLimits(tenantId, gatewayId, deviceId, sessionInfo.getDeviceName(), msg, callback, dataPoints, sessionInfo.getIsGateway());
    }

    private boolean checkLimits(TenantId tenantId, DeviceId gatewayId, DeviceId deviceId, String deviceName, Object msg, TransportServiceCallback<?> callback, int dataPoints, boolean isGateway) {
        TbPair<EntityType, Boolean> rateLimitedPair;
        if (log.isTraceEnabled()) {
            log.trace("[{}][{}] Processing msg: {}", new Object[]{tenantId, deviceName, msg});
        }
        if ((rateLimitedPair = this.rateLimitService.checkLimits(tenantId, gatewayId, deviceId, dataPoints, isGateway)) == null) {
            return true;
        }
        EntityType rateLimitedEntityType = (EntityType)rateLimitedPair.getFirst();
        if (callback != null) {
            callback.onError((Throwable)new TbRateLimitsException(rateLimitedEntityType));
        }
        if (rateLimitedEntityType == EntityType.DEVICE || rateLimitedEntityType == EntityType.TENANT) {
            LimitedApi limitedApi = rateLimitedEntityType == EntityType.TENANT ? LimitedApi.TRANSPORT_MESSAGES_PER_TENANT : ((Boolean)rateLimitedPair.getSecond() != false ? (isGateway ? LimitedApi.TRANSPORT_MESSAGES_PER_GATEWAY_DEVICE : LimitedApi.TRANSPORT_MESSAGES_PER_GATEWAY) : LimitedApi.TRANSPORT_MESSAGES_PER_DEVICE);
            TenantId limitLevel = rateLimitedEntityType == EntityType.DEVICE ? (deviceId == null ? gatewayId : deviceId) : tenantId;
            this.notificationRuleProcessor.process((NotificationRuleTrigger)RateLimitsTrigger.builder().tenantId(tenantId).api(limitedApi).limitLevel((EntityId)limitLevel).limitLevelEntityName(rateLimitedEntityType == EntityType.DEVICE ? deviceName : null).build());
        }
        return false;
    }

    protected void processToTransportMsg(TransportProtos.ToTransportMsg toSessionMsg) {
        UUID sessionId = new UUID(toSessionMsg.getSessionIdMSB(), toSessionMsg.getSessionIdLSB());
        SessionMetaData md = (SessionMetaData)this.sessions.get(sessionId);
        if (md != null) {
            log.trace("[{}] Processing notification: {}", (Object)sessionId, (Object)toSessionMsg);
            SessionMsgListener listener = md.getListener();
            this.transportCallbackExecutor.submit(() -> {
                if (toSessionMsg.hasGetAttributesResponse()) {
                    listener.onGetAttributesResponse(toSessionMsg.getGetAttributesResponse());
                }
                if (toSessionMsg.hasAttributeUpdateNotification()) {
                    listener.onAttributeUpdate(sessionId, toSessionMsg.getAttributeUpdateNotification());
                }
                if (toSessionMsg.hasSessionCloseNotification()) {
                    listener.onRemoteSessionCloseCommand(sessionId, toSessionMsg.getSessionCloseNotification());
                }
                if (toSessionMsg.hasToTransportUpdateCredentialsNotification()) {
                    listener.onToTransportUpdateCredentials(toSessionMsg.getToTransportUpdateCredentialsNotification());
                }
                if (toSessionMsg.hasToDeviceRequest()) {
                    listener.onToDeviceRpcRequest(sessionId, toSessionMsg.getToDeviceRequest());
                }
                if (toSessionMsg.hasToServerResponse()) {
                    String requestId = sessionId + "-" + toSessionMsg.getToServerResponse().getRequestId();
                    this.toServerRpcPendingMap.remove(requestId);
                    listener.onToServerRpcResponse(toSessionMsg.getToServerResponse());
                }
            });
            if (md.getSessionType() == TransportProtos.SessionType.SYNC) {
                this.deregisterSession(md.getSessionInfo());
            }
        } else {
            log.trace("Processing broadcast notification: {}", (Object)toSessionMsg);
            if (toSessionMsg.hasEntityUpdateMsg()) {
                this.onEntityUpdate(toSessionMsg.getEntityUpdateMsg());
            } else if (toSessionMsg.hasEntityDeleteMsg()) {
                TransportProtos.EntityDeleteMsg msg = toSessionMsg.getEntityDeleteMsg();
                EntityType entityType = EntityType.valueOf((String)msg.getEntityType());
                UUID entityUuid = new UUID(msg.getEntityIdMSB(), msg.getEntityIdLSB());
                if (EntityType.DEVICE_PROFILE.equals((Object)entityType)) {
                    this.deviceProfileCache.evict(new DeviceProfileId(new UUID(msg.getEntityIdMSB(), msg.getEntityIdLSB())));
                } else if (EntityType.TENANT_PROFILE.equals((Object)entityType)) {
                    this.tenantProfileCache.remove(new TenantProfileId(entityUuid));
                } else if (EntityType.TENANT.equals((Object)entityType)) {
                    TenantId tenantId = TenantId.fromUUID((UUID)entityUuid);
                    this.rateLimitService.remove(tenantId);
                    this.partitionService.removeTenant(tenantId);
                } else if (EntityType.DEVICE.equals((Object)entityType)) {
                    this.rateLimitService.remove(new DeviceId(entityUuid));
                    this.onDeviceDeleted(new DeviceId(entityUuid));
                }
            } else if (toSessionMsg.hasResourceUpdateMsg()) {
                TransportProtos.ResourceUpdateMsg msg = toSessionMsg.getResourceUpdateMsg();
                TenantId tenantId = TenantId.fromUUID((UUID)new UUID(msg.getTenantIdMSB(), msg.getTenantIdLSB()));
                ResourceType resourceType = ResourceType.valueOf((String)msg.getResourceType());
                String resourceId = msg.getResourceKey();
                this.transportResourceCache.update(tenantId, resourceType, resourceId);
                this.sessions.forEach((id, mdRez) -> {
                    log.trace("ResourceUpdate - [{}] [{}]", id, mdRez);
                    this.transportCallbackExecutor.submit(() -> mdRez.getListener().onResourceUpdate(msg));
                });
            } else if (toSessionMsg.hasResourceDeleteMsg()) {
                TransportProtos.ResourceDeleteMsg msg = toSessionMsg.getResourceDeleteMsg();
                TenantId tenantId = TenantId.fromUUID((UUID)new UUID(msg.getTenantIdMSB(), msg.getTenantIdLSB()));
                ResourceType resourceType = ResourceType.valueOf((String)msg.getResourceType());
                String resourceId = msg.getResourceKey();
                this.transportResourceCache.evict(tenantId, resourceType, resourceId);
                this.sessions.forEach((id, mdRez) -> {
                    log.trace("ResourceDelete - [{}] [{}]", id, mdRez);
                    this.transportCallbackExecutor.submit(() -> mdRez.getListener().onResourceDelete(msg));
                });
            } else if (toSessionMsg.getQueueUpdateMsgsCount() > 0) {
                this.partitionService.updateQueues(toSessionMsg.getQueueUpdateMsgsList());
            } else if (toSessionMsg.getQueueDeleteMsgsCount() > 0) {
                this.partitionService.removeQueues(toSessionMsg.getQueueDeleteMsgsList());
            } else {
                log.debug("[{}] Missing session.", (Object)sessionId);
            }
        }
    }

    @Override
    public void onProfileUpdate(DeviceProfile deviceProfile) {
        long deviceProfileIdMSB = deviceProfile.getId().getId().getMostSignificantBits();
        long deviceProfileIdLSB = deviceProfile.getId().getId().getLeastSignificantBits();
        this.sessions.forEach((id, md) -> {
            if (md.getSessionInfo().getDeviceProfileIdMSB() == deviceProfileIdMSB && md.getSessionInfo().getDeviceProfileIdLSB() == deviceProfileIdLSB) {
                TransportProtos.SessionInfoProto newSessionInfo = TransportProtos.SessionInfoProto.newBuilder().mergeFrom(md.getSessionInfo()).setDeviceProfileIdMSB(deviceProfileIdMSB).setDeviceProfileIdLSB(deviceProfileIdLSB).setDeviceType(deviceProfile.getName()).build();
                md.setSessionInfo(newSessionInfo);
                this.transportCallbackExecutor.submit(() -> md.getListener().onDeviceProfileUpdate(newSessionInfo, deviceProfile));
            }
        });
        this.eventPublisher.publishEvent((ApplicationEvent)new DeviceProfileUpdatedEvent(deviceProfile));
    }

    private void onEntityUpdate(TransportProtos.EntityUpdateMsg msg) {
        switch (msg.getEntityUpdateCase()) {
            case DEVICEPROFILE: {
                DeviceProfile deviceProfile = this.deviceProfileCache.put(msg.getDeviceProfile());
                log.debug("On device profile update: {}", (Object)deviceProfile);
                this.onProfileUpdate(deviceProfile);
                break;
            }
            case TENANTPROFILE: {
                this.rateLimitService.update(this.tenantProfileCache.put(msg.getTenantProfile()));
                break;
            }
            case TENANT: {
                Tenant tenant = ProtoUtils.fromProto((TransportProtos.TenantProto)msg.getTenant());
                boolean updated = this.tenantProfileCache.put(tenant.getId(), tenant.getTenantProfileId());
                this.partitionService.evictTenantInfo(tenant.getId());
                if (!updated) break;
                this.rateLimitService.update(tenant.getId());
                break;
            }
            case APIUSAGESTATE: {
                ApiUsageState apiUsageState = ProtoUtils.fromProto((TransportProtos.ApiUsageStateProto)msg.getApiUsageState());
                this.rateLimitService.update(apiUsageState.getTenantId(), apiUsageState.isTransportEnabled());
                break;
            }
            case DEVICE: {
                this.onDeviceUpdate(ProtoUtils.fromProto((TransportProtos.DeviceProto)msg.getDevice()));
                break;
            }
            default: {
                log.warn("UNKNOWN entity update type: [{}]", (Object)msg.getEntityUpdateCase());
            }
        }
    }

    private void onDeviceUpdate(Device device) {
        long deviceIdMSB = device.getId().getId().getMostSignificantBits();
        long deviceIdLSB = device.getId().getId().getLeastSignificantBits();
        long deviceProfileIdMSB = device.getDeviceProfileId().getId().getMostSignificantBits();
        long deviceProfileIdLSB = device.getDeviceProfileId().getId().getLeastSignificantBits();
        this.sessions.forEach((id, md) -> {
            if (md.getSessionInfo().getDeviceIdMSB() == deviceIdMSB && md.getSessionInfo().getDeviceIdLSB() == deviceIdLSB) {
                DeviceProfile newDeviceProfile = md.getSessionInfo().getDeviceProfileIdMSB() != deviceProfileIdMSB || md.getSessionInfo().getDeviceProfileIdLSB() != deviceProfileIdLSB ? this.deviceProfileCache.get(new DeviceProfileId(new UUID(deviceProfileIdMSB, deviceProfileIdLSB))) : null;
                JsonNode deviceAdditionalInfo = device.getAdditionalInfo();
                boolean isGateway = deviceAdditionalInfo.has("gateway") && deviceAdditionalInfo.get("gateway").asBoolean();
                TransportProtos.SessionInfoProto newSessionInfo = TransportProtos.SessionInfoProto.newBuilder().mergeFrom(md.getSessionInfo()).setDeviceProfileIdMSB(deviceProfileIdMSB).setDeviceProfileIdLSB(deviceProfileIdLSB).setDeviceName(device.getName()).setDeviceType(device.getType()).setIsGateway(isGateway).build();
                if (isGateway && deviceAdditionalInfo.has("overwriteActivityTime") && deviceAdditionalInfo.get("overwriteActivityTime").isBoolean()) {
                    md.setOverwriteActivityTime(deviceAdditionalInfo.get("overwriteActivityTime").asBoolean());
                }
                md.setSessionInfo(newSessionInfo);
                this.transportCallbackExecutor.submit(() -> md.getListener().onDeviceUpdate(newSessionInfo, device, Optional.ofNullable(newDeviceProfile)));
            }
        });
        this.eventPublisher.publishEvent((Object)new DeviceUpdatedEvent(device));
    }

    private void onDeviceDeleted(DeviceId deviceId) {
        this.sessions.forEach((id, md) -> {
            DeviceId sessionDeviceId = new DeviceId(new UUID(md.getSessionInfo().getDeviceIdMSB(), md.getSessionInfo().getDeviceIdLSB()));
            if (sessionDeviceId.equals((Object)deviceId)) {
                this.transportCallbackExecutor.submit(() -> md.getListener().onDeviceDeleted(deviceId));
            }
        });
        this.eventPublisher.publishEvent((ApplicationEvent)new DeviceDeletedEvent(deviceId));
    }

    protected UUID toSessionId(TransportProtos.SessionInfoProto sessionInfo) {
        return new UUID(sessionInfo.getSessionIdMSB(), sessionInfo.getSessionIdLSB());
    }

    protected UUID getRoutingKey(TransportProtos.SessionInfoProto sessionInfo) {
        return new UUID(sessionInfo.getDeviceIdMSB(), sessionInfo.getDeviceIdLSB());
    }

    protected TenantId getTenantId(TransportProtos.SessionInfoProto sessionInfo) {
        return TenantId.fromUUID((UUID)new UUID(sessionInfo.getTenantIdMSB(), sessionInfo.getTenantIdLSB()));
    }

    protected CustomerId getCustomerId(TransportProtos.SessionInfoProto sessionInfo) {
        long msb = sessionInfo.getCustomerIdMSB();
        long lsb = sessionInfo.getCustomerIdLSB();
        if (msb != 0L && lsb != 0L) {
            return new CustomerId(new UUID(msb, lsb));
        }
        return new CustomerId(EntityId.NULL_UUID);
    }

    protected DeviceId getDeviceId(TransportProtos.SessionInfoProto sessionInfo) {
        return new DeviceId(new UUID(sessionInfo.getDeviceIdMSB(), sessionInfo.getDeviceIdLSB()));
    }

    protected void sendToDeviceActor(TransportProtos.SessionInfoProto sessionInfo, TransportProtos.TransportToDeviceActorMsg toDeviceActorMsg, TransportServiceCallback<Void> callback) {
        TransportProtos.ToCoreMsg toCoreMsg = TransportProtos.ToCoreMsg.newBuilder().setToDeviceActorMsg(toDeviceActorMsg).build();
        this.sendToCore(this.getTenantId(sessionInfo), (EntityId)this.getDeviceId(sessionInfo), toCoreMsg, this.getRoutingKey(sessionInfo), callback);
    }

    private void sendToCore(TenantId tenantId, EntityId entityId, TransportProtos.ToCoreMsg msg, UUID routingKey, TransportServiceCallback<Void> callback) {
        TopicPartitionInfo tpi = this.partitionService.resolve(ServiceType.TB_CORE, tenantId, entityId);
        if (log.isTraceEnabled()) {
            log.trace("[{}][{}] Pushing to topic {} message {}", new Object[]{tenantId, entityId, tpi.getFullTopicName(), msg});
        }
        TransportTbQueueCallback transportTbQueueCallback = callback != null ? new TransportTbQueueCallback(callback) : null;
        this.tbCoreProducerStats.incrementTotal();
        StatsCallback wrappedCallback = new StatsCallback(transportTbQueueCallback, this.tbCoreProducerStats);
        this.tbCoreMsgProducer.send(tpi, (TbQueueMsg)new TbProtoQueueMsg(routingKey, (GeneratedMessageV3)msg), (TbQueueCallback)wrappedCallback);
    }

    private void sendToRuleEngine(TenantId tenantId, DeviceId deviceId, CustomerId customerId, TransportProtos.SessionInfoProto sessionInfo, JsonObject json, TbMsgMetaData metaData, TbMsgType tbMsgType, TbQueueCallback callback) {
        String queueName;
        RuleChainId ruleChainId;
        DeviceProfileId deviceProfileId = new DeviceProfileId(new UUID(sessionInfo.getDeviceProfileIdMSB(), sessionInfo.getDeviceProfileIdLSB()));
        DeviceProfile deviceProfile = this.deviceProfileCache.get(deviceProfileId);
        if (deviceProfile == null) {
            log.warn("[{}] Device profile is null!", (Object)deviceProfileId);
            ruleChainId = null;
            queueName = null;
        } else {
            ruleChainId = deviceProfile.getDefaultRuleChainId();
            queueName = deviceProfile.getDefaultQueueName();
        }
        TbMsg tbMsg = TbMsg.newMsg((String)queueName, (TbMsgType)tbMsgType, (EntityId)deviceId, (CustomerId)customerId, (TbMsgMetaData)metaData, (String)this.gson.toJson((JsonElement)json), (RuleChainId)ruleChainId, null);
        this.ruleEngineProducerService.sendToRuleEngine(this.ruleEngineMsgProducer, tenantId, tbMsg, (TbQueueCallback)new StatsCallback(callback, this.ruleEngineProducerStats));
        this.ruleEngineProducerStats.incrementTotal();
    }

    @Override
    public ExecutorService getCallbackExecutor() {
        return this.transportCallbackExecutor;
    }

    @Override
    public boolean hasSession(TransportProtos.SessionInfoProto sessionInfo) {
        return this.sessions.containsKey(this.toSessionId(sessionInfo));
    }

    @Override
    public void createGaugeStats(String statsName, AtomicInteger number) {
        this.statsFactory.createGauge(StatsType.TRANSPORT + "." + statsName, (Number)number, new String[0]);
        this.statsMap.put(statsName, number);
    }

    @Scheduled(fixedDelayString="${transport.stats.print-interval-ms:60000}")
    public void printStats() {
        if (this.statsEnabled && !this.statsMap.isEmpty()) {
            String values = this.statsMap.entrySet().stream().map(kv -> (String)kv.getKey() + " [" + kv.getValue() + "]").collect(Collectors.joining(", "));
            log.info("Transport Stats: {}", (Object)values);
        }
    }

    @ConstructorProperties(value={"partitionService", "queueProvider", "producerProvider", "ruleEngineProducerService", "topicService", "serviceInfoProvider", "statsFactory", "deviceProfileCache", "tenantProfileCache", "rateLimitService", "scheduler", "eventPublisher", "transportResourceCache", "notificationRuleProcessor", "entityLimitsCache"})
    public DefaultTransportService(PartitionService partitionService, TbTransportQueueFactory queueProvider, TbQueueProducerProvider producerProvider, TbRuleEngineProducerService ruleEngineProducerService, TopicService topicService, TbServiceInfoProvider serviceInfoProvider, StatsFactory statsFactory, TransportDeviceProfileCache deviceProfileCache, TransportTenantProfileCache tenantProfileCache, TransportRateLimitService rateLimitService, SchedulerComponent scheduler, ApplicationEventPublisher eventPublisher, TransportResourceCache transportResourceCache, NotificationRuleProcessor notificationRuleProcessor, EntityLimitsCache entityLimitsCache) {
        this.partitionService = partitionService;
        this.queueProvider = queueProvider;
        this.producerProvider = producerProvider;
        this.ruleEngineProducerService = ruleEngineProducerService;
        this.topicService = topicService;
        this.serviceInfoProvider = serviceInfoProvider;
        this.statsFactory = statsFactory;
        this.deviceProfileCache = deviceProfileCache;
        this.tenantProfileCache = tenantProfileCache;
        this.rateLimitService = rateLimitService;
        this.scheduler = scheduler;
        this.eventPublisher = eventPublisher;
        this.transportResourceCache = transportResourceCache;
        this.notificationRuleProcessor = notificationRuleProcessor;
        this.entityLimitsCache = entityLimitsCache;
    }

    private class MsgPackCallback
    implements TbQueueCallback {
        private final AtomicInteger msgCount;
        private final TransportServiceCallback<Void> callback;

        public MsgPackCallback(Integer msgCount, TransportServiceCallback<Void> callback) {
            this.msgCount = new AtomicInteger(msgCount);
            this.callback = callback;
        }

        public void onSuccess(TbQueueMsgMetadata metadata) {
            if (this.msgCount.decrementAndGet() <= 0) {
                DefaultTransportService.this.transportCallbackExecutor.submit(() -> this.callback.onSuccess(null));
            }
        }

        public void onFailure(Throwable t) {
            DefaultTransportService.this.transportCallbackExecutor.submit(() -> this.callback.onError(t));
        }
    }

    private class ApiStatsProxyCallback<T>
    implements TransportServiceCallback<T> {
        private final TenantId tenantId;
        private final CustomerId customerId;
        private final int dataPoints;
        private final TransportServiceCallback<T> callback;

        public ApiStatsProxyCallback(TenantId tenantId, CustomerId customerId, int dataPoints, TransportServiceCallback<T> callback) {
            this.tenantId = tenantId;
            this.customerId = customerId;
            this.dataPoints = dataPoints;
            this.callback = callback;
        }

        @Override
        public void onSuccess(T msg) {
            try {
                DefaultTransportService.this.apiUsageClient.report(this.tenantId, this.customerId, ApiUsageRecordKey.TRANSPORT_MSG_COUNT, 1L);
                DefaultTransportService.this.apiUsageClient.report(this.tenantId, this.customerId, ApiUsageRecordKey.TRANSPORT_DP_COUNT, (long)this.dataPoints);
            }
            finally {
                this.callback.onSuccess(msg);
            }
        }

        @Override
        public void onError(Throwable e) {
            this.callback.onError(e);
        }
    }

    private class TransportTbQueueCallback
    implements TbQueueCallback {
        private final TransportServiceCallback<Void> callback;

        private TransportTbQueueCallback(TransportServiceCallback<Void> callback) {
            this.callback = callback;
        }

        public void onSuccess(TbQueueMsgMetadata metadata) {
            DefaultTransportService.this.transportCallbackExecutor.submit(() -> this.callback.onSuccess(null));
        }

        public void onFailure(Throwable t) {
            DefaultTransportService.this.transportCallbackExecutor.submit(() -> this.callback.onError(t));
        }
    }

    private static class StatsCallback
    implements TbQueueCallback {
        private final TbQueueCallback callback;
        private final MessagesStats stats;

        private StatsCallback(TbQueueCallback callback, MessagesStats stats) {
            this.callback = callback;
            this.stats = stats;
        }

        public void onSuccess(TbQueueMsgMetadata metadata) {
            this.stats.incrementSuccessful();
            if (this.callback != null) {
                this.callback.onSuccess(metadata);
            }
        }

        public void onFailure(Throwable t) {
            this.stats.incrementFailed();
            if (this.callback != null) {
                this.callback.onFailure(t);
            }
        }
    }
}

