/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.transport.service;

import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.ResourceType;
import org.thingsboard.server.common.data.TbResource;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.transport.TransportResourceCache;
import org.thingsboard.server.common.transport.TransportService;
import org.thingsboard.server.common.util.ProtoUtils;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.util.TbTransportComponent;

@Component
@TbTransportComponent
public class DefaultTransportResourceCache
implements TransportResourceCache {
    private static final Logger log = LoggerFactory.getLogger(DefaultTransportResourceCache.class);
    private final Lock resourceFetchLock = new ReentrantLock();
    private final ConcurrentMap<ResourceCompositeKey, TbResource> resources = new ConcurrentHashMap<ResourceCompositeKey, TbResource>();
    private final Set<ResourceCompositeKey> keys = ConcurrentHashMap.newKeySet();
    @Lazy
    private final TransportService transportService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<TbResource> get(TenantId tenantId, ResourceType resourceType, String resourceKey) {
        TbResource resource;
        ResourceCompositeKey compositeKey = new ResourceCompositeKey(tenantId, resourceType, resourceKey);
        if (this.keys.contains(compositeKey)) {
            resource = (TbResource)this.resources.get(compositeKey);
            if (resource == null) {
                resource = (TbResource)this.resources.get(compositeKey.getSystemKey());
            }
        } else {
            this.resourceFetchLock.lock();
            try {
                if (this.keys.contains(compositeKey)) {
                    resource = (TbResource)this.resources.get(compositeKey);
                    if (resource == null) {
                        resource = (TbResource)this.resources.get(compositeKey.getSystemKey());
                    }
                } else {
                    resource = this.fetchResource(compositeKey);
                    this.keys.add(compositeKey);
                }
            }
            finally {
                this.resourceFetchLock.unlock();
            }
        }
        return Optional.ofNullable(resource);
    }

    private TbResource fetchResource(ResourceCompositeKey compositeKey) {
        UUID tenantId = compositeKey.getTenantId().getId();
        TransportProtos.GetResourceRequestMsg.Builder builder = TransportProtos.GetResourceRequestMsg.newBuilder();
        builder.setTenantIdLSB(tenantId.getLeastSignificantBits()).setTenantIdMSB(tenantId.getMostSignificantBits()).setResourceType(compositeKey.resourceType.name()).setResourceKey(compositeKey.resourceKey);
        TransportProtos.GetResourceResponseMsg responseMsg = this.transportService.getResource(builder.build());
        if (responseMsg.hasResource()) {
            TbResource resource = ProtoUtils.fromProto((TransportProtos.TbResourceProto)responseMsg.getResource());
            this.resources.put(new ResourceCompositeKey(resource.getTenantId(), resource.getResourceType(), resource.getResourceKey()), resource);
            return resource;
        }
        return null;
    }

    @Override
    public void update(TenantId tenantId, ResourceType resourceType, String resourceKey) {
        ResourceCompositeKey compositeKey = new ResourceCompositeKey(tenantId, resourceType, resourceKey);
        if (this.keys.contains(compositeKey) || this.resources.containsKey(compositeKey)) {
            this.fetchResource(compositeKey);
        }
    }

    @Override
    public void evict(TenantId tenantId, ResourceType resourceType, String resourceKey) {
        ResourceCompositeKey compositeKey = new ResourceCompositeKey(tenantId, resourceType, resourceKey);
        this.keys.remove(compositeKey);
        this.resources.remove(compositeKey);
    }

    @ConstructorProperties(value={"transportService"})
    public DefaultTransportResourceCache(@Lazy TransportService transportService) {
        this.transportService = transportService;
    }

    private static class ResourceCompositeKey {
        private final TenantId tenantId;
        private final ResourceType resourceType;
        private final String resourceKey;

        public ResourceCompositeKey getSystemKey() {
            return new ResourceCompositeKey(TenantId.SYS_TENANT_ID, this.resourceType, this.resourceKey);
        }

        @ConstructorProperties(value={"tenantId", "resourceType", "resourceKey"})
        public ResourceCompositeKey(TenantId tenantId, ResourceType resourceType, String resourceKey) {
            this.tenantId = tenantId;
            this.resourceType = resourceType;
            this.resourceKey = resourceKey;
        }

        public TenantId getTenantId() {
            return this.tenantId;
        }

        public ResourceType getResourceType() {
            return this.resourceType;
        }

        public String getResourceKey() {
            return this.resourceKey;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResourceCompositeKey)) {
                return false;
            }
            ResourceCompositeKey other = (ResourceCompositeKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            TenantId this$tenantId = this.getTenantId();
            TenantId other$tenantId = other.getTenantId();
            if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
                return false;
            }
            ResourceType this$resourceType = this.getResourceType();
            ResourceType other$resourceType = other.getResourceType();
            if (this$resourceType == null ? other$resourceType != null : !this$resourceType.equals(other$resourceType)) {
                return false;
            }
            String this$resourceKey = this.getResourceKey();
            String other$resourceKey = other.getResourceKey();
            return !(this$resourceKey == null ? other$resourceKey != null : !this$resourceKey.equals(other$resourceKey));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ResourceCompositeKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            TenantId $tenantId = this.getTenantId();
            result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
            ResourceType $resourceType = this.getResourceType();
            result = result * 59 + ($resourceType == null ? 43 : $resourceType.hashCode());
            String $resourceKey = this.getResourceKey();
            result = result * 59 + ($resourceKey == null ? 43 : $resourceKey.hashCode());
            return result;
        }

        public String toString() {
            return "DefaultTransportResourceCache.ResourceCompositeKey(tenantId=" + this.getTenantId() + ", resourceType=" + this.getResourceType() + ", resourceKey=" + this.getResourceKey() + ")";
        }
    }
}

