/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.transport.config.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import org.thingsboard.server.common.data.ResourceUtils;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.transport.config.ssl.AbstractSslCredentials;

public class KeystoreSslCredentials
extends AbstractSslCredentials {
    private String type;
    private String storeFile;
    private String storePassword;
    private String keyPassword;
    private String keyAlias;

    @Override
    protected boolean canUse() {
        return ResourceUtils.resourceExists((Object)this, (String)this.storeFile);
    }

    @Override
    protected KeyStore loadKeyStore(boolean trustsOnly, char[] keyPasswordArray) throws IOException, GeneralSecurityException {
        String keyStoreType = StringUtils.isEmpty((String)this.type) ? KeyStore.getDefaultType() : this.type;
        KeyStore keyStore = KeyStore.getInstance(keyStoreType);
        try (InputStream tsFileInputStream = ResourceUtils.getInputStream((Object)this, (String)this.storeFile);){
            keyStore.load(tsFileInputStream, StringUtils.isEmpty((String)this.storePassword) ? new char[]{} : this.storePassword.toCharArray());
        }
        return keyStore;
    }

    @Override
    protected void updateKeyAlias(String keyAlias) {
        this.keyAlias = keyAlias;
    }

    public String getType() {
        return this.type;
    }

    public String getStoreFile() {
        return this.storeFile;
    }

    public String getStorePassword() {
        return this.storePassword;
    }

    @Override
    public String getKeyPassword() {
        return this.keyPassword;
    }

    @Override
    public String getKeyAlias() {
        return this.keyAlias;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setStoreFile(String storeFile) {
        this.storeFile = storeFile;
    }

    public void setStorePassword(String storePassword) {
        this.storePassword = storePassword;
    }

    public void setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
    }

    public void setKeyAlias(String keyAlias) {
        this.keyAlias = keyAlias;
    }

    public String toString() {
        return "KeystoreSslCredentials(type=" + this.getType() + ", storeFile=" + this.getStoreFile() + ", storePassword=" + this.getStorePassword() + ", keyPassword=" + this.getKeyPassword() + ", keyAlias=" + this.getKeyAlias() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeystoreSslCredentials)) {
            return false;
        }
        KeystoreSslCredentials other = (KeystoreSslCredentials)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$storeFile = this.getStoreFile();
        String other$storeFile = other.getStoreFile();
        if (this$storeFile == null ? other$storeFile != null : !this$storeFile.equals(other$storeFile)) {
            return false;
        }
        String this$storePassword = this.getStorePassword();
        String other$storePassword = other.getStorePassword();
        if (this$storePassword == null ? other$storePassword != null : !this$storePassword.equals(other$storePassword)) {
            return false;
        }
        String this$keyPassword = this.getKeyPassword();
        String other$keyPassword = other.getKeyPassword();
        if (this$keyPassword == null ? other$keyPassword != null : !this$keyPassword.equals(other$keyPassword)) {
            return false;
        }
        String this$keyAlias = this.getKeyAlias();
        String other$keyAlias = other.getKeyAlias();
        return !(this$keyAlias == null ? other$keyAlias != null : !this$keyAlias.equals(other$keyAlias));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KeystoreSslCredentials;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $storeFile = this.getStoreFile();
        result = result * 59 + ($storeFile == null ? 43 : $storeFile.hashCode());
        String $storePassword = this.getStorePassword();
        result = result * 59 + ($storePassword == null ? 43 : $storePassword.hashCode());
        String $keyPassword = this.getKeyPassword();
        result = result * 59 + ($keyPassword == null ? 43 : $keyPassword.hashCode());
        String $keyAlias = this.getKeyAlias();
        result = result * 59 + ($keyAlias == null ? 43 : $keyAlias.hashCode());
        return result;
    }
}

